/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oracle.adfmf.framework.FeatureContextManagerFactory;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class JavaFramework {
    protected static String incomingApplicationArgs = null;
    protected static Map classpaths = new HashMap();

    private static List parseFeatureArgs(String[] stringArray) {
        ArrayList<FeatureArg> arrayList = new ArrayList<FeatureArg>();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                arrayList.add(new FeatureArg(stringArray[i]));
                continue;
            }
            catch (Exception exception) {
                if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) continue;
                Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$framework$JavaFramework == null ? JavaFramework.class$("oracle.adfmf.framework.JavaFramework") : class$oracle$adfmf$framework$JavaFramework, "parseFeatureArgs", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40051", new Object[]{stringArray[i]});
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static String[] getClassPaths(String string) {
        return (String[])classpaths.get(string);
    }

    public static void main(String[] stringArray) throws Exception {
        block19: {
            block18: {
                TimeZone timeZone = TimeZone.getDefault();
                String string = null;
                String string2 = System.getProperty("redirectLoggingFilename");
                if (!Utility.isEmpty(string2)) {
                    Utility.redirectLogging(string2, true);
                }
                Utility.readLoggerConfig();
                try {
                    string = System.getProperty("user.timezone");
                    timeZone.setID(string);
                    TimeZone.setDefault(timeZone);
                    if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                        Trace.log(Utility.FrameworkLogger, Level.INFO, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40125", new Object[]{string});
                    }
                }
                catch (Throwable throwable) {
                    if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block18;
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40128", new Object[]{string, throwable});
                }
            }
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40069");
                Trace.log(Utility.FrameworkLogger, Level.INFO, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40039");
            }
            if (Utility.getOSFamily() == 1 && Utility.getChannelSide() == 0) {
                try {
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, JavaFramework.class, "main", (Object)"Calling System.loadLibrary(libvmchannel)");
                    }
                    System.loadLibrary("vmchannel");
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, JavaFramework.class, "main", (Object)"Called System.loadLibrary(libvmchannel)");
                    }
                }
                catch (Throwable throwable) {
                    if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block19;
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40127", new Object[]{throwable});
                }
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$JavaFramework == null ? JavaFramework.class$("oracle.adfmf.framework.JavaFramework") : class$oracle$adfmf$framework$JavaFramework, "main", "JavaFramework.main arg:", new Object[]{stringArray[i] != null ? stringArray[i] : "null"});
                }
            }
            String[] stringArray2 = null;
            incomingApplicationArgs = stringArray[0];
            List list = JavaFramework.parseFeatureArgs(stringArray);
            stringArray2 = new String[list.size()];
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40070", new Object[]{new Integer(stringArray2.length)});
            }
            int n = -1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FeatureArg featureArg = (FeatureArg)iterator.next();
                stringArray2[++n] = featureArg.getName();
                classpaths.put(stringArray2[n], featureArg.getClassPaths());
                if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) continue;
                Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$JavaFramework == null ? JavaFramework.class$("oracle.adfmf.framework.JavaFramework") : class$oracle$adfmf$framework$JavaFramework, "main", "Feature: {0} with name: {1}", new Object[]{new Integer(n), stringArray2[n]});
            }
            FeatureContextManagerFactory.getInstance(stringArray2);
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, JavaFramework.class, "main", (Object)"Feature Context Manager has been started.");
            }
        } else if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, JavaFramework.class, "main", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40071");
        }
    }

    private static class FeatureArg
    implements Comparable {
        private int id;
        private String name;
        private String[] classPaths;

        public FeatureArg(String string) {
            this.parse(string);
        }

        public int compareTo(Object object) {
            FeatureArg featureArg = (FeatureArg)object;
            if (this.id < featureArg.id) {
                return -1;
            }
            return 1;
        }

        public String getName() {
            return this.name;
        }

        public String[] getClassPaths() {
            return this.classPaths;
        }

        private void parse(String string) {
            if (string == null) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11092"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11093"));
            }
            this.parseIdNamePair(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                this.parseClassPaths(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11093"));
            }
        }

        private void parseIdNamePair(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            if (stringTokenizer.countTokens() != 2) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11093"));
            }
            try {
                this.id = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11093"));
            }
            this.name = stringTokenizer.nextToken();
        }

        private void parseClassPaths(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.classPaths = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                this.classPaths[n++] = stringTokenizer.nextToken();
            }
        }
    }
}

