/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.util.HashMap;
import oracle.adfmf.framework.AdfChannel;
import oracle.adfmf.framework.AdfControlChannel;
import oracle.adfmf.framework.FeatureContext;
import oracle.adfmf.framework.FeatureContextAccessor;
import oracle.adfmf.framework.FeatureContextFactory;
import oracle.adfmf.framework.contract.adf.AdfMessageHandlerFactory;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.message.SystemRequestHandler;
import oracle.adfmf.framework.message.adf.AdfRequestHandler;
import oracle.adfmf.framework.message.adf.AdfResponse;
import oracle.adfmf.framework.message.adf.AdfSystemRequest;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public abstract class FeatureContextManager
implements SystemRequestHandler,
FeatureContextAccessor {
    public static final String CONTROL_CHANNEL_FC = "_Control_Channel_";
    public static final String BACK_CHANNEL_FC = "_Back_Communication_Channel_";
    static final String EMBEDDED_FCM_TYPE = "oracle.adfmf.framework.EmbeddedFeatureContextManager";
    static final String NATIVE_FCM_TYPE = "oracle.adfmf.framework.NativeFeatureContextManager";
    protected HashMap featureContext = new HashMap();
    protected AdfControlChannel channel = null;
    protected String[] featureNames = null;
    protected ClassLoader applicationClassLoader = null;

    protected FeatureContextManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureContextManager(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, FeatureContextManager.class, "FeatureContextManager", (Object)"No feature name was passed in. No Feature Context is created.");
            }
        } else {
            this.featureNames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.featureNames[i] = stringArray[i];
            }
            this.registerAdfElContext();
            if (!stringArray[0].equalsIgnoreCase(CONTROL_CHANNEL_FC) && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, FeatureContextManager.class, "FeatureContextManager", "oracle.adfmf.resource.SharedInfoBundle", "ADF-MF-40004", new Object[]{CONTROL_CHANNEL_FC});
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, FeatureContextManager.class, "FeatureContextManager", (Object)"Creating the application common class loader (if needed)");
            }
            this.registerApplicationClassLoader();
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, FeatureContextManager.class, "FeatureContextManager", "FCM initialize - pre-register the feature {0} : {1}", new Object[]{new Integer(0), stringArray[0]});
            }
            HashMap hashMap = this.featureContext;
            synchronized (hashMap) {
                if (this.featureContext.get(stringArray[0]) == null) {
                    this.featureContext.put(stringArray[0], FeatureContextFactory.createFeatureContext(this, 0, stringArray[0]));
                }
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, FeatureContextManager.class, "FeatureContextManager", "FCM initialize - pre-register the feature {0} : {1}", new Object[]{new Integer(stringArray.length - 1), stringArray[stringArray.length - 1]});
            }
            hashMap = this.featureContext;
            synchronized (hashMap) {
                if (this.featureContext.get(stringArray[stringArray.length - 1]) == null) {
                    this.featureContext.put(stringArray[stringArray.length - 1], FeatureContextFactory.createFeatureContext(this, stringArray.length - 1, stringArray[stringArray.length - 1]));
                }
            }
            for (int i = 1; i < stringArray.length - 1; ++i) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$FeatureContextManager == null ? FeatureContextManager.class$("oracle.adfmf.framework.FeatureContextManager") : class$oracle$adfmf$framework$FeatureContextManager, "FeatureContextManager", "FCM initialize - pre-register the feature {0} : {1}", new Object[]{new Integer(i), stringArray[i]});
                }
                HashMap hashMap2 = this.featureContext;
                synchronized (hashMap2) {
                    if (this.featureContext.get(stringArray[i]) == null) {
                        this.featureContext.put(stringArray[i], FeatureContextFactory.createFeatureContext(this, i, stringArray[i]));
                    }
                    continue;
                }
            }
        }
    }

    public void registerFeatureContext(int n) {
    }

    public AdfResponse handle(AdfSystemRequest adfSystemRequest) {
        AdfResponse adfResponse = null;
        try {
            AdfRequestHandler adfRequestHandler = AdfMessageHandlerFactory.getAdfRequestHandler(adfSystemRequest, this.getClass());
            adfResponse = adfRequestHandler.process(this);
        }
        catch (AdfException adfException) {
            adfResponse = AdfMessageHandlerFactory.getErrorResponse(adfSystemRequest, adfException);
        }
        catch (Exception exception) {
            adfResponse = AdfMessageHandlerFactory.getErrorResponse(adfSystemRequest, new AdfException(exception));
        }
        return adfResponse;
    }

    public AdfControlChannel getAdfControlChannel() {
        return this.channel;
    }

    public AdfChannel getAdfChannel() {
        FeatureContext featureContext = this.getFeatureContext(CONTROL_CHANNEL_FC);
        return featureContext.getAdfChannel();
    }

    public AdfChannel getBackChannel() {
        FeatureContext featureContext = this.getFeatureContext(BACK_CHANNEL_FC);
        return featureContext.getAdfChannel();
    }

    public FeatureContext getFeatureContext(String string) {
        return (FeatureContext)this.featureContext.get(string);
    }

    protected void registerAdfElContext() {
    }

    protected void registerApplicationClassLoader() {
    }

    protected String getFeatureName(int n) {
        if (n == 0) {
            return CONTROL_CHANNEL_FC;
        }
        return n < this.featureNames.length ? this.featureNames[n] : "UNKNOWN-FEATURE-" + n;
    }

    public String getName() {
        return CONTROL_CHANNEL_FC;
    }

    public void resetFeatureContext(FeatureContext featureContext) {
        FeatureContext featureContext2 = FeatureContextFactory.createFeatureContext(this, featureContext.id, featureContext.name);
        this.deleteFeatureContext(featureContext);
        this.featureContext.put(featureContext2.getName(), featureContext2);
    }

    public void checkStatusAndFinalizeInitialization() {
    }

    protected void deleteFeatureContext(FeatureContext featureContext) {
        this.featureContext.remove(featureContext.getName());
    }
}

