/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.adf.model.datacontrols.device.DevicePropertiesProxy;
import oracle.adf.model.datacontrols.device.PreferenceScope;
import oracle.adfmf.dc.rules.ValidationContext;
import oracle.adfmf.framework.ApplicationScope;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.FeatureContext;
import oracle.adfmf.framework.FeatureContextManager;
import oracle.adfmf.framework.JavaFramework;
import oracle.adfmf.framework.event.DataChangeManager;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class EmbeddedFeatureContextManager
extends FeatureContextManager {
    protected AdfELContext adfElContext;

    protected static URL[] getPathURLsFromPathNames(String[] stringArray) {
        URL[] uRLArray = null;
        try {
            if (stringArray != null) {
                uRLArray = new URL[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    uRLArray[i] = file.toURL();
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, EmbeddedFeatureContextManager.class, "getPathURLsFromPathNames", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40052", new Object[]{malformedURLException.getMessage()});
            }
            uRLArray = null;
        }
        return uRLArray != null ? uRLArray : new URL[]{};
    }

    public EmbeddedFeatureContextManager(String[] stringArray) {
        super(stringArray);
        this.registerAdfSpecificScopes(this.adfElContext);
    }

    public AdfELContext getAdfELContext() {
        return this.adfElContext;
    }

    public void setAdfELContext(AdfELContext adfELContext) {
        this.adfElContext = adfELContext;
    }

    protected void registerAdfElContext() {
        this.adfElContext = new AdfELContext(null);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, EmbeddedFeatureContextManager.class, "registerAdfElContext", (Object)"ADF EL Context is now created.");
        }
    }

    protected void registerApplicationClassLoader() {
        String[] stringArray = JavaFramework.getClassPaths("_Control_Channel_");
        URL[] uRLArray = EmbeddedFeatureContextManager.getPathURLsFromPathNames(stringArray);
        this.applicationClassLoader = URLClassLoader.newInstance(uRLArray, ClassLoader.getSystemClassLoader());
    }

    private void registerAdfSpecificScopes(AdfELContext adfELContext) {
        adfELContext.setVariable("applicationScope", new ApplicationScope("applicationScope"), Map.class);
        adfELContext.setVariable("deviceScope", new DevicePropertiesProxy(), Map.class);
        adfELContext.setVariable("preferenceScope", new PreferenceScope(), Map.class);
        adfELContext.setVariable("shareScope", new HashMap(), Map.class);
        adfELContext.setVariable("validationScope", new ValidationContext("readOnly", true), Map.class);
    }

    public DataChangeManager getDataChangeManager() {
        EmbeddedFeatureContext embeddedFeatureContext = (EmbeddedFeatureContext)this.featureContext.get("_Control_Channel_");
        return embeddedFeatureContext == null ? null : embeddedFeatureContext.getDataChangeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationPropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        HashMap hashMap = this.featureContext;
        synchronized (hashMap) {
            Iterator iterator = this.featureContext.values().iterator();
            while (iterator.hasNext()) {
                EmbeddedFeatureContext embeddedFeatureContext = (EmbeddedFeatureContext)iterator.next();
                if (embeddedFeatureContext == null) continue;
                embeddedFeatureContext.getDataChangeManager().enqueue(embeddedFeatureContext.getName(), propertyChangeEvent);
            }
        }
    }

    public void shutdown() {
        MonitorFactory.stopReportingStatistics();
    }

    protected void deleteFeatureContext(FeatureContext featureContext) {
    }
}

