/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.oracle.cvm.channel.VMChannel;
import com.oracle.cvm.channel.VMChannelManager;
import com.oracle.cvm.channel.VMChannelManagerFactory;
import com.oracle.cvm.channel.VMMessage;
import com.oracle.cvm.channel.VMMessageHandler;
import com.oracle.cvm.channel.impl.VMMessageImpl;
import com.sun.util.logging.Level;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import oracle.adfmf.framework.PendingRequest;
import oracle.adfmf.framework.contract.adf.AdfMessageHandlerFactory;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.InvalidResponseSentException;
import oracle.adfmf.framework.exception.UnhandledAdfMessageException;
import oracle.adfmf.framework.message.ApplicationRequestHandler;
import oracle.adfmf.framework.message.SystemRequestHandler;
import oracle.adfmf.framework.message.adf.AdfApplicationRequest;
import oracle.adfmf.framework.message.adf.AdfMessage;
import oracle.adfmf.framework.message.adf.AdfRequest;
import oracle.adfmf.framework.message.adf.AdfResponse;
import oracle.adfmf.framework.message.adf.AdfResponseHandler;
import oracle.adfmf.framework.message.adf.AdfSystemRequest;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class AdfChannel
implements VMMessageHandler {
    private static final boolean DEBUG_TRAFFIC = false;
    private static final int MAX_RETRIES = 3;
    private static final int NORMAL_MSG_TYPE = 0;
    private static final int NORMAL_MSG_PRIORITY = 2;
    private static long s_msgCount = 0L;
    protected int id = 0;
    protected ApplicationRequestHandler appHandler = null;
    protected SystemRequestHandler sysHandler = null;
    protected VMChannel channel = null;
    protected Hashtable processing = null;

    AdfChannel(int n, SystemRequestHandler systemRequestHandler, ApplicationRequestHandler applicationRequestHandler) {
        this.id = n;
        this.processing = new Hashtable();
        this.appHandler = applicationRequestHandler;
        this.sysHandler = systemRequestHandler;
        this.channel = null;
        this.channel = this.getVMChannel();
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "AdfChannel", "AdfChannel[{0}] initialization is now done.", new Object[]{new Integer(n)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(VMMessage vMMessage) {
        AdfResponse adfResponse = null;
        Monitor monitor = MonitorFactory.getInstance().getMonitor(this.getClass().getName() + ":handle", "AdfChannel request processing");
        monitor.start();
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfChannel.class, "handle", (Object)"In AdfChannel.handle");
        }
        try {
            block29: {
                try {
                    AdfMessage adfMessage = AdfMessageHandlerFactory.getAdfMessage(new String(vMMessage.getBody().getData(), "UTF8"));
                    if (adfMessage.isRequestMessage()) {
                        try {
                            try {
                                if (adfMessage.isSystemRequest() && this.sysHandler != null) {
                                    adfResponse = this.sysHandler.handle((AdfSystemRequest)adfMessage);
                                } else {
                                    if (adfMessage.isSystemRequest()) throw new UnhandledAdfMessageException(adfMessage.getHeader().getReferenceId(), adfMessage.getHeader().getType());
                                    if (this.appHandler == null) throw new UnhandledAdfMessageException(adfMessage.getHeader().getReferenceId(), adfMessage.getHeader().getType());
                                    adfResponse = this.appHandler.handle((AdfApplicationRequest)adfMessage);
                                }
                                Object var8_7 = null;
                                if (adfResponse == null) break block29;
                            }
                            catch (AdfException adfException) {
                                adfResponse = AdfMessageHandlerFactory.getErrorResponse((AdfRequest)adfMessage, adfException);
                                adfResponse.setResponseReady(true);
                                Object var8_8 = null;
                                if (adfResponse != null && adfResponse.isResponseReady()) {
                                    if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                                        Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "handle", "AdfChannel response = {0}", new Object[]{adfResponse.toString()});
                                    }
                                    this.send(vMMessage.getHeader().getPriority(), adfResponse);
                                }
                                break block29;
                            }
                            catch (Exception exception) {
                                AdfException adfException = new AdfException(exception);
                                adfResponse = AdfMessageHandlerFactory.getErrorResponse((AdfRequest)adfMessage, adfException);
                                adfResponse.setResponseReady(true);
                                Object var8_9 = null;
                                if (adfResponse != null && adfResponse.isResponseReady()) {
                                    if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                                        Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "handle", "AdfChannel response = {0}", new Object[]{adfResponse.toString()});
                                    }
                                    this.send(vMMessage.getHeader().getPriority(), adfResponse);
                                }
                                break block29;
                            }
                            if (!adfResponse.isResponseReady()) break block29;
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            if (adfResponse == null) throw throwable;
                            if (!adfResponse.isResponseReady()) throw throwable;
                            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                                Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "handle", "AdfChannel response = {0}", new Object[]{adfResponse.toString()});
                            }
                            this.send(vMMessage.getHeader().getPriority(), adfResponse);
                            throw throwable;
                        }
                        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "handle", "AdfChannel response = {0}", new Object[]{adfResponse.toString()});
                        }
                        this.send(vMMessage.getHeader().getPriority(), adfResponse);
                        break block29;
                    }
                    if (!adfMessage.isResponseMessage()) break block29;
                    Integer n = new Integer(adfMessage.getHeader().getCorrelationId());
                    PendingRequest pendingRequest = (PendingRequest)this.processing.remove(n);
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfChannel.class, "handle", (Object)("Channel " + this.id + ": Pending requests hash size: " + this.processing.size()));
                    }
                    if (pendingRequest != null) {
                        AdfResponseHandler adfResponseHandler = pendingRequest.getHandler();
                        adfResponseHandler.setResponse((AdfResponse)adfMessage);
                        if (pendingRequest.isSynchronous()) {
                            Thread thread = pendingRequest.getThread();
                            synchronized (thread) {
                                pendingRequest.getThread().notify();
                                break block29;
                            }
                        } else {
                            adfResponseHandler.process();
                        }
                        break block29;
                    }
                    if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                        Trace.log(Utility.FrameworkLogger, Level.WARNING, AdfChannel.class, "handle", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40061", new Object[]{adfMessage});
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfChannel.class, "handle", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11072", new Object[]{vMMessage});
                    }
                    Object var11_20 = null;
                    monitor.addObservation();
                    return;
                }
                catch (AdfException adfException) {
                    if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                        Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfChannel.class, "handle", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11072", new Object[]{vMMessage});
                    }
                    Object var11_21 = null;
                    monitor.addObservation();
                    return;
                }
            }
            Object var11_19 = null;
            monitor.addObservation();
            return;
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            monitor.addObservation();
            throw throwable;
        }
    }

    public void send(int n, AdfResponse adfResponse) throws AdfException {
        if (adfResponse != null && adfResponse.isResponseReady()) {
            try {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "send", "Calling getVMChannel().sendMessage [{0}]; Response = {1}", new Object[]{new Integer(this.id), adfResponse.toString()});
                }
                this.getVMChannel().sendMessage(this.createNewVMMessage(adfResponse));
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "send", "Called getVMChannel().sendMessage [{0}]", new Object[]{new Integer(this.id)});
                }
            }
            catch (Throwable throwable) {
                if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfChannel.class, "send", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11071", new Object[]{new Integer(this.id), throwable});
                }
                this.clearVMChannel();
            }
        } else {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfChannel.class, "send", (Object)"InvalidResponseSentException");
            }
            throw new InvalidResponseSentException(adfResponse);
        }
    }

    public void send(int n, AdfRequest adfRequest, AdfResponseHandler adfResponseHandler, boolean bl) {
        Integer n2 = new Integer(adfRequest.getHeader().getReferenceId());
        PendingRequest pendingRequest = new PendingRequest(adfRequest, adfResponseHandler, bl);
        this.processing.put(n2, pendingRequest);
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, AdfChannel.class, "send", (Object)("Channel " + this.id + "Pending requests hash size: " + this.processing.size()));
        }
        try {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "send", "AdfChannel.send request on channel [{0}] START", new Object[]{new Integer(this.id)});
            }
            this.getVMChannel().sendMessage(this.createNewVMMessage(adfRequest));
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "send", "AdfChannel.send request on channel [{0}] END", new Object[]{new Integer(this.id)});
            }
        }
        catch (Throwable throwable) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AdfChannel.class, "send", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11071", new Object[]{new Integer(this.id), throwable});
            }
            this.clearVMChannel();
        }
    }

    public VMMessage createNewVMMessage(AdfMessage adfMessage) {
        try {
            return new VMMessageImpl(0, 2, -1, 3, ((Object)adfMessage).toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AdfException(unsupportedEncodingException);
        }
    }

    void clearVMChannel() {
        this.channel = null;
    }

    public void setVMChannel(VMChannel vMChannel) {
        this.channel = vMChannel;
    }

    public String toString() {
        return "AdfChannel[" + this.id + "]";
    }

    VMChannel getVMChannel() {
        if (this.id != 0 && this.channel == null) {
            int n = 1;
            do {
                try {
                    VMChannelManager vMChannelManager = VMChannelManagerFactory.getChannelManager();
                    if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$AdfChannel == null ? AdfChannel.class$("oracle.adfmf.framework.AdfChannel") : class$oracle$adfmf$framework$AdfChannel, "getVMChannel", "AdfChannel[{0}]: Attempting to create the underlying channel.", new Object[]{new Integer(this.id)});
                    }
                    if ((this.channel = vMChannelManager.getChannel(this.id)) != null) {
                        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                            Trace.log(Utility.FrameworkLogger, Level.INFO, class$oracle$adfmf$framework$AdfChannel == null ? AdfChannel.class$("oracle.adfmf.framework.AdfChannel") : class$oracle$adfmf$framework$AdfChannel, "getVMChannel", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40044", new Object[]{new Integer(this.id)});
                        }
                        this.channel.startListening((VMMessageHandler)this);
                        if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) continue;
                        Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$framework$AdfChannel == null ? AdfChannel.class$("oracle.adfmf.framework.AdfChannel") : class$oracle$adfmf$framework$AdfChannel, "getVMChannel", "AdfChannel[{0}]: Return from start listening on channel", new Object[]{new Integer(this.id)});
                        continue;
                    }
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                        Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$framework$AdfChannel == null ? AdfChannel.class$("oracle.adfmf.framework.AdfChannel") : class$oracle$adfmf$framework$AdfChannel, "getVMChannel", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40062", new Object[]{new Integer(this.id), new Integer(n), new Integer(3), throwable});
                    }
                    this.channel = null;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            } while (this.channel == null && n++ < 3);
            if (this.channel == null && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, AdfChannel.class, "getVMChannel", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40063", new Object[]{new Integer(this.id)});
            }
        } else if (this.id == 0) {
            if (this.channel != null) {
                // empty if block
            }
        } else if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, AdfChannel.class, "getVMChannel", "AdfChannel[{0}]: getChannel  returning.", new Object[]{new Integer(this.id)});
        }
        return this.channel;
    }
}

