/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws.soap;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import oracle.adfmf.dc.ws.WebServiceTransportLayer;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationRuntimeException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;
import oracle.ksoap2.transport.HttpTransport;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.SoapFault;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;

public class SoapTransportLayer
extends WebServiceTransportLayer {
    public static final int REQUEST_SOAP_1_0 = 100;
    public static final int REQUEST_SOAP_1_1 = 110;
    public static final int REQUEST_SOAP_1_2 = 120;
    protected int version = 110;
    protected String m_wsdl = null;
    protected boolean m_isInputDocLitBare = true;
    protected boolean m_elementQualified = false;
    protected SoapFault m_soapfault = null;
    private Exception m_exception = null;
    private String m_action = null;
    private String m_service = null;
    private String m_port = null;
    private String m_policyUri = null;

    public SoapTransportLayer(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public static int getSoapVersionFlag(String string) {
        if ("1.0".equals(string)) {
            return 100;
        }
        if ("1.1".equals(string)) {
            return 110;
        }
        if ("1.2".equals(string)) {
            return 120;
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11100", new Object[]{string});
    }

    protected String getWsdl() {
        return this.m_wsdl;
    }

    protected void setWsdl(String string) {
        this.m_wsdl = string;
    }

    protected SoapFault getSoapFault() {
        return this.m_soapfault;
    }

    protected void setElementQualified(String string) {
        this.setElementQualified(Utility.stringToBool(string, false));
    }

    protected void setElementQualified(boolean bl) {
        this.m_elementQualified = bl;
    }

    protected String getSoapAction() {
        return this.m_action;
    }

    protected void setSoapAction(String string) {
        this.m_action = "\"" + string + "\"";
    }

    protected SoapObject getSoapMethod() {
        return this.getSoapObject(this.namespace, this.operation, this.parameters);
    }

    protected SoapObject getSoapObject(String string, String string2, HashMap hashMap) {
        Set set = hashMap.keySet();
        SoapObject soapObject = new SoapObject(string, string2);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = hashMap.get(string3).toString();
                if (string4 == null) continue;
                soapObject.addProperty(string3, (Object)string4);
            }
        }
        return soapObject;
    }

    protected String dumpSoapObject(int n, String string, SoapObject soapObject) {
        int n2 = soapObject.getPropertyCount();
        String string2 = this.getIndent(n);
        string2 = string2 + "Soap Object [name = " + string + "  namespace = " + soapObject.getNamespace() + "]\n";
        for (int i = 0; i < n2; ++i) {
            try {
                SoapObject soapObject2 = (SoapObject)soapObject.getProperty(i);
                string2 = string2 + this.dumpSoapObject(n + 1, soapObject2.getName(), soapObject2);
                continue;
            }
            catch (Exception exception) {
                try {
                    PropertyInfo propertyInfo = new PropertyInfo();
                    soapObject.getPropertyInfo(i, null, propertyInfo);
                    string2 = string2 + this.getIndent(n) + "p[" + propertyInfo.namespace + "/" + propertyInfo.name + "] = " + soapObject.getProperty(i);
                    continue;
                }
                catch (Exception exception2) {
                    string2 = string2 + this.getIndent(n) + "p[" + i + "] = " + soapObject.getProperty(i);
                }
            }
        }
        return string2;
    }

    protected String dumpSoapObject(String string, SoapObject soapObject) {
        String string2 = "\n";
        string2 = string2 + "---------------------------\n";
        string2 = string2 + string;
        string2 = string2 + "---------------------------\n";
        string2 = string2 + (soapObject == null ? "SoapObject is null" : this.dumpSoapObject(1, soapObject.getName(), soapObject));
        string2 = string2 + "---------------------------\n";
        return string2;
    }

    /*
     * Loose catch block
     */
    protected Object invokeSoapRequest(SoapEnvelope soapEnvelope) throws Exception {
        Object object;
        block25: {
            HttpTransport httpTransport = null;
            object = null;
            long l = 0L;
            long l2 = 0L;
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, SoapTransportLayer.class, "invokeSoapRequest", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40012", new Object[]{this.getSoapAction(), this.getEndpoint()});
            }
            this.m_soapfault = null;
            this.m_exception = null;
            if (soapEnvelope != null) {
                block24: {
                    try {
                        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINER, SoapTransportLayer.class, "invokeSoapRequest", "Creating a connection to: {0}", new Object[]{this.getEndpoint()});
                        }
                        httpTransport = this.getHttpTransport();
                        l = System.currentTimeMillis();
                        if (this.getDebug() && Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                            Trace.log(Utility.FrameworkLogger, Level.FINER, SoapTransportLayer.class, "invokeSoapRequest", "Web Service {0} starting at {1}", new Object[]{this.getSoapAction(), new Long(l)});
                        }
                        httpTransport.debug = this.getDebug();
                        httpTransport.call(this.getSoapAction(), soapEnvelope);
                        Object var12_6 = null;
                    }
                    catch (Throwable throwable) {
                        block26: {
                            Object var12_7 = null;
                            l2 = System.currentTimeMillis();
                            if (this.getDebug() && Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                                Trace.log(Utility.FrameworkLogger, Level.FINEST, SoapTransportLayer.class, "invokeSoapRequest", "Web Service {0} completed a {1} for a duration of {2} milliseconds", new Object[]{this.getSoapAction(), new Long(l2), new Long(l2 - l)});
                            }
                            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                                Trace.log(Utility.FrameworkLogger, Level.FINEST, SoapTransportLayer.class, "invokeSoapRequest", "------ Actual transport call handling complete at {0}. ----------", new Object[]{new Long(l2)});
                            }
                            if (httpTransport != null) {
                                try {
                                    this.setStatus(httpTransport.getResponseCode());
                                    object = soapEnvelope.bodyIn;
                                    this.setResponseContentType(httpTransport.getResponseContentType());
                                }
                                catch (Exception exception) {
                                    if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) break block26;
                                    Trace.log(Utility.FrameworkLogger, Level.FINE, SoapTransportLayer.class, "invokeSoapRequest", "Post action exception {0}", new Object[]{exception});
                                }
                            }
                        }
                        httpTransport = null;
                        throw throwable;
                    }
                    l2 = System.currentTimeMillis();
                    if (this.getDebug() && Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, SoapTransportLayer.class, "invokeSoapRequest", "Web Service {0} completed a {1} for a duration of {2} milliseconds", new Object[]{this.getSoapAction(), new Long(l2), new Long(l2 - l)});
                    }
                    if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                        Trace.log(Utility.FrameworkLogger, Level.FINEST, SoapTransportLayer.class, "invokeSoapRequest", "------ Actual transport call handling complete at {0}. ----------", new Object[]{new Long(l2)});
                    }
                    if (httpTransport != null) {
                        try {
                            this.setStatus(httpTransport.getResponseCode());
                            object = soapEnvelope.bodyIn;
                            this.setResponseContentType(httpTransport.getResponseContentType());
                        }
                        catch (Exception exception) {
                            if (!Utility.FrameworkLogger.isLoggable(Level.FINE)) break block24;
                            Trace.log(Utility.FrameworkLogger, Level.FINE, SoapTransportLayer.class, "invokeSoapRequest", "Post action exception {0}", new Object[]{exception});
                        }
                    }
                }
                httpTransport = null;
                {
                    break block25;
                    catch (SoapFault soapFault) {
                        if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                            Trace.log(Utility.FrameworkLogger, Level.SEVERE, SoapTransportLayer.class, "invokeSoapRequest", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11020", new Object[]{this.operation, soapFault.faultcode, soapFault.faultstring});
                        }
                        this.m_soapfault = soapFault;
                        this.m_exception = new AdfInvocationRuntimeException(soapFault, "ERROR", "WEBSERVICE", 500);
                        throw this.m_exception;
                    }
                    catch (Exception exception) {
                        String string = null;
                        int n = -1;
                        if (null != httpTransport && httpTransport.getResponseCode() != 200) {
                            n = httpTransport.getResponseCode();
                            string = httpTransport.getResponseMessage();
                            if (Utility.isEmpty(string)) {
                                string = exception.getMessage();
                            }
                        } else {
                            string = Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11028", new Object[]{this.operation, new Integer(n), exception.getMessage()});
                        }
                        if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                            Trace.log(Utility.FrameworkLogger, Level.SEVERE, SoapTransportLayer.class, "invokeSoapRequest", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11057", new Object[]{this.getEndpoint(), this.getSoapAction(), string});
                        }
                        this.m_exception = new AdfInvocationRuntimeException(string, "ERROR", "WEBSERVICE", n);
                        throw this.m_exception;
                    }
                }
            }
        }
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, SoapTransportLayer.class, "invokeSoapRequest", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40013", new Object[]{this.operation});
        }
        return object;
    }

    private HttpTransport getHttpTransport() {
        HttpTransport httpTransport = null;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, SoapTransportLayer.class, "getHttpTransport", (Object)"Establishing a non-authenticated connection.");
        }
        httpTransport = new HttpTransport(this.getEndpoint(), this.getService(), this.getPort(), this.isSecureConnection() ? this.getCredStoreKey() : null, this.getPolicyUri());
        return httpTransport;
    }

    protected String getService() {
        return this.m_service;
    }

    protected void setService(String string) {
        this.m_service = string;
    }

    protected String getPort() {
        return this.m_port;
    }

    protected void setPort(String string) {
        this.m_port = string;
    }

    protected String getPolicyUri() {
        return this.m_policyUri;
    }

    protected void setPolicyUri(String string) {
        this.m_policyUri = string;
    }
}

