/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws;

import com.sun.util.logging.Level;
import java.util.Map;
import oracle.adf.model.adapter.rest.RestDCDefinition;
import oracle.adf.model.adapter.rest.RestURLDCDefinition;
import oracle.adfinternal.model.adapter.url.URLDCDefinition;
import oracle.adfinternal.model.adapter.url.xml.XMLDCDef;
import oracle.adfinternal.model.adapter.webservice.WSDefinition;
import oracle.adfmf.bindings.OperationBinding;
import oracle.adfmf.bindings.OperationDelegate;
import oracle.adfmf.bindings.dbf.AmxInvokeMethod;
import oracle.adfmf.dc.GenericJavaBeanDataControlAdapter;
import oracle.adfmf.dc.ws.WebServiceObject;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.dcx.AdapterDataControlDefinition;
import oracle.adfmf.metadata.page.AccessorIteratorDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

public abstract class WebServiceDataControlAdapter
extends GenericJavaBeanDataControlAdapter {
    protected abstract void loadDataControlDefinition(AdapterDataControlDefinition var1);

    protected abstract boolean isSupported(AdapterDataControlDefinition var1);

    public WebServiceDataControlAdapter() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "WebServiceDataControlAdapter", "Creating WebServiceDataControlAdapter");
        }
    }

    public boolean invokeOperation(Map map, OperationBinding operationBinding) {
        AmxInvokeMethod amxInvokeMethod = (AmxInvokeMethod)operationBinding.getOperationInfo();
        if (amxInvokeMethod == null) {
            return false;
        }
        OperationDelegate operationDelegate = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getOperationDelegateManager().getCustomOperation(this, this.getName(), amxInvokeMethod.getOperationName());
        if (operationDelegate == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, "invokeOperation", "ADF-MF-11004", new Object[]{amxInvokeMethod.getOperationName(), amxInvokeMethod.getOperationName()});
            }
            return false;
        }
        Object object = operationDelegate.execute(amxInvokeMethod.getInvokeInstance(), operationBinding.getParamsMap());
        amxInvokeMethod.setResult(object);
        return true;
    }

    public void setDataProvider(Object object) {
        if (this.provider == null) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "setDataProvider", "Setting the data provider for the Web Service Data Control");
            }
            if (null != object) {
                if (object instanceof WSDefinition || object instanceof RestDCDefinition || object instanceof RestURLDCDefinition || object instanceof XMLDCDef || object instanceof URLDCDefinition) {
                    this.provider = new WebServiceObject();
                    AdapterDataControlDefinition adapterDataControlDefinition = new AdapterDataControlDefinition(this.metadataDef);
                    this.loadDataControl(adapterDataControlDefinition.getBeanClass());
                } else if (object instanceof WebServiceObject) {
                    this.provider = (WebServiceObject)object;
                    this.loadDataControl(object.getClass().getName());
                } else if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    this.log(Level.SEVERE, "setDataProvider", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11013", null);
                }
            } else if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                this.log(Level.SEVERE, "setDataProvider", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11012", null);
            }
        }
    }

    public Object createDataProvider(XmlAnyDefinition xmlAnyDefinition) {
        AccessorIteratorDefinition accessorIteratorDefinition;
        WebServiceObject webServiceObject = null;
        if (xmlAnyDefinition != null && null != (accessorIteratorDefinition = new AccessorIteratorDefinition(xmlAnyDefinition))) {
            String string = accessorIteratorDefinition.getBeanClass();
            JavaBeanDefinition javaBeanDefinition = this.mdfm.getJavaBeanDefinitionByName(string);
            webServiceObject = new WebServiceObject(javaBeanDefinition.getPackage(), javaBeanDefinition.getId(), javaBeanDefinition);
        }
        return webServiceObject;
    }
}

