/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.contract.adf.NameValuePair;
import oracle.adfmf.framework.event.FrameworkPropertyChangeListener;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.BatchValidationException;
import oracle.adfmf.framework.exception.ValidationException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.util.Utility;

public class ValidationContext
extends HashMap {
    public static final String VALIDATIONCONTEXT_SCOPE_NAME = "validationScope";
    private static final String NO_LIST_NAME = "removeFromAllLists";
    private static final String INVALID_LIST_NAME = "invalidList";
    private static final String UNSET_LIST_NAME = "unsetList";
    private static final String VALID_LIST_NAME = "validList";
    private static final String INVALID_LIST_FQN = "validationScope.invalidList";
    private static final String UNSET_LIST_FQN = "validationScope.unsetList";
    private static final String VALID_LIST_FQN = "validationScope.validList";
    public static final String INVALID_LIST_EL = "#{validationScope.invalidList}";
    public static final String UNSET_LIST_EL = "#{validationScope.unsetList}";
    public static final String VALID_LIST_EL = "#{validationScope.validList}";
    private ArrayList unsetList = new ArrayList();
    private HashMap invalidList = new HashMap();
    private ArrayList validList = new ArrayList();
    private final boolean readOnly;
    private final String id;
    private static final long serialVersionUID = -8853508252640358029L;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static ValidationContext getInstance() {
        AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
        return (ValidationContext)adfELContext.evaluateVariable(VALIDATIONCONTEXT_SCOPE_NAME);
    }

    public ValidationContext(String string) {
        this(string, false);
    }

    public ValidationContext(String string, boolean bl) {
        this.id = string;
        this.readOnly = bl;
        super.put(INVALID_LIST_NAME, this.invalidList);
        super.put(UNSET_LIST_NAME, this.unsetList);
        super.put(VALID_LIST_NAME, this.validList);
        FrameworkPropertyChangeListener.addFrameworkPropertyChangeListener(this, VALIDATIONCONTEXT_SCOPE_NAME);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    private static AdfException getValidationException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof BatchValidationException) {
            return (BatchValidationException)throwable;
        }
        if (throwable instanceof ValidationException) {
            return (ValidationException)throwable;
        }
        return ValidationContext.getValidationException(throwable.getCause());
    }

    private static ArrayList getExceptionList(AdfException adfException) {
        Object object;
        ArrayList arrayList;
        ArrayList<NameValuePair> arrayList2 = new ArrayList<NameValuePair>();
        if (adfException instanceof ValidationException) {
            arrayList = new ArrayList(1);
            arrayList.add(adfException);
        } else {
            object = (BatchValidationException)adfException;
            arrayList = ((BatchValidationException)object).getValidationExceptions();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            Exception exception = (Exception)object.next();
            if (!(exception instanceof ValidationException)) continue;
            ValidationException validationException = (ValidationException)exception;
            NameValuePair nameValuePair = new NameValuePair();
            String string = validationException.getSeverity();
            nameValuePair.setName(string);
            nameValuePair.setValue(validationException.getLocalizedMessage());
            arrayList2.add(nameValuePair);
        }
        return arrayList2;
    }

    public void addToInvalidList(String string, Exception exception) {
        if (this.readOnly || ValidationContext.isValidationScope(string)) {
            return;
        }
        AdfException adfException = ValidationContext.getValidationException(exception);
        if (adfException == null) {
            return;
        }
        this.updateLists(INVALID_LIST_NAME, string, ValidationContext.getExceptionList(adfException));
    }

    public void addToValidList(String string) {
        if (this.readOnly || ValidationContext.isValidationScope(string)) {
            return;
        }
        this.updateLists(VALID_LIST_NAME, string, null);
    }

    public void addToUnsetList(String string) {
        if (this.readOnly || ValidationContext.isValidationScope(string)) {
            return;
        }
        if (this.validListContains(string) || this.invalidListContains(string)) {
            return;
        }
        this.updateLists(UNSET_LIST_NAME, string, null);
    }

    private void updateLists(String string, String string2, Object object) {
        if (this.invalidList.containsKey(string2)) {
            this.invalidList.remove(string2);
            this.propertyChangeSupport.firePropertyChange(INVALID_LIST_NAME, null, this.invalidList);
        }
        if (INVALID_LIST_NAME.compareTo(string) == 0) {
            this.invalidList.put(string2, object);
            this.propertyChangeSupport.firePropertyChange(INVALID_LIST_NAME, null, this.invalidList);
        }
        if (UNSET_LIST_NAME.compareTo(string) == 0) {
            if (!this.unsetList.contains(string2)) {
                this.unsetList.add(string2);
                this.propertyChangeSupport.firePropertyChange(UNSET_LIST_NAME, null, this.unsetList);
            }
        } else if (this.unsetList.contains(string2)) {
            this.unsetList.remove(string2);
            this.propertyChangeSupport.firePropertyChange(UNSET_LIST_NAME, null, this.unsetList);
        }
        if (VALID_LIST_NAME.compareTo(string) == 0) {
            if (!this.validList.contains(string2)) {
                this.validList.add(string2);
                this.propertyChangeSupport.firePropertyChange(VALID_LIST_NAME, null, this.validList);
            }
        } else if (this.validList.contains(string2)) {
            this.validList.remove(string2);
            this.propertyChangeSupport.firePropertyChange(VALID_LIST_NAME, null, this.validList);
        }
    }

    public ArrayList getUnsetList() {
        return this.unsetList;
    }

    public ArrayList getValidList() {
        return this.validList;
    }

    public HashMap getInvalidList() {
        return this.invalidList;
    }

    public boolean unsetListContains(String string) {
        return this.unsetList.contains(string);
    }

    public boolean validListContains(String string) {
        return this.validList.contains(string);
    }

    public boolean invalidListContains(String string) {
        return this.invalidList.containsKey(string);
    }

    private static boolean isValidationScope(String string) {
        if (Utility.isEmpty(string)) {
            return false;
        }
        int n = 1;
        String string2 = "{validationScope.";
        int n2 = string2.length();
        if (string.length() <= n2 + n) {
            return false;
        }
        return string.substring(n, n2 + n).equalsIgnoreCase(string2);
    }
}

