/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.dc.rules.ValidatorFactory;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.util.EmbeddedUtility;
import oracle.adfmf.util.XmlAnyDefinition;

public class RangeValidator
extends Validator {
    public static final Class CLASS_INSTANCE = RangeValidator.class;
    protected static String validatorID = "validation:RangeValidationBean";
    public static final String PNAME_MinValue = "MinValue";
    public static final String PNAME_MaxValue = "MaxValue";
    private static final String VALIDATION_PREFIX = "RangeValidator";
    protected ValueExpression mExpr = null;
    protected Object m_min = null;
    protected Object m_max = null;

    public static final void registerValidator() {
        ValidatorFactory.registerValidator(validatorID, RangeValidator.class);
    }

    public RangeValidator() {
        this.mbInverse = false;
    }

    public RangeValidator(boolean bl, Object object, Object object2) {
        this.mbInverse = bl;
        this.setMin(object);
        this.setMax(object2);
    }

    public RangeValidator(XmlAnyDefinition xmlAnyDefinition) {
        this.initUninitializedValidator();
        this.initValidatorProperties(xmlAnyDefinition);
    }

    private void initUninitializedValidator() {
        this.mbInverse = false;
    }

    public boolean validateValue(Object object) {
        if (object == null || object.toString().length() == 0) {
            return true;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("lowVal", this.m_min);
        hashMap.put("highVal", this.m_max);
        hashMap.put("val", object);
        Object object2 = null;
        try {
            AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
            adfELContext.setVariable(VALIDATION_PREFIX, hashMap, HashMap.class);
            object2 = this.getExpr().getValue((ELContext)adfELContext);
            return (Boolean)EmbeddedUtility.coerce(Boolean.class, object2);
        }
        catch (ELException eLException) {
            return false;
        }
    }

    public void setMin(Object object) {
        this.m_min = object;
    }

    public void setMax(Object object) {
        this.m_max = object;
    }

    public Object getMin() {
        return this.m_min;
    }

    public Object getMax() {
        return this.m_max;
    }

    public String toString() {
        return "Range(" + this.m_min.toString() + this.m_max.toString() + ")";
    }

    public void initValidatorProperties(XmlAnyDefinition xmlAnyDefinition) {
        super.initValidatorProperties(xmlAnyDefinition);
        Object object = xmlAnyDefinition.getAttributeValue(PNAME_MinValue);
        if (object != null) {
            this.setMin(object);
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_MaxValue)) != null) {
            this.setMax(object);
        }
    }

    private ValueExpression getExpr() {
        if (this.mExpr != null) {
            return this.mExpr;
        }
        this.mExpr = this.getValueExpression("#{(RangeValidator.val >= RangeValidator.lowVal) && (RangeValidator.val <= RangeValidator.highVal)}", Boolean.class);
        return this.mExpr;
    }
}

