/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.util.List;
import java.util.Vector;
import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.dc.rules.ValidatorFactory;
import oracle.adfmf.util.XmlAnyDefinition;

public class ListValidator
extends Validator {
    public static final Class CLASS_INSTANCE = ListValidator.class;
    protected static final String validatorID = "validation:ListValidationBean";
    Vector mList;

    public static final void registerValidator() {
        ValidatorFactory.registerValidator(validatorID, ListValidator.class);
    }

    public ListValidator() {
        this.initUninitializedValidator();
    }

    public ListValidator(boolean bl) {
        this.mbInverse = bl;
    }

    public ListValidator(boolean bl, Vector vector) {
        this.mbInverse = bl;
        this.setList(vector);
    }

    public ListValidator(XmlAnyDefinition xmlAnyDefinition) {
        this.initUninitializedValidator();
        this.initValidatorProperties(xmlAnyDefinition);
    }

    private void initUninitializedValidator() {
        this.mbInverse = false;
    }

    public boolean validateValue(Object object) {
        if (object == null || object.toString().length() == 0) {
            return true;
        }
        Vector vector = this.getList();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (e == null || e.toString().compareTo(object.toString().trim()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void setList(Vector vector) {
        this.mList = vector;
    }

    public Vector getList() {
        return this.mList;
    }

    public String toString() {
        String string = "List(";
        if (this.mList != null) {
            for (int i = 0; i < this.mList.size(); ++i) {
                string = string + this.mList.elementAt(i).toString();
                string = string + " ";
            }
        }
        string = string + ")";
        return string;
    }

    public static Vector convertToVector(String string) {
        Vector<String> vector = new Vector<String>(8);
        int n = string.indexOf(":");
        int n2 = 0;
        if (n == -1) {
            vector.addElement(string);
            return vector;
        }
        while (n != -1) {
            vector.addElement(string.substring(n2, n));
            n2 = n + 1;
            n = string.indexOf(":", n2);
        }
        return vector;
    }

    public void initValidatorProperties(XmlAnyDefinition xmlAnyDefinition) {
        super.initValidatorProperties(xmlAnyDefinition);
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("validation:AttrArray");
        List list = xmlAnyDefinition2.getChildDefinitions("validation:Item");
        Vector<Object> vector = new Vector<Object>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = ((XmlAnyDefinition)list.get(i)).getAttributeValue("value");
                vector.add(object);
            }
            this.setList(vector);
        }
    }
}

