/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.bindings.OperationDelegate;
import oracle.adfmf.dc.VirtualJavaBeanObject;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.performance.Monitor;
import oracle.adfmf.performance.MonitorFactory;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class JavaBeanOperation
implements OperationDelegate {
    protected GenericType input = null;
    protected GenericType output = null;
    protected String name = null;
    protected String namespace = null;
    protected String operation = null;
    protected String returnNodeName = null;
    protected String returnType = null;
    protected boolean returnPrimitive = false;
    protected Object result = null;
    protected HashMap parameters = new HashMap();

    public JavaBeanOperation(String string, String string2, String string3) {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, JavaBeanOperation.class, "JavaBeanOperation", "Creating {0} ({1}, {2}, {3})", new Object[]{this.getClass().getName(), string, string2, string3});
        }
        this.setOperation(string3);
        this.setNamespace(string);
        this.setName(string2);
        this.clearParameters();
    }

    public void addInputParameter(String string, String string2, Class clazz) {
        GenericType genericType;
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, JavaBeanOperation.class, "addInputParameter", "Adding an input parameter [{0} of type {1}]", new Object[]{string2, clazz});
        }
        if ((genericType = this.getInputObject()) instanceof VirtualJavaBeanObject) {
            ((VirtualJavaBeanObject)genericType).defineAttribute(string, string2, clazz, null);
        } else if (genericType instanceof GenericVirtualType) {
            ((GenericVirtualType)genericType).defineAttribute(string, string2, clazz);
        }
    }

    public GenericType getInputObject() {
        if (this.input == null) {
            this.input = new GenericVirtualType(this.getNamespace(), this.getOperation());
        }
        return this.input;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setInput(GenericType genericType) {
        this.input = genericType;
    }

    public GenericType getOutput() {
        return this.output;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object object, Map map) throws RuntimeException {
        String string = "operation:" + this.getNamespace() + "." + this.getName() + ":" + this.getOperation();
        MonitorFactory monitorFactory = MonitorFactory.getInstance();
        Monitor monitor = monitorFactory.getMonitor(string, "invoke " + string);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, JavaBeanOperation.class, "execute", "Operation={0}, params={1}", new Object[]{this.operation, map});
        }
        try {
            Object object2;
            try {
                monitor.start();
                object2 = this.invoke(this.operation, map);
                Object var8_9 = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new AdfException(exception);
            }
            monitor.addObservation();
            return object2;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.addObservation();
            throw throwable;
        }
    }

    public Object invoke(String string, Map map) throws Exception {
        return null;
    }

    protected void clearParameters() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            Trace.log(Utility.FrameworkLogger, Level.FINEST, JavaBeanOperation.class, "clearParameters", (Object)"Clearing all the previously defined input parameters");
        }
        this.parameters.clear();
    }

    protected HashMap getParameters() {
        return this.parameters;
    }

    protected Object getParameter(String string) {
        return this.parameters.get(string);
    }

    protected String getReturnType() {
        return this.returnType;
    }

    protected boolean isReturnPrmitive() {
        return this.returnPrimitive;
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setNamespace(String string) {
        this.namespace = string;
    }

    protected void setOperation(String string) {
        this.operation = string;
    }

    protected void setParameters(HashMap hashMap) {
        this.parameters = hashMap;
    }

    protected void setParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    protected void setReturnIsPrimitive(boolean bl) {
        this.returnPrimitive = bl;
    }

    protected void setReturnPropertyName(String string) {
        this.returnNodeName = string;
    }

    protected void setReturnType(String string) {
        this.returnType = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("Operation: ");
        stringBuffer.append(this.getNamespace() + "." + this.getName());
        stringBuffer.append("\n");
        stringBuffer.append("   service: ");
        stringBuffer.append("\n");
        stringBuffer.append("   input  : ");
        stringBuffer.append(this.input);
        stringBuffer.append("\n");
        stringBuffer.append("   output : ");
        stringBuffer.append(this.output);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

