/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.bindings.BindingContainer;
import oracle.adfmf.bindings.DataControl;
import oracle.adfmf.bindings.OperationBinding;
import oracle.adfmf.bindings.dbf.AmxExecutableBinding;
import oracle.adfmf.bindings.iterator.BasicIterator;
import oracle.adfmf.dc.DataProviderManager;
import oracle.adfmf.dc.JavaBeanObject;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObject;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.dcx.AdapterDataControlDefinition;
import oracle.adfmf.metadata.dcx.DataControlConfigsDefinition;
import oracle.adfmf.metadata.page.AccessorIteratorDefinition;
import oracle.adfmf.metadata.page.BeanBindingIteratorBaseDefinition;
import oracle.adfmf.metadata.page.MethodIteratorDefinition;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericTypeIteratorAdapter;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public abstract class GenericJavaBeanDataControlAdapter
implements DataControl {
    protected MetaDataFrameworkManager mdfm = MetaDataFrameworkManager.getInstance();
    protected String name = null;
    protected JavaBeanObject provider = null;
    protected XmlAnyDefinition metadataDef = null;
    protected DataProviderManager providerMgr = new DataProviderManager();
    protected Map methodResults = new HashMap();

    protected abstract void loadDataControlDefinition(AdapterDataControlDefinition var1);

    protected abstract boolean isSupported(AdapterDataControlDefinition var1);

    public GenericJavaBeanDataControlAdapter() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "GenericJavaBeanDataControlAdapter", "Creating the base abstract GenericJavaBeanDataControlAdapter");
        }
    }

    public XmlAnyDefinition getMetadataDefinition() {
        return this.metadataDef;
    }

    public void setMetadataDefinition(XmlAnyDefinition xmlAnyDefinition) {
        this.metadataDef = xmlAnyDefinition;
    }

    public static BeanBindingIteratorBaseDefinition testIncomingIteratorMetadataDef(XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition instanceof BeanBindingIteratorBaseDefinition) {
            return (BeanBindingIteratorBaseDefinition)xmlAnyDefinition;
        }
        if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
            Trace.log(Utility.FrameworkLogger, Level.SEVERE, GenericJavaBeanDataControlAdapter.class, "testIncomingIteratorMetadataDef", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11075", new Object[]{xmlAnyDefinition != null ? xmlAnyDefinition.getElementName() : "null"});
        }
        return null;
    }

    protected GenericTypeIteratorAdapter createAdapter(BindingContainer bindingContainer, BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition, GenericType genericType) {
        return new GenericTypeIteratorAdapter(this, beanBindingIteratorBaseDefinition, bindingContainer, genericType);
    }

    public BasicIterator getIteratorBinding(Object object, XmlAnyDefinition xmlAnyDefinition, BindingContainer bindingContainer) {
        String string = object != null ? object.getClass().getName() : "null";
        BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition = GenericJavaBeanDataControlAdapter.testIncomingIteratorMetadataDef(xmlAnyDefinition);
        if (beanBindingIteratorBaseDefinition == null) {
            return null;
        }
        String string2 = beanBindingIteratorBaseDefinition.getId();
        String string3 = beanBindingIteratorBaseDefinition.getMasterBinding();
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "getIteratorBinding", "getIteratorBinding({0}, {1}, {2}, {3})", new Object[]{string, string2, string3, bindingContainer});
        }
        try {
            Object object2;
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "getIteratorBinding", "Looking to see if this is a control binding.");
            }
            if (bindingContainer.get(string2) instanceof AmxExecutableBinding) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, "getIteratorBinding", "It is.");
                }
                object2 = ((AmxExecutableBinding)bindingContainer.get(string2)).getIterator();
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    this.log(Level.FINEST, "getIteratorBinding", "Iterator Binding found in the BC: " + object2);
                }
                if (object2 != null) {
                    return object2;
                }
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "getIteratorBinding", "Looking to see if it is a generic type.");
            }
            if (object instanceof GenericType) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, "getIteratorBinding", "It is.");
                }
                object2 = (GenericType)object;
                GenericTypeIteratorAdapter genericTypeIteratorAdapter = null;
                genericTypeIteratorAdapter = this.createAdapter(bindingContainer, beanBindingIteratorBaseDefinition, (GenericType)object2);
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, "getIteratorBinding", "GTI is: {0}", new Object[]{genericTypeIteratorAdapter});
                }
                return genericTypeIteratorAdapter;
            }
            if (object == null) {
                return this.createAdapter(bindingContainer, beanBindingIteratorBaseDefinition, new GenericVirtualType());
            }
            return null;
        }
        catch (AdfException adfException) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "getIteratorBinding", "Could not find an iterator for this provider.");
            }
            throw adfException;
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "getIteratorBinding", "Could not find an iterator for this provider.");
            }
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                this.log(Level.SEVERE, "getIteratorBinding", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11009", new Object[]{string2, string3, exception});
            }
            throw new AdfException(exception, "ERROR");
        }
    }

    public String getName() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getName", this.getClass().getName() + " named: " + this.name);
        }
        return this.name;
    }

    public void release() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "release", "Releasing the data control named {0}", new Object[]{this.name});
        }
    }

    public Object getDataProvider() {
        Object object = this.getWrappedDataProvider();
        if (object instanceof ConcreteJavaBeanObject) {
            ConcreteJavaBeanObject concreteJavaBeanObject = (ConcreteJavaBeanObject)object;
            object = concreteJavaBeanObject.getInstance();
        }
        return object;
    }

    public Object getWrappedDataProvider() {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getDataProvider", "Getting the default data provider.");
        }
        return this.provider;
    }

    public Map getMethodResults() {
        return this.methodResults;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFQProviderName(PageDefDefinition pageDefDefinition, BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition) {
        void var5_10;
        XmlAnyDefinition xmlAnyDefinition;
        void var5_7;
        String string = null;
        String string2 = beanBindingIteratorBaseDefinition.getMasterBinding();
        if (string2 == null) return beanBindingIteratorBaseDefinition.getDataControl() + "." + beanBindingIteratorBaseDefinition.getBinds();
        AccessorIteratorDefinition accessorIteratorDefinition = pageDefDefinition.getExecutablesDefinition().getAccessorIteratorDefinition(string2);
        if (accessorIteratorDefinition == null) {
            MethodIteratorDefinition methodIteratorDefinition = pageDefDefinition.getExecutablesDefinition().getMethodIteratorDefinition(string2);
        }
        if (var5_7 == null && (xmlAnyDefinition = pageDefDefinition.getExecutablesDefinition().getIteratorById(string2)) != null) {
            BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition2 = new BeanBindingIteratorBaseDefinition(xmlAnyDefinition);
        }
        if (var5_10 == null) return "";
        return this.getFQProviderName(pageDefDefinition, (BeanBindingIteratorBaseDefinition)var5_10) + "." + beanBindingIteratorBaseDefinition.getBinds();
    }

    private Object getAccessorDataProvider(AccessorIteratorDefinition accessorIteratorDefinition, BindingContainer bindingContainer) {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getAccessorDataProvider", "Getting the base data provider for {0} / {1}", new Object[]{accessorIteratorDefinition.getMasterBinding(), accessorIteratorDefinition.getBinds()});
        }
        Object object = null;
        Object v = bindingContainer.get(accessorIteratorDefinition.getMasterBinding());
        if (v instanceof AmxExecutableBinding) {
            BasicIterator basicIterator = ((AmxExecutableBinding)v).getIterator();
            if (basicIterator == null) {
                if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    this.log(Level.SEVERE, "getAccessorDataProvider", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11006", null);
                }
                return null;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "getAccessorDataProvider", "master iterator is a control binding {0}", new Object[]{basicIterator});
            }
            if ((object = basicIterator.getDataProvider(accessorIteratorDefinition)) == null) {
                object = GenericVirtualType.PLACEHOLDER_INSTANCE;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "getAccessorDataProvider", "used the master's (control binding) to obtain a {0} type provider", new Object[]{object == null ? "NULL" : object.getClass().getName()});
            }
            String string = this.getFQProviderName(this.mdfm.getPageDefDefinitionById(bindingContainer.getName()), accessorIteratorDefinition);
            this.providerMgr.setDataProviderInstance(string, object);
            this.providerMgr.addIteratorKey(bindingContainer.getName(), accessorIteratorDefinition.getId(), string);
        } else if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, "getAccessorDataProvider", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11006", null);
        }
        return object;
    }

    private Object getMethodReturnDataProvider(MethodIteratorDefinition methodIteratorDefinition, BindingContainer bindingContainer) {
        GenericVirtualType genericVirtualType = GenericVirtualType.PLACEHOLDER_INSTANCE;
        String string = this.getFQProviderName(this.mdfm.getPageDefDefinitionById(bindingContainer.getName()), methodIteratorDefinition);
        this.providerMgr.setDataProviderInstance(string, genericVirtualType);
        this.providerMgr.addIteratorKey(bindingContainer.getName(), methodIteratorDefinition.getId(), string);
        return genericVirtualType;
    }

    public Object getDataProvider(XmlAnyDefinition xmlAnyDefinition, BindingContainer bindingContainer) {
        Object object = null;
        BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition = GenericJavaBeanDataControlAdapter.testIncomingIteratorMetadataDef(xmlAnyDefinition);
        if (beanBindingIteratorBaseDefinition == null) {
            return null;
        }
        if (beanBindingIteratorBaseDefinition instanceof AccessorIteratorDefinition) {
            object = this.getAccessorDataProvider((AccessorIteratorDefinition)beanBindingIteratorBaseDefinition, bindingContainer);
        } else if (beanBindingIteratorBaseDefinition instanceof MethodIteratorDefinition) {
            object = this.getMethodReturnDataProvider((MethodIteratorDefinition)beanBindingIteratorBaseDefinition, bindingContainer);
        } else {
            String string;
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, "getDataProvider", "Returning the root provider for {0}", new Object[]{this.getClass().getName()});
            }
            if ((object = this.providerMgr.getDataProvider(bindingContainer.getName(), beanBindingIteratorBaseDefinition.getId())) != null) {
                return object;
            }
            String string2 = beanBindingIteratorBaseDefinition.getDataControl() + "." + beanBindingIteratorBaseDefinition.getBinds();
            object = this.providerMgr.getDataProvider(string2);
            if (object != null) {
                this.providerMgr.addIteratorKey(bindingContainer.getName(), beanBindingIteratorBaseDefinition.getId(), string2);
                return object;
            }
            object = this.getWrappedDataProvider();
            if (object instanceof GenericType && (string = (String)xmlAnyDefinition.getAttributeValue("Binds")) != null && !string.equalsIgnoreCase("root")) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    this.log(Level.FINEST, "getDataProvider", "Moving to a non-root Binds: {0}", new Object[]{string});
                }
                object = ((GenericType)object).getAttribute(string);
            }
            this.providerMgr.setDataProviderInstance(string2, object);
            this.providerMgr.addIteratorKey(bindingContainer.getName(), beanBindingIteratorBaseDefinition.getId(), string2);
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "getDataProvider", "{0} is returning provider {1}", new Object[]{this.getClass().getName(), object != null ? object.getClass().getName() : "NULL"});
        }
        return object;
    }

    public Object createDataProvider(XmlAnyDefinition xmlAnyDefinition) {
        return null;
    }

    public DataProviderManager getDataProviderManager() {
        return this.providerMgr;
    }

    public boolean invokeOperation(Map map, OperationBinding operationBinding) {
        if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "invokeOperation", "invoke operations");
        }
        return false;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void loadDataControl(String string) {
        DataControlConfigsDefinition dataControlConfigsDefinition;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "loadDataControl", "Looking for {0}", new Object[]{string});
        }
        if (null == (dataControlConfigsDefinition = this.mdfm.getDataControlConfig())) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11105", new Object[]{string});
        }
        AdapterDataControlDefinition adapterDataControlDefinition = dataControlConfigsDefinition.getAdapterDataControlByBeanClass(string);
        if (null != adapterDataControlDefinition) {
            if (this.isSupported(adapterDataControlDefinition)) {
                if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, "loadDataControl", "{0} is a supported data control definition.", new Object[]{string});
                }
                this.loadDataControlDefinition(adapterDataControlDefinition);
            } else if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                this.log(Level.SEVERE, "loadDataControl", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11011", new Object[]{string});
            }
        } else if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, "loadDataControl", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11010", new Object[]{string});
        }
    }

    protected void log(Level level, String string, String string2) {
        this.log(level, string, string2, null);
    }

    protected void log(Level level, String string, String string2, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, objectArray);
    }

    protected void log(Level level, String string, String string2, String string3, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, string3, objectArray);
    }
}

