/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.ELContext;
import javax.el.ValueExpression;
import oracle.adfmf.bindings.Hints;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.AmxControlBinding;
import oracle.adfmf.bindings.dbf.AmxExecutableBinding;
import oracle.adfmf.bindings.dbf.AmxIteratorBinding;
import oracle.adfmf.bindings.iterator.BasicIterator;
import oracle.adfmf.dc.GenericJavaBeanDataControlAdapter;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.event.DataChangeFilter;
import oracle.adfmf.framework.event.DataChangeFilterable;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.ProviderChangeEvent;
import oracle.adfmf.javax.faces.model.SelectItem;
import oracle.adfmf.metadata.PersdefDefinition;
import oracle.adfmf.metadata.SchemaBasedPropertiesUtils;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.page.AccessorIteratorDefinition;
import oracle.adfmf.metadata.page.AttributeValuesDefinition;
import oracle.adfmf.metadata.page.BeanBindingIteratorBaseDefinition;
import oracle.adfmf.metadata.page.HintsProvider;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.metadata.page.PageDefResourceBundleDefinition;
import oracle.adfmf.util.EmbeddedUtility;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class AmxAttributeBinding
extends AmxControlBinding
implements HintsProvider {
    private final AttributeValuesDefinition metadata;
    private String attrName = null;
    private String label = "DEFAULT_LABEL";
    private String format = "DEFAULT_FORMAT";
    protected Hints m_hints;
    protected Map hintsMap;
    private AttrBindingBehavior attrBehavior = null;
    static /* synthetic */ Class class$oracle$adfmf$bindings$dbf$AmxAttributeBinding;

    public AmxAttributeBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
        super(amxBindingContainer);
        this.metadata = new AttributeValuesDefinition(xmlAnyDefinition);
        this.attrBehavior = this.getBehavior();
    }

    private AttrBindingBehavior getBehavior() {
        if (this.metadata.getAttributeBooleanValue("StaticList")) {
            return new StaticListBehavior();
        }
        if (this.metadata.getAttributeValue("ListIter") != null) {
            String string = (String)this.metadata.getAttributeValue("ListOperMode");
            if ("navigation".equals(string)) {
                return new NavigationListBehavior();
            }
            if ("multiSelect".equals(string)) {
                return new MultiSelectListBehavior();
            }
            return new DynamicListBehavior();
        }
        if (this.metadata.getAttributeValue("Uses") != null) {
            return new ModelListBehavior();
        }
        return new BasicBehavior();
    }

    private String getAttrName() {
        return this.attrBehavior.getAttrName();
    }

    public Object getHints() {
        if (this.m_hints == null) {
            this.m_hints = new Hints(this);
        }
        return this.m_hints;
    }

    protected String getSingleNameValue(XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return null;
        }
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("Item");
        if (xmlAnyDefinition2 == null) {
            return null;
        }
        Object object = xmlAnyDefinition2.getAttributeValue("Value");
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    protected List getAllNameValues(XmlAnyDefinition xmlAnyDefinition) {
        List list;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null != xmlAnyDefinition && null != (list = xmlAnyDefinition.getChildDefinitions("Item"))) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
                if (null == xmlAnyDefinition2 || null == (object = xmlAnyDefinition2.getAttributeValue("Value"))) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public String getName() {
        return this.metadata.getId();
    }

    public AmxExecutableBinding getExecutable() {
        return this.getExecutable(this.metadata.getIterBinding());
    }

    public Object getInputValue() {
        return this.attrBehavior.getInputValue();
    }

    public void setInputValue(Object object) {
        this.attrBehavior.setInputValue(object);
    }

    public List getItems() {
        return this.attrBehavior.getItems();
    }

    public AmxIteratorBinding getIteratorBinding() {
        return (AmxIteratorBinding)this.getExecutable();
    }

    public boolean isUpdateable() {
        BasicIterator basicIterator = this.getIterator();
        return basicIterator.isUpdateable(this.getAttrName());
    }

    public String getLabel() {
        return (String)this.getHintValue("label");
    }

    public String getFormat() {
        return (String)this.getHintValue("format");
    }

    public void setLabel(String string) {
        Map map = this.getHintsMap();
        map.put("label", string);
    }

    public void setFormat(String string) {
        Map map = this.getHintsMap();
        map.put("format", string);
    }

    private Object getHintValue(Object object) {
        Map map = this.getHintsMap();
        Object object2 = map.get(object);
        if (object2 instanceof SchemaBasedPropertiesUtils.ResIdProperty) {
            object2 = ((SchemaBasedPropertiesUtils.ResIdProperty)object2).value;
            if (object2 != null) {
                String string = this.getStringFromResourceBundle(object2.toString());
                return string == null ? object2.toString() : string;
            }
            return "";
        }
        if (object2 != null) {
            return object2;
        }
        String string = (String)Hints.getDefaultsMap().get(object);
        return string == null ? "" : string;
    }

    private String getStringFromResourceBundle(String string) {
        if (string != null) {
            ResourceBundle resourceBundle = null;
            if (string.startsWith("${adfBundle")) {
                AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
                ValueExpression valueExpression = adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, String.class);
                return (String)valueExpression.getValue((ELContext)adfELContext);
            }
            resourceBundle = this.getResourceBundle();
            if (resourceBundle != null) {
                return resourceBundle.getString(string);
            }
        }
        return null;
    }

    private BasicIterator getIterator() {
        DataChangeFilterable dataChangeFilterable;
        AmxIteratorBinding amxIteratorBinding = (AmxIteratorBinding)this.getExecutable(this.metadata.getIterBinding());
        BasicIterator basicIterator = amxIteratorBinding.getIterator(true);
        if (basicIterator instanceof DataChangeFilterable && !(dataChangeFilterable = (DataChangeFilterable)((Object)basicIterator)).hasDataChangeEventFilter(this.getName())) {
            BasicIterator basicIterator2;
            AccessorIteratorDefinition accessorIteratorDefinition;
            AmxExecutableBinding amxExecutableBinding;
            EventFilter eventFilter = new ProviderEventFilter(this.getName(), amxIteratorBinding.getBinds(), this.getAttrName(), basicIterator);
            dataChangeFilterable.addDataChangeEventFilter(this.getName(), eventFilter);
            if (amxIteratorBinding.getMetadataDefinition() instanceof AccessorIteratorDefinition && (amxExecutableBinding = this.getExecutable((accessorIteratorDefinition = (AccessorIteratorDefinition)amxIteratorBinding.getMetadataDefinition()).getMasterBinding())) instanceof AmxExecutableBinding && (basicIterator2 = amxExecutableBinding.getIterator()) instanceof DataChangeFilterable && !(dataChangeFilterable = (DataChangeFilterable)((Object)basicIterator2)).hasDataChangeEventFilter(this.getName())) {
                eventFilter = new ParentEventFilter(this.getName(), amxIteratorBinding.getBinds(), this.getAttrName(), basicIterator);
                dataChangeFilterable.addDataChangeEventFilter(this.getName(), eventFilter);
            }
        }
        return basicIterator;
    }

    public Map getHintsMap() {
        if (this.hintsMap == null) {
            this.populateHintsMap();
        }
        return this.hintsMap;
    }

    public ResourceBundle getResourceBundle() {
        PageDefDefinition pageDefDefinition = this.parentContainer.metaData;
        PageDefResourceBundleDefinition pageDefResourceBundleDefinition = pageDefDefinition.getResourceBundle();
        if (pageDefResourceBundleDefinition != null) {
            return pageDefResourceBundleDefinition.getResourceBundle();
        }
        return null;
    }

    private void populateHintsMap() {
        XmlAnyDefinition xmlAnyDefinition;
        this.hintsMap = new HashMap();
        PageDefDefinition pageDefDefinition = this.parentContainer.metaData;
        List list = this.metadata.getAttrNamesDefinitions();
        if (list != null && list.size() > 0 && (xmlAnyDefinition = ((XmlAnyDefinition)list.get(0)).getChildDefinition("Item")) != null) {
            String string;
            String string2 = (String)xmlAnyDefinition.getAttributeValue("Value");
            String string3 = (String)this.metadata.getAttributeValue("IterBinding");
            XmlAnyDefinition xmlAnyDefinition2 = pageDefDefinition.getExecutablesDefinition().getIteratorById(string3);
            if (null != xmlAnyDefinition2 && null != (string = xmlAnyDefinition2.getElementName())) {
                XmlAnyDefinition xmlAnyDefinition3;
                PersdefDefinition persdefDefinition;
                String string4;
                if (string.equals("variableIterator")) {
                    XmlAnyDefinition xmlAnyDefinition4 = xmlAnyDefinition2.getChildDefinition("variable", "Name", string2);
                    if (xmlAnyDefinition4 != null) {
                        Object object;
                        XmlAnyDefinition xmlAnyDefinition5 = xmlAnyDefinition4.getChildDefinition("Properties");
                        if (xmlAnyDefinition5 != null) {
                            object = xmlAnyDefinition5.getChildDefinition("SchemaBasedProperties");
                            SchemaBasedPropertiesUtils.extractSchemaBasedProperties((XmlAnyDefinition)object, this.hintsMap);
                        }
                        if ((object = xmlAnyDefinition4.getAttributeValue("IsNotNull")) != null) {
                            this.hintsMap.put("mandatory", object);
                        }
                        if ((object = xmlAnyDefinition4.getAttributeValue("Precision")) != null) {
                            this.hintsMap.put("precision", object);
                        }
                        if ((object = xmlAnyDefinition4.getAttributeValue("IsUpdateable")) != null) {
                            this.hintsMap.put("updateable", object);
                        }
                    }
                } else if ((string.equals("accessorIterator") || string.equals("methodIterator")) && (string4 = (String)xmlAnyDefinition2.getAttributeValue("BeanClass")) != null && (persdefDefinition = PersdefDefinition.loadPersdefFromClassname(string4)) != null && (xmlAnyDefinition3 = persdefDefinition.getPDefAttributeByName(string2)) != null) {
                    Object object;
                    XmlAnyDefinition xmlAnyDefinition6 = xmlAnyDefinition3.getChildDefinition("Properties");
                    if (xmlAnyDefinition6 != null) {
                        object = xmlAnyDefinition6.getChildDefinition("SchemaBasedProperties");
                        SchemaBasedPropertiesUtils.extractSchemaBasedProperties((XmlAnyDefinition)object, this.hintsMap);
                    }
                    if ((object = xmlAnyDefinition3.getAttributeValue("IsUpdateable")) != null) {
                        this.hintsMap.put("updateable", object);
                    }
                }
            }
        }
        if (!this.hintsMap.containsKey("label")) {
            this.hintsMap.put("label", this.getName());
        }
    }

    private static final class ListEventFilter
    implements DataChangeFilter {
        static final String ITEMS = ".items";
        protected String bindingsId;
        protected final String providerName;
        protected final AmxAttributeBinding parent;

        ListEventFilter(String string, String string2, AmxAttributeBinding amxAttributeBinding) {
            this.bindingsId = "bindings." + string;
            this.providerName = string2;
            this.parent = amxAttributeBinding;
        }

        public Object filterEvent(ProviderChangeEvent providerChangeEvent) {
            List list = null;
            if (this.providerName.equals(providerChangeEvent.getProviderKey())) {
                list = this.parent.getItems();
            }
            PropertyChangeEvent propertyChangeEvent = null;
            if (list != null) {
                propertyChangeEvent = new PropertyChangeEvent(this.parent, this.bindingsId + ITEMS, null, list, providerChangeEvent.getTimestamp());
            }
            return propertyChangeEvent;
        }

        public Object filterEvent(PropertyChangeEvent propertyChangeEvent) {
            return null;
        }
    }

    private static final class ParentEventFilter
    extends EventFilter {
        ParentEventFilter(String string, String string2, String string3, BasicIterator basicIterator) {
            super(string, string2, string3, basicIterator);
        }

        protected Object processOtherProviderNames(ProviderChangeEvent providerChangeEvent) {
            return null;
        }
    }

    private static final class ProviderEventFilter
    extends EventFilter {
        ProviderEventFilter(String string, String string2, String string3, BasicIterator basicIterator) {
            super(string, string2, string3, basicIterator);
        }

        protected Object processOtherProviderNames(ProviderChangeEvent providerChangeEvent) {
            if (this.attrName.equals(providerChangeEvent.getProviderKey())) {
                this.bindingsId = this.bindingsId + ".inputValue";
                return providerChangeEvent.getNewValue();
            }
            return null;
        }
    }

    private static abstract class EventFilter
    implements DataChangeFilter {
        static final String INPUTVALUE = ".inputValue";
        protected String bindingsId;
        protected final String providerName;
        protected final String attrName;
        protected final BasicIterator iterator;

        EventFilter(String string, String string2, String string3, BasicIterator basicIterator) {
            this.bindingsId = "bindings." + string;
            this.providerName = string2;
            this.attrName = string3;
            this.iterator = basicIterator;
        }

        protected abstract Object processOtherProviderNames(ProviderChangeEvent var1);

        private Object getAttrNewValue(ProviderChangeEvent providerChangeEvent) {
            if (providerChangeEvent.getNewValue() instanceof GenericType) {
                return ((GenericType)providerChangeEvent.getNewValue()).getAttribute(this.attrName);
            }
            return this.iterator.getAttributeValue(this.attrName);
        }

        public Object filterEvent(ProviderChangeEvent providerChangeEvent) {
            Object object;
            String string = this.bindingsId;
            Object object2 = null;
            if (this.providerName.equals(providerChangeEvent.getProviderKey())) {
                object = providerChangeEvent.getCurrentRowKey();
                if (object == null) {
                    int n;
                    String string2 = providerChangeEvent.getColumnAttribute();
                    if (string2 != null && this.attrName.equals(string2.substring(0, n = string2.lastIndexOf(46)))) {
                        object2 = providerChangeEvent.getNewValue();
                        String string3 = string2.substring(n);
                        this.bindingsId = this.bindingsId + string3;
                    }
                } else if (object.equals(this.iterator.getCurrentRowKey())) {
                    object2 = this.getAttrNewValue(providerChangeEvent);
                    this.bindingsId = this.bindingsId + INPUTVALUE;
                }
            } else {
                object2 = this.processOtherProviderNames(providerChangeEvent);
            }
            object = null;
            if (object2 != null) {
                object = new PropertyChangeEvent(this.iterator.getDataProvider(), this.bindingsId, null, object2, providerChangeEvent.getTimestamp());
            }
            this.bindingsId = string;
            return object;
        }

        public Object filterEvent(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            if (this.attrName.equals(propertyChangeEvent.getPropertyName())) {
                return new PropertyChangeEvent(this.iterator.getDataProvider(), this.bindingsId + INPUTVALUE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getTimestamp());
            }
            XmlAnyDefinition xmlAnyDefinition = this.iterator.getMetadataDefinition();
            Object object2 = object = xmlAnyDefinition != null ? xmlAnyDefinition.getAttributeValue("Binds") : null;
            if (object != null && object.equals(propertyChangeEvent.getPropertyName())) {
                Object object3 = propertyChangeEvent.getNewValue();
                if (object3 instanceof GenericType) {
                    GenericType genericType = (GenericType)object3;
                    if (genericType != null && genericType.getAttributeType(this.attrName) != null) {
                        Object object4 = genericType.getAttribute(this.attrName);
                        return new PropertyChangeEvent(this.iterator.getDataProvider(), this.bindingsId + INPUTVALUE, null, object4, propertyChangeEvent.getTimestamp());
                    }
                } else if (Utility.getReadAccessorFromPropertyName(object3, this.attrName) != null) {
                    Object object5 = Utility.attemptToGetPropertyValue(object3, this.attrName);
                    return new PropertyChangeEvent(object3, this.bindingsId + INPUTVALUE, null, object5, propertyChangeEvent.getTimestamp());
                }
            }
            return null;
        }
    }

    private class MultiSelectListBehavior
    extends CollectionBasedListBehavior {
        private MultiSelectListBehavior() {
        }

        void setInputValue(Object object) {
        }

        Object getInputValue() {
            return null;
        }
    }

    private class NavigationListBehavior
    extends CollectionBasedListBehavior {
        private NavigationListBehavior() {
        }

        void setInputValue(Object object) {
            BasicIterator basicIterator = this.getListIterator();
            if (null != basicIterator) {
                basicIterator.setCurrentRowWithKeyValue(object.toString());
            }
        }

        Object getInputValue() {
            Object object = null;
            BasicIterator basicIterator = this.getListIterator();
            if (null != basicIterator) {
                object = basicIterator.getAttributeValue(this.getAttrName());
            }
            return object;
        }
    }

    private class CollectionBasedListBehavior
    extends ListBehavior {
        public CollectionBasedListBehavior() {
            this.registerListIteratorListeners();
        }

        List getItems() {
            AttributeValuesDefinition attributeValuesDefinition;
            List list;
            BasicIterator basicIterator = this.getListIterator();
            if (null != basicIterator && null != (list = AmxAttributeBinding.this.getAllNameValues((attributeValuesDefinition = AmxAttributeBinding.this.metadata).getChildDefinition("AttrNames")))) {
                Object[] objectArray = basicIterator.getKeys();
                ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>();
                for (int i = 0; i < basicIterator.getTotalRowCount(); ++i) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < list.size(); ++j) {
                        Object object = basicIterator.getAttributeValueAtIndex(i, (String)list.get(j));
                        String string = object != null ? object.toString() : "";
                        stringBuffer.append(string);
                        stringBuffer.append(Utility.isEmpty(string) ? "" : " ");
                    }
                    arrayList.add(new SelectItem(objectArray[i], stringBuffer.toString().trim()));
                }
                return arrayList;
            }
            return null;
        }
    }

    private class ModelListBehavior
    extends ListBehavior {
        private XmlAnyDefinition lovDef;
        private XmlAnyDefinition viewAccessorDef;

        private ModelListBehavior() {
            this.lovDef = null;
            this.viewAccessorDef = null;
        }

        private XmlAnyDefinition getPersDef() {
            String string = (String)AmxAttributeBinding.this.getIteratorBinding().getMetadataDefinition().getAttributeValue("BeanClass");
            String string2 = MetaDataFrameworkManager.getInstance().getLocationFromFullyQualifiedName("persdef." + string, ".xml");
            XmlAnyDefinition xmlAnyDefinition = MetaDataFrameworkManager.getInstance().getPersdefDefinitionByLocation(string2);
            return xmlAnyDefinition;
        }

        private XmlAnyDefinition getLOVDef() {
            if (this.lovDef == null) {
                this.lovDef = this.getPersDef().getChildDefinition("ListBinding", "Name", (String)AmxAttributeBinding.this.metadata.getAttributeValue("Uses"));
            }
            return this.lovDef;
        }

        private XmlAnyDefinition getViewAccessorDef() {
            if (this.viewAccessorDef == null) {
                this.viewAccessorDef = this.getPersDef().getChildDefinition("ViewAccessor", "Name", (String)this.getLOVDef().getAttributeValue("ListVOName"));
            }
            return this.viewAccessorDef;
        }

        private void throwMetadataError() {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11120", new Object[]{(String)AmxAttributeBinding.this.metadata.getAttributeValue("Uses")});
        }

        String getAttrName() {
            try {
                return AmxAttributeBinding.this.getSingleNameValue(this.getLOVDef().getChildDefinition("AttrArray", "Name", "AttrNames"));
            }
            catch (Exception exception) {
                this.throwMetadataError();
                return null;
            }
        }

        private GenericType getProviderFromViewAccessor(String[] stringArray) {
            String string = (String)AmxAttributeBinding.this.getIteratorBinding().getMetadataDefinition().getAttributeValue("DataControl");
            GenericJavaBeanDataControlAdapter genericJavaBeanDataControlAdapter = (GenericJavaBeanDataControlAdapter)AmxAttributeBinding.this.getDataControl(string);
            GenericType genericType = (GenericType)genericJavaBeanDataControlAdapter.getWrappedDataProvider();
            for (int i = 1; i < stringArray.length; ++i) {
                genericType = (GenericType)genericType.getAttribute(stringArray[i]);
            }
            return genericType;
        }

        List getItems() {
            ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>();
            String string = null;
            String string2 = null;
            String[] stringArray = null;
            try {
                String string3 = (String)this.getViewAccessorDef().getAttributeValue("ViewInstanceName");
                stringArray = Utility.tokenize(string3, ".");
                string = stringArray[stringArray.length - 1];
                string2 = AmxAttributeBinding.this.getSingleNameValue(this.getLOVDef().getChildDefinition("AttrArray", "Name", "ListAttrNames"));
                if (Utility.isNotEmpty(string2)) {
                    List list = AmxAttributeBinding.this.getAllNameValues(this.getLOVDef().getChildDefinition("AttrArray", "Name", "ListDisplayAttrNames"));
                    if (list.isEmpty()) {
                        list.add(string2);
                    }
                    GenericType genericType = this.getProviderFromViewAccessor(stringArray);
                    int n = genericType.getParent().getAttributeCount(string);
                    for (int i = 0; i < n; ++i) {
                        String string4 = "";
                        Object object = (genericType = (GenericType)genericType.getParent().getAttribute(string, i)).getAttribute(string2, i);
                        object = object != null ? object : "";
                        for (int j = 0; j < list.size(); ++j) {
                            Object object2 = genericType.getAttribute((String)list.get(j), i);
                            String string5 = object2 != null ? object2.toString() : "";
                            string4 = string4 + string5 + (Utility.isEmpty(string5) ? "" : " ");
                        }
                        arrayList.add(new SelectItem(object, string4.trim()));
                    }
                }
            }
            catch (Exception exception) {
                this.throwMetadataError();
            }
            return arrayList;
        }

        Object getInputValue() {
            return super.getInputValue();
        }

        void setInputValue(Object object) {
            super.setInputValue(object);
        }
    }

    private class DynamicListBehavior
    extends ListBehavior {
        public DynamicListBehavior() {
            this.registerListIteratorListeners();
        }

        List getItems() {
            AttributeValuesDefinition attributeValuesDefinition;
            String string;
            BasicIterator basicIterator = this.getListIterator();
            if (basicIterator != null && Utility.isNotEmpty(string = AmxAttributeBinding.this.getSingleNameValue((attributeValuesDefinition = AmxAttributeBinding.this.metadata).getChildDefinition("ListAttrNames")))) {
                List list = AmxAttributeBinding.this.getAllNameValues(attributeValuesDefinition.getChildDefinition("ListDisplayAttrNames"));
                if (list.isEmpty()) {
                    list.add(string);
                }
                ArrayList<SelectItem> arrayList = new ArrayList<SelectItem>();
                for (int i = 0; i < basicIterator.getTotalRowCount(); ++i) {
                    String string2 = "";
                    Object object = basicIterator.getAttributeValueAtIndex(i, string);
                    object = object != null ? object : "";
                    for (int j = 0; j < list.size(); ++j) {
                        Object object2 = basicIterator.getAttributeValueAtIndex(i, (String)list.get(j));
                        String string3 = object2 != null ? object2.toString() : "";
                        string2 = string2 + string3 + (Utility.isEmpty(string3) ? "" : " ");
                    }
                    arrayList.add(new SelectItem(object, string2.trim()));
                }
                return arrayList;
            }
            return null;
        }

        Object getInputValue() {
            return super.getInputValue();
        }

        void setInputValue(Object object) {
            super.setInputValue(object);
        }
    }

    private class StaticListBehavior
    extends ListBehavior {
        private List staticValueList;

        private StaticListBehavior() {
            this.staticValueList = null;
        }

        List getItems() {
            XmlAnyDefinition xmlAnyDefinition;
            if (this.staticValueList == null && (xmlAnyDefinition = AmxAttributeBinding.this.metadata.getChildDefinition("ValueList")) != null) {
                this.staticValueList = new ArrayList();
                List list = xmlAnyDefinition.getChildDefinitions("Item");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
                    String string = (String)xmlAnyDefinition2.getAttributeValue("Value");
                    this.staticValueList.add(new SelectItem(string, string));
                }
            }
            return this.staticValueList;
        }

        Object getInputValue() {
            return super.getInputValue();
        }

        void setInputValue(Object object) {
            super.setInputValue(object);
        }
    }

    private class ListBehavior
    extends BasicBehavior {
        private ListBehavior() {
        }

        protected AmxIteratorBinding getListIterBinding() {
            AttributeValuesDefinition attributeValuesDefinition = AmxAttributeBinding.this.metadata;
            String string = (String)attributeValuesDefinition.getAttributeValue("ListIter");
            return (AmxIteratorBinding)AmxAttributeBinding.this.getContainer().get(string);
        }

        protected BasicIterator getListIterator() {
            BasicIterator basicIterator = null;
            AmxIteratorBinding amxIteratorBinding = this.getListIterBinding();
            if (null != amxIteratorBinding) {
                basicIterator = amxIteratorBinding.getIterator();
            }
            return basicIterator;
        }

        protected void registerListIteratorListeners() {
            AmxIteratorBinding amxIteratorBinding = this.getListIterBinding();
            if (amxIteratorBinding != null) {
                DataChangeFilterable dataChangeFilterable;
                BasicIterator basicIterator;
                Object object;
                Object object2;
                BasicIterator basicIterator2 = amxIteratorBinding.getIterator();
                if (basicIterator2 instanceof DataChangeFilterable && !(object2 = (DataChangeFilterable)((Object)basicIterator2)).hasDataChangeEventFilter(AmxAttributeBinding.this.getName())) {
                    object = new ListEventFilter(AmxAttributeBinding.this.getName(), amxIteratorBinding.getBinds(), AmxAttributeBinding.this);
                    object2.addDataChangeEventFilter(AmxAttributeBinding.this.getName(), (DataChangeFilter)object);
                }
                if (amxIteratorBinding.getMetadataDefinition() instanceof AccessorIteratorDefinition && (object = AmxAttributeBinding.this.getExecutable(((BeanBindingIteratorBaseDefinition)(object2 = (AccessorIteratorDefinition)amxIteratorBinding.getMetadataDefinition())).getMasterBinding())) instanceof AmxExecutableBinding && (basicIterator = ((AmxExecutableBinding)object).getIterator()) instanceof DataChangeFilterable && !(dataChangeFilterable = (DataChangeFilterable)((Object)basicIterator)).hasDataChangeEventFilter(AmxAttributeBinding.this.getName())) {
                    ListEventFilter listEventFilter = new ListEventFilter(AmxAttributeBinding.this.getName(), amxIteratorBinding.getBinds(), AmxAttributeBinding.this);
                    dataChangeFilterable.addDataChangeEventFilter(AmxAttributeBinding.this.getName(), listEventFilter);
                }
            }
        }
    }

    private class BasicBehavior
    extends AttrBindingBehavior {
        private BasicBehavior() {
        }

        String getAttrName() {
            AmxAttributeBinding amxAttributeBinding = AmxAttributeBinding.this;
            if (amxAttributeBinding.attrName == null) {
                if (amxAttributeBinding.metadata.getAttrNamesDefinitions().size() > 1 && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    Trace.log(Utility.FrameworkLogger, Level.WARNING, class$oracle$adfmf$bindings$dbf$AmxAttributeBinding == null ? (class$oracle$adfmf$bindings$dbf$AmxAttributeBinding = AmxAttributeBinding.class$("oracle.adfmf.bindings.dbf.AmxAttributeBinding")) : class$oracle$adfmf$bindings$dbf$AmxAttributeBinding, "getAttrName", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40045", new Object[]{amxAttributeBinding.getName()});
                }
                amxAttributeBinding.attrName = amxAttributeBinding.getSingleNameValue(amxAttributeBinding.metadata.getChildDefinition("AttrNames"));
            }
            return amxAttributeBinding.attrName;
        }

        List getItems() {
            return null;
        }

        Object getInputValue() {
            BasicIterator basicIterator = AmxAttributeBinding.this.getIterator();
            if (null == basicIterator) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11145", null);
            }
            return basicIterator.getAttributeValue(this.getAttrName());
        }

        void setInputValue(Object object) {
            BasicIterator basicIterator = AmxAttributeBinding.this.getIterator();
            if (null == basicIterator) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11144", null);
            }
            Class clazz = basicIterator.getAttributeType(this.getAttrName());
            Object object2 = EmbeddedUtility.coerce(clazz, object);
            basicIterator.setAttributeValue(this.getAttrName(), object2);
        }
    }

    private abstract class AttrBindingBehavior {
        private AttrBindingBehavior() {
        }

        abstract String getAttrName();

        abstract List getItems();

        abstract Object getInputValue();

        abstract void setInputValue(Object var1);
    }
}

