/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.datacontrols.device;

import [Ljava.util.HashMap;;
import com.sun.util.logging.Level;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import oracle.adf.model.datacontrols.device.Preferences;
import oracle.adfmf.cache.TimeoutCache;
import oracle.adfmf.framework.EmbeddedFeatureContextManager;
import oracle.adfmf.framework.FeatureContextManagerFactory;
import oracle.adfmf.framework.Scope;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.contract.adf.NameValuePair;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class PreferenceScope
extends Scope {
    private static long SPECIFIED_MAX_AGE = 0L;
    private static long FOREVER = -1L;
    private static final String HANDLER_CLASS = "oracle.adf.model.datacontrols.device.PreferencesHandler";
    private static final String GET_PREFERENCES_METHOD = "getPreferences";
    private static final String SET_PREFERENCE_METHOD = "setPreference";
    private static final String PREFERENCE_KEY_KEY = "name";
    private static final String PREFERENCE_VALUE_KEY = "value";
    private Preferences preferencesMap = new Preferences();
    protected TimeoutCache timeoutCache = new TimeoutCache();
    private boolean populatingPreferencesMapFlag = false;
    private static final PreferenceScope sInstance = new PreferenceScope();

    public static final PreferenceScope getInstance() {
        return sInstance;
    }

    public PreferenceScope() {
        super("preferenceScope");
    }

    public PreferenceScope(String string) {
        super("preferenceScope");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPreferences() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            PreferenceScope.refreshPreferences("application");
            PreferenceScope.refreshPreferences("feature");
        }
    }

    private static void refreshPreferences(String string) {
        HashMap[] hashMapArray = null;
        try {
            hashMapArray = PreferenceScope.getInstance().getNativePreferences(string);
            if (hashMapArray != null) {
                for (int i = 0; i < hashMapArray.length; ++i) {
                    String string2 = (String)hashMapArray[i].get(PREFERENCE_KEY_KEY);
                    if (!PreferenceScope.getInstance().timeoutCache.containsKey(string2)) continue;
                    Object v = hashMapArray[i].get(PREFERENCE_VALUE_KEY);
                    Object object = PreferenceScope.getInstance().getCachedPreference(string2, true);
                    if (v == null || v == null && object == null) continue;
                    if (v == null) {
                        PreferenceScope.getInstance().setElPrefValue(string2, v);
                        continue;
                    }
                    if (v.equals(object)) continue;
                    PreferenceScope.getInstance().setElPrefValue(string2, v);
                }
            }
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11036", new Object[]{exception.getLocalizedMessage()});
        }
    }

    private void setElPrefValue(String string, Object object) {
        String string2 = "#{preferenceScope." + string + "}";
        ValueExpression valueExpression = AdfmfJavaUtilities.getValueExpression(string2, object.getClass());
        valueExpression.setValue((ELContext)AdfmfJavaUtilities.getAdfELContext(), object);
    }

    protected static void emitPropertyChange(String string, Object object, Object object2) {
        string = PreferenceScope.getInstance().scopeName + "." + string;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)PreferenceScope.getInstance(), string, object, object2);
        EmbeddedFeatureContextManager embeddedFeatureContextManager = (EmbeddedFeatureContextManager)FeatureContextManagerFactory.getInstance();
        embeddedFeatureContextManager.addApplicationPropertyChangeEvent(propertyChangeEvent);
    }

    protected void setPopulatingPreferencesMapFlag() {
        this.populatingPreferencesMapFlag = true;
    }

    protected void clearPopulatingPreferencesMapFlag() {
        this.populatingPreferencesMapFlag = false;
    }

    protected boolean isPopulatingPreferencesMap() {
        return this.populatingPreferencesMapFlag;
    }

    protected void populatePreferencesMap(String string) {
        HashMap[] hashMapArray = null;
        try {
            try {
                this.setPopulatingPreferencesMapFlag();
                hashMapArray = this.getNativePreferences(string);
                if (hashMapArray != null) {
                    for (int i = 0; i < hashMapArray.length; ++i) {
                        String string2 = (String)hashMapArray[i].get(PREFERENCE_KEY_KEY);
                        Object v = hashMapArray[i].get(PREFERENCE_VALUE_KEY);
                        if (v == null) continue;
                        PreferenceScope.getInstance().setElPrefValue(string2, v);
                    }
                }
                Object var7_7 = null;
                this.clearPopulatingPreferencesMapFlag();
            }
            catch (Exception exception) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11036", new Object[]{exception.getLocalizedMessage()});
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.clearPopulatingPreferencesMapFlag();
            throw throwable;
        }
    }

    protected Object getNativePreference(String string) {
        HashMap[] hashMapArray = this.getNativePreferences(string);
        for (int i = 0; i < hashMapArray.length; ++i) {
            String string2 = (String)hashMapArray[i].get(PREFERENCE_KEY_KEY);
            if (!string2.equals(string)) continue;
            return hashMapArray[i].get(PREFERENCE_VALUE_KEY);
        }
        return null;
    }

    protected HashMap[] getNativePreferences(String string) {
        try {
            Object object = AdfmfContainerUtilities.invokeContainerMethod(HANDLER_CLASS, GET_PREFERENCES_METHOD, new String[]{string});
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, PreferenceScope.class, "getNativePreferences", "InvokeContainerMethod done, result: {0}; result.getClass().getName(): {1}", new Object[]{object.toString(), object.getClass().getName()});
            }
            HashMap[] hashMapArray = (HashMap[])JSONBeanSerializationHelper.fromJSON(HashMap;.class, object);
            if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                Trace.log(Utility.FrameworkLogger, Level.FINE, PreferenceScope.class, "getNativePreferences", "Result converted to HashMap[], preferences = {0}", new Object[]{hashMapArray});
            }
            return hashMapArray;
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, PreferenceScope.class, "getNativePreferences", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11060", new Object[]{exception.toString()});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11037", new Object[]{exception.getLocalizedMessage()});
        }
    }

    protected Integer putNativePreference(String string, Object object) {
        Integer n = new Integer(1);
        NameValuePair nameValuePair = new NameValuePair();
        nameValuePair.setName(string);
        nameValuePair.setValue(object);
        Object[] objectArray = new Object[]{nameValuePair};
        Object object2 = AdfmfContainerUtilities.invokeContainerMethod(HANDLER_CLASS, SET_PREFERENCE_METHOD, objectArray);
        try {
            n = (Integer)JSONBeanSerializationHelper.fromJSON(Integer.class, object2);
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, PreferenceScope.class, "putNativePreference", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11060", new Object[]{exception.getMessage()});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11038", new Object[]{exception.getLocalizedMessage()});
        }
        return n;
    }

    private void putCachedPreference(String string, Object object, long l) {
        this.timeoutCache.put((Object)string, object, l);
    }

    protected void putCachedPreference(String string, Object object) {
        this.putCachedPreference(string, object, this.isKeyPersisted(string) ? SPECIFIED_MAX_AGE : FOREVER);
    }

    protected Object getCachedPreference(String string) {
        return this.getCachedPreference(string, false);
    }

    protected Object getCachedPreference(String string, boolean bl) {
        return this.timeoutCache.get((Object)string, bl);
    }

    private boolean isKeyPersisted(String string) {
        return string.startsWith("application.") || string.startsWith("feature.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.put(object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            this.preferencesMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.containsValue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            this.preferencesMap.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        PreferenceScope preferenceScope = PreferenceScope.getInstance();
        synchronized (preferenceScope) {
            return this.preferencesMap.values();
        }
    }

    protected void logDumpCache() {
        try {
            Set set = PreferenceScope.getInstance().timeoutCache.keySet();
            System.out.print("\n\n*** Dumping the PreferenceScope cache {\n");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = PreferenceScope.getInstance().timeoutCache.get((Object)string, true);
                System.out.print("\n==> " + string + " : " + PreferenceScope.getInstance().getDisplayValue(object));
            }
            System.out.println("\n}");
        }
        catch (Exception exception) {
            System.out.println("\nlogDumpCache exception: " + exception.getMessage());
        }
    }

    protected void logDumpNativePrefs(HashMap[] hashMapArray) {
        try {
            System.out.print("\n\n*** Dumping the retrieved native preferences {\n");
            if (hashMapArray != null) {
                for (int i = 0; i < hashMapArray.length; ++i) {
                    String string = (String)hashMapArray[i].get(PREFERENCE_KEY_KEY);
                    Object v = hashMapArray[i].get(PREFERENCE_VALUE_KEY);
                    Object object = PreferenceScope.getInstance().getCachedPreference(string, true);
                    System.out.print("\n==> " + string + " : ");
                    System.out.print(PreferenceScope.getInstance().getDisplayValue(v));
                    System.out.print(" (cache=" + PreferenceScope.getInstance().getDisplayValue(object) + ")");
                }
            }
            System.out.println("\n}");
        }
        catch (Exception exception) {
            System.out.println("\nlogDumpNativePrefs exception: " + exception.getMessage());
        }
    }

    protected String getDisplayValue(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "(null)";
    }
}

