/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.logging;

import com.sun.util.logging.Filter;
import com.sun.util.logging.Formatter;
import com.sun.util.logging.Level;
import com.sun.util.logging.LogManager;
import oracle.adfmf.util.Utility;

class LoggingUtility {
    LoggingUtility() {
    }

    static String getProperty(String string) {
        String string2 = LogManager.getLogManager().getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    static String getStringProperty(String string, String string2) {
        String string3 = LoggingUtility.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    static int getIntegerProperty(String string, int n) {
        String string2 = LoggingUtility.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = LoggingUtility.getProperty(string);
        if (string2 != null) {
            try {
                return string2.toLowerCase().equals("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    static Level getLevelProperty(String string, Level level) {
        String string2 = LoggingUtility.getProperty(string);
        if (string2 != null) {
            try {
                return Level.parse((String)string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return level;
    }

    static Filter getFilterProperty(String string, Filter filter) {
        String string2 = LoggingUtility.getProperty(string);
        if (string2 != null) {
            try {
                return (Filter)LoggingUtility.instantiate(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filter;
    }

    static Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = LoggingUtility.getProperty(string);
        if (string2 != null) {
            try {
                return (Formatter)LoggingUtility.instantiate(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return formatter;
    }

    private static Object instantiate(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        try {
            Class clazz = Utility.loadClass(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            return clazz.newInstance();
        }
    }
}

