/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util.async;

import com.sun.util.logging.Level;
import java.util.Vector;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.async.Backgroundable;
import oracle.adfmf.util.async.WorkItem;
import oracle.adfmf.util.logging.Trace;

public class BackgroundWorker
implements Runnable {
    public static final String BACKGROUND_INSTANCE_NAME = "Background";
    private Vector workQ = new Vector();
    private int workItemId;
    private Thread workerThread;
    private static BackgroundWorker backgroundInstance = new BackgroundWorker("Background");
    private static boolean s_isRunning = true;

    private BackgroundWorker(String string) {
        this.workerThread = new Thread((Runnable)this, string);
        this.workerThread.start();
    }

    private static final BackgroundWorker getBackgroundWorker() {
        return backgroundInstance;
    }

    private void doWork(WorkItem workItem) {
        if (workItem == null) {
            return;
        }
        this.doWork(workItem.getTask(), workItem.getParams());
    }

    private void doWork(Backgroundable backgroundable, Object[] objectArray) {
        block4: {
            try {
                backgroundable.run(objectArray);
            }
            catch (Exception exception) {
                if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                    Trace.log(Utility.FrameworkLogger, this.getClass(), "doWork", (Throwable)exception);
                }
            }
            catch (Error error) {
                if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) break block4;
                Trace.log(Utility.FrameworkLogger, this.getClass(), "doWork", (Throwable)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        WorkItem workItem = null;
        while (s_isRunning) {
            Vector vector = this.workQ;
            synchronized (vector) {
                if (this.workQ.size() > 0) {
                    workItem = (WorkItem)this.workQ.elementAt(0);
                    this.workQ.removeElementAt(0);
                }
            }
            this.doWork(workItem);
            vector = this.workQ;
            synchronized (vector) {
                if (this.workQ.size() < 1) {
                    try {
                        this.workQ.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int nQ(Backgroundable backgroundable, Object[] objectArray) {
        Vector vector = this.workQ;
        synchronized (vector) {
            WorkItem workItem = new WorkItem(backgroundable, this.workItemId++, objectArray);
            this.workQ.addElement(workItem);
            this.workQ.notifyAll();
            return workItem.getId();
        }
    }

    private final int nQOrRunDirectly(Backgroundable backgroundable, Object[] objectArray) {
        if (Thread.currentThread() == this.workerThread) {
            this.doWork(backgroundable, objectArray);
            return 0;
        }
        return this.nQ(backgroundable, objectArray);
    }

    public static final int nQOrRunDirectlyBackground(Backgroundable backgroundable, Object[] objectArray) {
        return BackgroundWorker.getBackgroundWorker().nQOrRunDirectly(backgroundable, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Vector vector = this.workQ;
        synchronized (vector) {
            this.workQ.notifyAll();
        }
    }

    public static final void shutdownAll() {
        s_isRunning = false;
        BackgroundWorker.getBackgroundWorker().shutdown();
    }

    public Thread getWorkerThread() {
        return this.workerThread;
    }

    public static class RunnableWithParams
    implements Runnable {
        private Object[] params;
        private Backgroundable work;

        public RunnableWithParams(Backgroundable backgroundable, Object[] objectArray) {
            this.work = backgroundable;
            this.params = objectArray;
        }

        public void run() {
            this.work.run(this.params);
        }
    }
}

