/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.util;

import java.util.Map;

public class CommandLine {
    public static final String ARG_TEST_MODE = "testMode";
    public static final String ARG_FEATURE = "feature";
    public static final String ARG_STARTUP_METHOD = "startupMethod";
    public static final String ARG_SHUTDOWN_METHOD = "shutdownMethod";
    public static final String ARG_JAVA_DEBUG_PORT = "cvm.properties.java.debug.port";
    private Map arguments;
    private static CommandLine instance = new CommandLine();

    public static CommandLine getInstance() {
        return instance;
    }

    private CommandLine() {
    }

    public static final void parseArgs(Map map) {
        if (CommandLine.getInstance().arguments == null) {
            CommandLine.getInstance().arguments = map;
        }
    }

    public static final boolean isTestMode() {
        return CommandLine.getPropertyAsBoolean(ARG_TEST_MODE, false);
    }

    public static final String getFeatureId() {
        return CommandLine.getProperty(ARG_FEATURE);
    }

    public static final String getStartupMethod() {
        return CommandLine.getProperty(ARG_STARTUP_METHOD);
    }

    public static final String getShutdownMethod() {
        return CommandLine.getProperty(ARG_SHUTDOWN_METHOD);
    }

    public static final String getProperty(String string) {
        return CommandLine.getProperty(string, null);
    }

    public static final String getProperty(String string, String string2) {
        if (string == null || CommandLine.getInstance().arguments == null) {
            return null;
        }
        String string3 = (String)CommandLine.getInstance().arguments.get(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static final boolean getPropertyAsBoolean(String string) {
        return CommandLine.getPropertyAsBoolean(string, false);
    }

    public static final boolean getPropertyAsBoolean(String string, boolean bl) {
        String string2 = CommandLine.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl;
    }
}

