/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.performance;

import com.sun.util.logging.Level;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.performance.StopWatch;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class Monitor
extends StopWatch
implements JSONSerializable {
    private String id;
    private String description;
    private long observations = 0L;
    private double sumTime = 0.0;
    private double sumTimeSquare = 0.0;

    public Monitor(String string, String string2) {
        this.id = string;
        this.description = string2;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void addObservation() {
        this.addObservation(this.stop());
    }

    public void addObservation(double d) {
        this.sumTime += d;
        this.sumTimeSquare += d * d;
        ++this.observations;
    }

    public long getObservations() {
        return this.observations;
    }

    public double getMean() {
        return this.sumTime / (double)this.observations;
    }

    protected double getStandardDeviation() {
        double d = this.getMean();
        double d2 = d * d;
        double d3 = (this.sumTimeSquare - (double)this.observations * d2) / (double)(this.observations - 1L);
        return Math.sqrt(d3);
    }

    public void start() {
        if (Utility.PerformanceLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.PerformanceLogger, Level.FINE, this.getClass(), "start", (Object)("PERFMON-JAVA START: " + this.id + " (" + this.description + ")"));
        }
        super.start();
    }

    public double stop() {
        double d = super.stop();
        if (Utility.PerformanceLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.PerformanceLogger, Level.FINE, this.getClass(), "stop", (Object)("PERFMON-JAVA STOP: " + this.id + " (" + this.description + ") took: " + d + "ms."));
        }
        return d;
    }

    public void dumpStatistics() {
        if (Utility.PerformanceLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.PerformanceLogger, Level.FINE, this.getClass(), "dumpStatistics", (Object)("PERFMON-JAVA STATS: " + this.toString()));
        }
    }

    public String toString() {
        return "Monitor '" + this.id + "'  description: '" + this.getDescription() + "'  observations: " + this.getObservations() + "  mean: " + this.getMean() + "  standard deviation: " + this.getStandardDeviation();
    }

    public Object toJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", this.id);
        jSONObject.put("description", this.description);
        jSONObject.put("observations", this.observations);
        jSONObject.put("mean", this.getMean());
        jSONObject.put("std", this.getStandardDeviation());
        return jSONObject;
    }
}

