/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.cache;

import com.sun.util.logging.Level;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.adfmf.cache.CacheProvider;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.transform.TransformCacheProvider;
import oracle.adfmf.metadata.cache.MetaDataCache;
import oracle.adfmf.metadata.cpx.ApplicationDefinition;
import oracle.adfmf.metadata.dcx.DataControlConfigsDefinition;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class MetaDataFrameworkManager
implements CacheProvider {
    private static final int TASK_FLOW_CACHE = 0;
    private static final int PAGE_DEF_CACHE = 1;
    private static final int DATA_BINDINGS_CACHE = 2;
    private static final int DATA_CONTROL_CACHE = 3;
    private static final int JAVA_BEAN_CACHE = 4;
    private static final int JAVA_BEAN_CACHE_OLD = 5;
    private static final int PERSDEF_CACHE = 6;
    private static final int CACHE_COUNT = 8;
    protected MetaDataCache[] cache = null;
    protected TransformCacheProvider m_javaBeanFetcher = new TransformCacheProvider();

    private MetaDataFrameworkManager() {
        this.cache = new MetaDataCache[8];
        this.cache[0] = null;
        this.cache[1] = new MetaDataCache(this, "id", "pageDefinition");
        this.cache[2] = new MetaDataCache(this, "id", "Application");
        this.cache[3] = new MetaDataCache(this, "id", "DataControlConfigs");
        this.cache[4] = new MetaDataCache(this, "BeanClass", "JavaBean");
        this.cache[5] = new MetaDataCache(this.m_javaBeanFetcher, "BeanClass", "JavaBean");
        this.cache[6] = new MetaDataCache(this, "Name", "PDefViewObject");
        this.m_javaBeanFetcher.setMetaDataCache(this.cache[5]);
    }

    public static MetaDataFrameworkManager getInstance() {
        MetaDataFrameworkManager metaDataFrameworkManager = EmbeddedFeatureContext.getInstance().getMetaDataFrameworkManager();
        if (metaDataFrameworkManager == null) {
            metaDataFrameworkManager = new MetaDataFrameworkManager();
            EmbeddedFeatureContext.getInstance().setMetaDataFrameworkManager(metaDataFrameworkManager);
        }
        return metaDataFrameworkManager;
    }

    public ApplicationDefinition getDataBindings() {
        return this.getDataBindings(EmbeddedFeatureContext.getInstance().getCpxPath());
    }

    public ApplicationDefinition getDataBindings(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.cache[2].getByLocation(string);
        return new ApplicationDefinition(xmlAnyDefinition);
    }

    public DataControlConfigsDefinition getDataControlConfig() {
        String string;
        DataControlConfigsDefinition dataControlConfigsDefinition = null;
        String string2 = EmbeddedFeatureContext.getInstance().getApplicationDcxPath();
        if (string2 != null) {
            try {
                dataControlConfigsDefinition = this.getDataControlConfigsDefinition(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = EmbeddedFeatureContext.getInstance().getFeatureDcxPath()) != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL[] uRLArray = EmbeddedFeatureContext.getInstance().getFeaturePathURLs();
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray, ClassLoader.getSystemClassLoader());
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            try {
                if (dataControlConfigsDefinition == null) {
                    dataControlConfigsDefinition = this.getDataControlConfigsDefinition(string);
                } else {
                    dataControlConfigsDefinition.mergeChildren(this.getDataControlConfigsDefinition(string));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return dataControlConfigsDefinition;
    }

    public DataControlConfigsDefinition getDataControlConfigById(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.cache[3].getById(string);
        return new DataControlConfigsDefinition(xmlAnyDefinition);
    }

    public DataControlConfigsDefinition getDataControlConfigsDefinition(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.cache[3].getByLocation(string);
        return new DataControlConfigsDefinition(xmlAnyDefinition);
    }

    public PageDefDefinition getPageDefDefinitionById(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.cache[1].getById(string);
        return new PageDefDefinition(xmlAnyDefinition);
    }

    public PageDefDefinition getPageDefDefinitionByLocation(String string) {
        XmlAnyDefinition xmlAnyDefinition = this.cache[1].getByLocation(string);
        if (xmlAnyDefinition == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11027", new Object[]{string});
        }
        PageDefDefinition pageDefDefinition = new PageDefDefinition(xmlAnyDefinition);
        this.cache[1].addCrossRef(pageDefDefinition.getId(), string);
        return pageDefDefinition;
    }

    public XmlAnyDefinition getPersdefDefinitionByLocation(String string) {
        return this.cache[6].getByLocation(string);
    }

    public JavaBeanDefinition getJavaBeanDefinitionByName(String string, String string2) {
        return this.getJavaBeanDefinitionByName(string + "." + string2);
    }

    public JavaBeanDefinition getJavaBeanDefinitionByName(String string) {
        String string2 = this.getLocationFromFullyQualifiedName(string, ".xml");
        InputStream inputStream = Utility.getResourceAsStream(string2);
        if (inputStream != null) {
            Utility.closeSilently(inputStream);
            XmlAnyDefinition xmlAnyDefinition = this.cache[4].getByLocation(string2);
            return new JavaBeanDefinition(xmlAnyDefinition);
        }
        return (JavaBeanDefinition)this.cache[5].getByLocation(string);
    }

    public Object fetch(Object object, Object object2) {
        XmlAnyDefinition xmlAnyDefinition = null;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, MetaDataFrameworkManager.class, "fetch", "Loading definition {0} with {1} from disk.", new Object[]{object, object2});
        }
        xmlAnyDefinition = XmlAnyDefinition.loadXmlFromLocation((String)object, (String)object2);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, MetaDataFrameworkManager.class, "fetch", "Fetching {0} {1}", new Object[]{object, xmlAnyDefinition == null ? " FAILED" : " was GOOD"});
        }
        return xmlAnyDefinition;
    }

    public String getLocationFromFullyQualifiedName(String string, String string2) {
        String string3 = string2 == null ? "" : string2;
        return string.replace('.', '/') + string3;
    }
}

