/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import com.sun.util.logging.Level;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.adfmf.cache.CacheProvider;
import oracle.adfmf.dc.DataControlUtil;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.transform.XmlAnyTransform;
import oracle.adfmf.metadata.bean.transform.XsdTransform;
import oracle.adfmf.metadata.cache.MetaDataCache;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.dcx.AdapterDataControlDefinition;
import oracle.adfmf.metadata.dcx.DataControlConfigsDefinition;
import oracle.adfmf.metadata.dcx.SourceDefinition;
import oracle.adfmf.metadata.dcx.soap.SoapDefinitionDefinition;
import oracle.adfmf.metadata.dcx.soap.SoapSourceDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class TransformCacheProvider
implements CacheProvider {
    private MetaDataCache m_cache;

    protected XmlAnyDefinition createAny(String string) {
        MetaDataFrameworkManager metaDataFrameworkManager = MetaDataFrameworkManager.getInstance();
        DataControlConfigsDefinition dataControlConfigsDefinition = null;
        try {
            dataControlConfigsDefinition = metaDataFrameworkManager.getDataControlConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataControlConfigsDefinition == null) {
            return null;
        }
        AdapterDataControlDefinition adapterDataControlDefinition = dataControlConfigsDefinition.getAdapterDataControlByBeanClass(string);
        if (adapterDataControlDefinition == null) {
            return null;
        }
        SourceDefinition sourceDefinition = adapterDataControlDefinition.getSourceDefinition();
        if (null != sourceDefinition) {
            String string2 = dataControlConfigsDefinition.getPackage();
            boolean bl = sourceDefinition instanceof SoapSourceDefinition;
            List list = sourceDefinition.getDefinitionDefinitions();
            if (!bl) {
                return XsdTransform.transform(this, string2, adapterDataControlDefinition.getId(), list);
            }
            String string3 = DataControlUtil.getPackageName(string) + ".";
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
                SoapDefinitionDefinition soapDefinitionDefinition = new SoapDefinitionDefinition(xmlAnyDefinition);
                if (!string.equals(string3 + soapDefinitionDefinition.getName())) continue;
                return XmlAnyTransform.transform(this, string2, soapDefinitionDefinition);
            }
        }
        return null;
    }

    public void setMetaDataCache(MetaDataCache metaDataCache) {
        this.m_cache = metaDataCache;
    }

    public Object fetch(Object object, Object object2) {
        String string = (String)object;
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "fetch", "Loading definition {0} with {1} from disk.", new Object[]{string, object2});
        }
        XmlAnyDefinition xmlAnyDefinition = this.createAny(string);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "fetch", "Fetching {0} {1}", new Object[]{string, xmlAnyDefinition == null ? " FAILED" : " was GOOD"});
        }
        if (xmlAnyDefinition == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11065", new Object[]{string});
        }
        return new JavaBeanDefinition(xmlAnyDefinition);
    }

    private void log(Level level, String string, String string2, Object[] objectArray) {
        Trace.log(Utility.FrameworkLogger, level, this.getClass(), string, string2, objectArray);
    }

    public JavaBeanDefinition getLoadedClass(String string) {
        return (JavaBeanDefinition)this.m_cache.get(string, "untyped");
    }

    public void setLoadedClass(String string, JavaBeanDefinition javaBeanDefinition) {
        this.m_cache.put(string, javaBeanDefinition);
    }

    public boolean classExists(String string) {
        Set set = this.m_cache.keySet("untyped");
        return set.contains(string);
    }
}

