/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.adfmf.metadata.bean.AccessorAttributeDefinition;
import oracle.adfmf.metadata.bean.transform.DynamicTransformUtil;
import oracle.adfmf.metadata.bean.transform.LocalPartInfo;
import oracle.adfmf.metadata.bean.transform.ManualXmlAny;
import oracle.adfmf.metadata.bean.transform.TransformUtil;
import oracle.adfmf.metadata.bean.transform.XmlAnyTransform;
import oracle.adfmf.util.XmlAnyDefinition;

class LocalPartTransform {
    private final XmlAnyTransform m_trans;
    private final ManualXmlAny m_newAny;
    private final boolean m_isInput;
    private final boolean m_isArray;
    private final String m_methodName;
    private final XmlAnyDefinition m_currentPart;

    LocalPartTransform(XmlAnyTransform xmlAnyTransform, ManualXmlAny manualXmlAny, boolean bl, boolean bl2, String string, XmlAnyDefinition xmlAnyDefinition) {
        this.m_trans = xmlAnyTransform;
        this.m_newAny = manualXmlAny;
        this.m_isInput = bl;
        this.m_isArray = bl2;
        this.m_methodName = string;
        this.m_currentPart = xmlAnyDefinition;
    }

    private String makeComplexTypeName() {
        if (this.m_isInput) {
            return TransformUtil.getAttributeValue(this.m_newAny, "id") + ".Types." + this.m_methodName;
        }
        return this.m_trans.getBeanClass() + "." + this.m_methodName;
    }

    protected static XmlAnyDefinition resolveComplexType(XmlAnyTransform xmlAnyTransform, String string) {
        return xmlAnyTransform.getModelTypes().getChildDefinition("complexType", "localPart", string);
    }

    protected static XmlAnyDefinition resolveEnumeration(XmlAnyTransform xmlAnyTransform, String string) {
        return xmlAnyTransform.getModelTypes().getChildDefinition("enumeration", "localPart", string);
    }

    private String resolveLocalPartComplexType(String string, XmlAnyDefinition xmlAnyDefinition) {
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("sequence");
        if (xmlAnyDefinition2 != null) {
            List list = LocalPartTransform.getParts(xmlAnyDefinition2);
            if (this.m_isInput) {
                string = this.makeComplexTypeName();
            } else if (list.size() > 1) {
                string = this.makeComplexTypeName();
            } else if (!list.isEmpty()) {
                string = this.makeComplexTypeName();
            }
        }
        return string;
    }

    protected static String resolveLocalPartEnumeration(String string, XmlAnyDefinition xmlAnyDefinition) {
        String string2 = TransformUtil.getAttributeValue(xmlAnyDefinition, "xsdType");
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    private String resolveLocalPart(PartInfo partInfo, String string) {
        XmlAnyDefinition xmlAnyDefinition = LocalPartTransform.resolveComplexType(this.m_trans, string);
        if (xmlAnyDefinition != null) {
            return this.resolveLocalPartComplexType(string, xmlAnyDefinition);
        }
        XmlAnyDefinition xmlAnyDefinition2 = LocalPartTransform.resolveEnumeration(this.m_trans, string);
        if (xmlAnyDefinition2 != null) {
            return LocalPartTransform.resolveLocalPartEnumeration(string, xmlAnyDefinition2);
        }
        if (partInfo.isArray && !this.m_isInput) {
            string = this.makeComplexTypeName();
        }
        return string;
    }

    protected static AccessorAttributeDefinition createAccessorAttribute(String string, String string2, String string3) {
        ManualXmlAny manualXmlAny = new ManualXmlAny("AccessorAttribute");
        TransformUtil.setAttribute(manualXmlAny, "id", string);
        TransformUtil.setAttribute(manualXmlAny, "BeanClass", string2);
        TransformUtil.setAttribute(manualXmlAny, "IsCollection", Boolean.toString(string3 != null));
        TransformUtil.setAttribute(manualXmlAny, "CollectionBeanClass", string3);
        return new AccessorAttributeDefinition(manualXmlAny);
    }

    protected static PartInfo getPartTypeInfo(XmlAnyTransform xmlAnyTransform, XmlAnyDefinition xmlAnyDefinition) {
        XmlAnyDefinition xmlAnyDefinition2;
        PartInfo partInfo = new PartInfo();
        partInfo.type = xmlAnyDefinition.getChildDefinition("type");
        partInfo.isArray = false;
        if (partInfo.type == null && (xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("array")) != null) {
            partInfo.type = xmlAnyDefinition2.getChildDefinition("type");
            partInfo.isArray = true;
        }
        return partInfo;
    }

    protected LocalPartInfo transform() {
        Object object;
        boolean bl = false;
        PartInfo partInfo = LocalPartTransform.getPartTypeInfo(this.m_trans, this.m_currentPart);
        String string = TransformUtil.getAttributeValue(partInfo.type, "localPart");
        String string2 = this.resolveLocalPart(partInfo, string);
        String string3 = DynamicTransformUtil.transformType(string2);
        if (string2 != string && string2 == string3) {
            bl = true;
        }
        boolean bl2 = false;
        if (this.m_isInput) {
            if (bl) {
                if (!this.m_isArray && !partInfo.isArray) {
                    bl2 = true;
                }
                string3 = "java.lang.Object";
                bl = false;
                object = LocalPartInfo.makeAccessorAttributeName(this.m_methodName);
                String string4 = this.makeComplexTypeName();
                if (this.m_newAny.getChildDefinition("AccessorAttribute", "id", (String)object) == null) {
                    this.m_newAny.addChild(LocalPartTransform.createAccessorAttribute((String)object, string4, null));
                }
            }
            if (this.m_isArray || partInfo.isArray) {
                string3 = string3 + "[]";
            }
        }
        object = new LocalPartInfo(string3, bl, partInfo.isArray, bl2);
        return object;
    }

    protected static List getParts(XmlAnyDefinition xmlAnyDefinition) {
        ArrayList<XmlAnyDefinition> arrayList = new ArrayList<XmlAnyDefinition>();
        List list = xmlAnyDefinition.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
            String string = xmlAnyDefinition2.getElementName();
            if (string.equals("part")) {
                arrayList.add(xmlAnyDefinition2);
                continue;
            }
            if (!string.equals("choice")) continue;
            arrayList.addAll(LocalPartTransform.getParts(xmlAnyDefinition2));
        }
        return arrayList;
    }

    static class PartInfo {
        XmlAnyDefinition type = null;
        boolean isArray = false;

        PartInfo() {
        }
    }
}

