/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.metadata.bean.transform;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.metadata.bean.AttributeDefinition;
import oracle.adfmf.metadata.bean.CustomPropertiesDefinition;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.PropertiesDefinition;
import oracle.adfmf.metadata.bean.PropertyDefinition;
import oracle.adfmf.metadata.bean.cache.SchemaAny;
import oracle.adfmf.metadata.bean.transform.DynamicTransformUtil;
import oracle.adfmf.metadata.bean.transform.LocalPartInfo;
import oracle.adfmf.metadata.bean.transform.ManualXmlAny;
import oracle.adfmf.metadata.bean.transform.TransformUtil;
import oracle.adfmf.metadata.bean.transform.XsdTransform;
import oracle.adfmf.metadata.bean.transform.XsdTypeInfo;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

class DynamicXsdTypeTransform {
    private SchemaAny m_schema;
    private final XsdTransform m_trans;
    private final boolean m_isInput;
    private final String m_methodName;
    private final String m_methodBase;
    private final String m_namespace;

    DynamicXsdTypeTransform(XsdTransform xsdTransform, boolean bl, String string, String string2) {
        this.m_trans = xsdTransform;
        this.m_isInput = bl;
        this.m_methodName = DynamicXsdTypeTransform.createMethodTypeName(string, bl);
        this.m_methodBase = string;
        this.m_namespace = string2;
    }

    protected static String createMethodTypeName(String string, boolean bl) {
        String string2 = string;
        string2 = bl ? string2 + "_parameters" : string2 + "_Data";
        return string2;
    }

    private String makeComplexTypeName() {
        return this.makeComplexTypeName(this.m_methodName);
    }

    private String makeComplexTypeName(String string) {
        return this.m_trans.getBeanClass() + "." + string;
    }

    private String makeNestedComplexTypeName() {
        String string = this.m_methodName;
        if (this.m_isInput && string.equals(DynamicXsdTypeTransform.createMethodTypeName(this.m_methodBase, true))) {
            string = DynamicXsdTypeTransform.createMethodTypeName(this.m_methodBase, false);
        }
        return this.makeComplexTypeName(string);
    }

    private boolean classNeedsCreation(String string) {
        return DynamicTransformUtil.classNeedsCreation(this.m_trans.getCacheProvider(), string);
    }

    protected void createBeanClassIfNeeded(XmlAnyDefinition xmlAnyDefinition) {
        this.m_schema = new SchemaAny(xmlAnyDefinition);
        String string = this.makeComplexTypeName();
        this.createBeanClassIfNeeded(string, this.m_schema);
    }

    private static String validateOccurs(String string) {
        if (Utility.isEmpty(string)) {
            string = "1";
        } else if (string.equals("unbounded")) {
            string = "2147483640";
        }
        return string;
    }

    private static PropertyDefinition makeOccurs(XmlAnyDefinition xmlAnyDefinition, String string) {
        String string2 = TransformUtil.getAttributeValue(xmlAnyDefinition, string);
        return DynamicTransformUtil.createPropertyDefinition(string, DynamicXsdTypeTransform.validateOccurs(string2));
    }

    private static PropertyDefinition makeMin(XmlAnyDefinition xmlAnyDefinition) {
        return DynamicXsdTypeTransform.makeOccurs(xmlAnyDefinition, "minOccurs");
    }

    private static PropertyDefinition makeMax(XmlAnyDefinition xmlAnyDefinition) {
        return DynamicXsdTypeTransform.makeOccurs(xmlAnyDefinition, "maxOccurs");
    }

    private void createBeanClassFromElement(String string, XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return;
        }
        this.createBeanClassFromComplexType(string, xmlAnyDefinition.getChildDefinition("complexType"));
    }

    private void createBeanClassFromComplexType(String string, XmlAnyDefinition xmlAnyDefinition) {
        if (xmlAnyDefinition == null) {
            return;
        }
        this.createBeanClassIfNeeded(string, xmlAnyDefinition.getChildDefinition("sequence"));
    }

    private boolean addCommonAttributes(ManualXmlAny manualXmlAny, XmlAnyDefinition xmlAnyDefinition) {
        manualXmlAny.addChild(DynamicTransformUtil.createPropertyDefinition("nillable", "false"));
        manualXmlAny.addChild(DynamicTransformUtil.createPropertyDefinition("targetNamespace", this.m_namespace));
        manualXmlAny.addChild(DynamicXsdTypeTransform.makeMin(xmlAnyDefinition));
        PropertyDefinition propertyDefinition = DynamicXsdTypeTransform.makeMax(xmlAnyDefinition);
        manualXmlAny.addChild(propertyDefinition);
        String string = TransformUtil.getAttributeValue(propertyDefinition, "Value");
        return !"0".equals(string) && !"1".equals(string);
    }

    private void addAttributeIfExists(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, String string) {
        String string2 = TransformUtil.getAttributeValue(xmlAnyDefinition, string);
        if (Utility.isEmpty(string2)) {
            return;
        }
        manualXmlAny.addChild(DynamicTransformUtil.createPropertyDefinition(string, string2));
    }

    private void addAttributeDefault(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, String string, String string2) {
        String string3 = TransformUtil.getAttributeValue(xmlAnyDefinition, string);
        if (!Utility.isEmpty(string3)) {
            return;
        }
        manualXmlAny.addChild(DynamicTransformUtil.createPropertyDefinition(string, string2));
    }

    private void addPatternAttribute(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        if (!xsdTypeInfo.supportsPattern()) {
            return;
        }
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "pattern");
    }

    private void addLengthAttribute(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        if (!xsdTypeInfo.supportsLength()) {
            return;
        }
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "length");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "minLength");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "maxLength");
    }

    private void addInclusiveAttribute(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        if (!xsdTypeInfo.supportsInclusive()) {
            return;
        }
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "minInclusive");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "minExclusive");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "maxExclusive");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "maxInclusive");
    }

    private void addDigitsAttribute(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        if (!xsdTypeInfo.supportsDigits()) {
            return;
        }
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "fractionDigits");
        this.addAttributeIfExists(xmlAnyDefinition, manualXmlAny, "totalDigits");
    }

    private void addAttributes(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        this.addPatternAttribute(xmlAnyDefinition, manualXmlAny, xsdTypeInfo);
        this.addLengthAttribute(xmlAnyDefinition, manualXmlAny, xsdTypeInfo);
        this.addInclusiveAttribute(xmlAnyDefinition, manualXmlAny, xsdTypeInfo);
        this.addDigitsAttribute(xmlAnyDefinition, manualXmlAny, xsdTypeInfo);
    }

    private void addDefaults(XmlAnyDefinition xmlAnyDefinition, ManualXmlAny manualXmlAny, XsdTypeInfo xsdTypeInfo) {
        Map map = xsdTypeInfo.getDefaults();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            this.addAttributeDefault(xmlAnyDefinition, manualXmlAny, string, string2);
        }
    }

    private ManualXmlAny createNewClass(String string) {
        return DynamicTransformUtil.createXmlAny(string);
    }

    private void registerNewClass(String string, JavaBeanDefinition javaBeanDefinition) {
        this.m_trans.getCacheProvider().setLoadedClass(string, javaBeanDefinition);
    }

    private void createBeanClassIfNeeded(String string, XmlAnyDefinition xmlAnyDefinition) {
        XmlAnyDefinition xmlAnyDefinition2;
        if (xmlAnyDefinition == null) {
            return;
        }
        if (!this.classNeedsCreation(string)) {
            return;
        }
        ManualXmlAny manualXmlAny = this.createNewClass(string);
        List list = xmlAnyDefinition.getChildDefinitions("element");
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            XmlAnyDefinition xmlAnyDefinition3;
            String string2;
            ManualXmlAny manualXmlAny2;
            Object object;
            xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
            String string3 = TransformUtil.getAttributeValue(xmlAnyDefinition2, "type");
            String string4 = TransformUtil.getAttributeValue(xmlAnyDefinition2, "name");
            if (Utility.isEmpty(string3)) {
                object = this.makeNestedComplexTypeName() + "_" + string4;
                this.createBeanClassFromElement((String)object, xmlAnyDefinition2);
                manualXmlAny2 = new ManualXmlAny("Properties");
                boolean bl2 = this.addCommonAttributes(manualXmlAny2, xmlAnyDefinition2);
                bl = bl || bl2;
                string2 = bl2 ? LocalPartInfo.makeCollectionBeanClassName(string) : null;
                xmlAnyDefinition3 = DynamicTransformUtil.createAccessorAttribute(string, string4, (String)object, string2, new PropertiesDefinition(manualXmlAny2));
                manualXmlAny.addChild(xmlAnyDefinition3);
                continue;
            }
            object = XsdTypeInfo.get(this.m_schema, string3);
            if (object == null) continue;
            manualXmlAny2 = new ManualXmlAny("CustomProperties");
            String string5 = ((XsdTypeInfo)object).getJavaType();
            string2 = ((XsdTypeInfo)object).getLocalName();
            this.addAttributes(xmlAnyDefinition2, manualXmlAny2, (XsdTypeInfo)object);
            this.addDefaults(xmlAnyDefinition2, manualXmlAny2, (XsdTypeInfo)object);
            manualXmlAny2.addChild(DynamicTransformUtil.createPropertyDefinition("type", string2));
            manualXmlAny2.addChild(DynamicTransformUtil.createPropertyDefinition("LeafElement_hint", "LeafElement_no_attribute"));
            bl = bl || this.addCommonAttributes(manualXmlAny2, xmlAnyDefinition2);
            xmlAnyDefinition3 = new ManualXmlAny("Properties");
            ((ManualXmlAny)xmlAnyDefinition3).addChild(new CustomPropertiesDefinition(manualXmlAny2));
            AttributeDefinition attributeDefinition = DynamicTransformUtil.createAttribute(string4, "0", null, string5, new PropertiesDefinition(xmlAnyDefinition3));
            manualXmlAny.addChild(attributeDefinition);
        }
        xmlAnyDefinition2 = new JavaBeanDefinition(manualXmlAny);
        this.registerNewClass(string, (JavaBeanDefinition)xmlAnyDefinition2);
        if (bl) {
            this.createBeanCollectionClassIfNeeded(string);
        }
    }

    private void createBeanCollectionClassIfNeeded() {
        this.createBeanCollectionClassIfNeeded(this.makeComplexTypeName());
    }

    private void createBeanCollectionClassIfNeeded(String string) {
        String string2 = LocalPartInfo.makeCollectionBeanClassName(string);
        if (!this.classNeedsCreation(string2)) {
            return;
        }
        ManualXmlAny manualXmlAny = this.createNewClass(string2);
        manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("First"));
        manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("Next"));
        manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("Previous"));
        manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("Last"));
        if (this.m_isInput) {
            manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("Create"));
        } else {
            manualXmlAny.addChild(DynamicTransformUtil.createBuiltInOperation("IteratorExecute"));
        }
        JavaBeanDefinition javaBeanDefinition = new JavaBeanDefinition(manualXmlAny);
        this.registerNewClass(string2, javaBeanDefinition);
    }

    static class PartInfo {
        XmlAnyDefinition type = null;
        boolean isArray = false;

        PartInfo() {
        }
    }
}

