/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.message.adf;

import oracle.adfmf.util.Utility;

public class AdfHeader {
    private static int ADF_HEADER_FIELD_SIZE = 6;
    private static int ADF_HEADER_TAG_START = 0;
    private static int ADF_HEADER_TYPE_START = ADF_HEADER_TAG_START + ADF_HEADER_FIELD_SIZE;
    private static int ADF_HEADER_REFERENCE_START = ADF_HEADER_TYPE_START + ADF_HEADER_FIELD_SIZE;
    private static int ADF_HEADER_CORRELATION_ID_START = ADF_HEADER_REFERENCE_START + ADF_HEADER_FIELD_SIZE;
    private static int ADF_HEADER_TRANSACTION_ID_START = ADF_HEADER_CORRELATION_ID_START + ADF_HEADER_FIELD_SIZE;
    private static int ADF_HEADER_BODY_SIZE_START = ADF_HEADER_TRANSACTION_ID_START + ADF_HEADER_FIELD_SIZE;
    public static int ADF_HEADER_SIZE = ADF_HEADER_BODY_SIZE_START + ADF_HEADER_FIELD_SIZE;
    protected String headerTag = null;
    protected int type = -1;
    protected int referenceId = -1;
    protected int correlationId = -1;
    protected int transactionId = -1;
    protected int bodySize = -1;

    private AdfHeader(String string, int n, int n2, int n3, int n4) {
        this.headerTag = string;
        this.type = n;
        this.referenceId = n2;
        this.correlationId = n3;
        this.transactionId = n4;
    }

    public AdfHeader(int n, int n2, int n3, int n4) {
        this.headerTag = "ADFMSG";
        this.type = n;
        this.referenceId = n2;
        this.correlationId = n3;
        this.transactionId = n4;
    }

    private AdfHeader(String string) {
        if (string.length() < ADF_HEADER_SIZE) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10011", new Object[]{new Integer(string.length()), new Integer(ADF_HEADER_SIZE)}));
        }
        this.headerTag = this.getFieldAt(string, ADF_HEADER_TAG_START);
        this.type = Integer.parseInt(this.getFieldAt(string, ADF_HEADER_TYPE_START));
        this.referenceId = Integer.parseInt(this.getFieldAt(string, ADF_HEADER_REFERENCE_START));
        this.correlationId = Integer.parseInt(this.getFieldAt(string, ADF_HEADER_CORRELATION_ID_START));
        this.transactionId = Integer.parseInt(this.getFieldAt(string, ADF_HEADER_TRANSACTION_ID_START));
        this.bodySize = Integer.parseInt(this.getFieldAt(string, ADF_HEADER_BODY_SIZE_START));
    }

    public static AdfHeader parse(String string) {
        return new AdfHeader(string);
    }

    AdfHeader copy() {
        return new AdfHeader(this.headerTag, this.type, this.referenceId, this.correlationId, this.transactionId);
    }

    public boolean isAdfMessage() {
        return true;
    }

    public boolean isAdfRequestMessage() {
        return this.correlationId == 0;
    }

    public boolean isAdfResponseMessage() {
        return this.correlationId != 0;
    }

    public String toString() {
        return this.format6l(this.headerTag) + this.format6r(this.type) + this.format6r(this.referenceId) + this.format6r(this.correlationId) + this.format6r(this.transactionId) + this.format6r(this.bodySize);
    }

    String format6l(String string) {
        String string2 = string + "      ";
        return string2.substring(0, 6);
    }

    String format6r(int n) {
        String string = "      " + Integer.toString(n);
        return string.substring(string.length() - 6);
    }

    protected String getFieldAt(String string, int n) {
        return string.substring(n, n + ADF_HEADER_FIELD_SIZE).trim();
    }

    public int getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(int n) {
        this.correlationId = n;
    }

    public int getType() {
        return this.type;
    }

    public void setReferenceId(int n) {
        this.referenceId = n;
    }

    public int getReferenceId() {
        return this.referenceId;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getBodySize() {
        return this.bodySize;
    }

    void setBodySize(int n) {
        this.bodySize = n;
    }
}

