/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.exception;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;

public class AdfException
extends RuntimeException
implements JSONSerializable {
    private static final long serialVersionUID = -6096237579578941049L;
    private static final String SEVERITY_PROPERTY_FILENAME = "oracle/adfmf/framework/message/severity.map";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String FATAL = "FATAL";
    private static final String MESSAGE_KEY = "message";
    private static final String INTERNAL_ERROR = "Internal Error";
    private static Properties s_severityMap = null;
    private String message = null;
    private String severity = null;
    private String type = null;
    private boolean exception = true;

    public AdfException() {
        this(INTERNAL_ERROR, FATAL);
    }

    public AdfException(String string, String string2, String string3, Object[] objectArray) {
        this(Utility.getResourceString(string2, string3, objectArray), string);
    }

    public AdfException(String string, String string2) {
        this.setException(string, string2);
    }

    public AdfException(Throwable throwable) {
        this(throwable, AdfException.lookupSeverityMapping(throwable.getClass().getName(), ERROR));
    }

    public AdfException(Throwable throwable, String string) {
        if (null == throwable) {
            throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10012"));
        }
        String string2 = throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getName();
        this.setException(string2, string);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String string) {
        if (INFO.equalsIgnoreCase(string)) {
            this.severity = INFO;
        } else if (WARNING.equalsIgnoreCase(string)) {
            this.severity = WARNING;
        } else if (ERROR.equalsIgnoreCase(string)) {
            this.severity = ERROR;
        } else if (FATAL.equalsIgnoreCase(string)) {
            this.severity = FATAL;
        } else {
            throw new IllegalArgumentException("severity");
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isException() {
        return this.exception;
    }

    public void setException(boolean bl) {
        this.exception = bl;
    }

    private void setException(String string, String string2) {
        this.setException(true);
        this.setMessage(string);
        this.setSeverity(string2);
        this.setType(this.getClass().getName());
    }

    private static String lookupSeverityMapping(String string, String string2) {
        if (s_severityMap == null) {
            s_severityMap = new Properties();
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(SEVERITY_PROPERTY_FILENAME);
                if (inputStream != null) {
                    s_severityMap.load(inputStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s_severityMap.getProperty(string, string2);
    }

    public String toString() {
        return this.severity + " [" + this.type + "] - " + this.message;
    }

    public Object toJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(MESSAGE_KEY, this.message);
        jSONObject.put("severity", this.severity);
        jSONObject.put(".type", this.type);
        jSONObject.put(".exception", this.exception);
        return jSONObject;
    }
}

