/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.api;

import [Ljava.lang.Byte;;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.adfmf.beans.BeanInfo;
import oracle.adfmf.beans.IntrospectionException;
import oracle.adfmf.beans.Introspector;
import oracle.adfmf.beans.PropertyDescriptor;
import oracle.adfmf.dc.VirtualJavaBeanObject;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.metadata.bean.AccessorAttributeDefinition;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.misc.ISO8601DateTimeUtil;
import oracle.adfmf.util.AttributeInfo;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;

public class GenericTypeBeanSerializationHelper {
    private GenericTypeBeanSerializationHelper() {
    }

    public static GenericType toGenericType(String string, Object object) {
        JavaBeanDefinition javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(string);
        if (javaBeanDefinition == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11115", new Object[]{string});
        }
        GenericVirtualType genericVirtualType = new GenericVirtualType(javaBeanDefinition.getPackage(), javaBeanDefinition.getId());
        if (object == null) {
            return genericVirtualType;
        }
        VirtualJavaBeanObject virtualJavaBeanObject = new VirtualJavaBeanObject(javaBeanDefinition.getPackage(), javaBeanDefinition.getId(), javaBeanDefinition);
        Class<?> clazz = object.getClass();
        if (GenericTypeBeanSerializationHelper.isArray(clazz)) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11119", new Object[]{clazz});
        }
        GenericTypeBeanSerializationHelper.setAttributesForGenericType(genericVirtualType, virtualJavaBeanObject, object, clazz);
        return genericVirtualType;
    }

    public static void fromGenericType(Object object, GenericType genericType) {
        GenericTypeBeanSerializationHelper.fromGenericType(object, genericType, null);
    }

    public static Object fromGenericType(Class clazz, GenericType genericType) {
        return GenericTypeBeanSerializationHelper.fromGenericType(clazz, genericType, null);
    }

    public static Object fromGenericType(Class clazz, GenericType genericType, String string) {
        if (GenericTypeBeanSerializationHelper.isArray(clazz)) {
            if (Utility.isEmpty(string)) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11118", new Object[]{genericType.getName()});
            }
            return GenericTypeBeanSerializationHelper.fromGenericTypeArray(genericType, string, clazz);
        }
        Cloneable cloneable = null;
        try {
            cloneable = (Cloneable)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            if (clazz != null && clazz.equals(List.class)) {
                cloneable = new Vector();
            }
            if (clazz != null && clazz.equals(Map.class)) {
                cloneable = new HashMap();
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11156", new Object[]{clazz});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11157", new Object[]{clazz});
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11117", new Object[]{clazz});
        }
        GenericTypeBeanSerializationHelper.fromGenericType(cloneable, genericType, string);
        return cloneable;
    }

    private static void fromGenericType(Object object, GenericType genericType, String string) {
        if (!Utility.isEmpty(string)) {
            genericType = (GenericType)genericType.getAttribute(string);
        }
        GenericTypeBeanSerializationHelper.setAttributesForBean(genericType, object, object.getClass());
    }

    private static boolean isArray(Class clazz) {
        if (clazz != null && clazz.isArray()) {
            return clazz != [B.class && clazz != Byte;.class;
        }
        return false;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo((Class)clazz);
        }
        catch (IntrospectionException introspectionException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11111", new Object[]{clazz});
        }
        return beanInfo.getPropertyDescriptors();
    }

    private static void setAttributeImpl(GenericVirtualType genericVirtualType, VirtualJavaBeanObject virtualJavaBeanObject, AttributeInfo attributeInfo, Object object) {
        Class clazz = (Class)attributeInfo.type;
        if (object != null && GenericTypeBeanSerializationHelper.isArray(object.getClass())) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                GenericTypeBeanSerializationHelper.setAttributeImpl(genericVirtualType, virtualJavaBeanObject, attributeInfo, Array.get(object, i));
            }
            return;
        }
        if (object != null && object instanceof List) {
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                GenericTypeBeanSerializationHelper.setAttributeImpl(genericVirtualType, virtualJavaBeanObject, attributeInfo, e);
            }
            return;
        }
        if (object != null && !Utility.isStandardType(object.getClass()) && !ISO8601DateTimeUtil.isDateType(object.getClass())) {
            JavaBeanDefinition javaBeanDefinition = virtualJavaBeanObject.getDefinition();
            AccessorAttributeDefinition accessorAttributeDefinition = null;
            if (javaBeanDefinition != null && (accessorAttributeDefinition = javaBeanDefinition.getAccessorAttributeDefinition(attributeInfo.name)) == null) {
                accessorAttributeDefinition = javaBeanDefinition.getAccessorAttributeDefinitionBySourceName(attributeInfo.name);
            }
            if (accessorAttributeDefinition == null) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11114", new Object[]{attributeInfo.name, javaBeanDefinition.getBeanClass()});
            }
            object = GenericTypeBeanSerializationHelper.toGenericType(accessorAttributeDefinition.getBeanClass(), object);
        } else {
            object = Utility.coerceToType(object, clazz);
        }
        genericVirtualType.defineAttribute(genericVirtualType.getNamespace(), attributeInfo.name, clazz, object);
    }

    private static void setAttributesForGenericType(GenericVirtualType genericVirtualType, VirtualJavaBeanObject virtualJavaBeanObject, Map map, List list) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (!(k instanceof String) || list.contains(string = (String)k)) continue;
            list.add(string);
            AttributeInfo attributeInfo = virtualJavaBeanObject.getAttributeInfo(string);
            if (attributeInfo == null) continue;
            Object v = entry.getValue();
            GenericTypeBeanSerializationHelper.setAttributeImpl(genericVirtualType, virtualJavaBeanObject, attributeInfo, v);
        }
    }

    private static void setAttributesForGenericType(GenericVirtualType genericVirtualType, VirtualJavaBeanObject virtualJavaBeanObject, Object object, Class clazz) {
        PropertyDescriptor[] propertyDescriptorArray = GenericTypeBeanSerializationHelper.getPropertyDescriptors(clazz);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo;
            String string;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string2 = propertyDescriptor.getName();
            arrayList.add(string2);
            Method method = propertyDescriptor.getReadMethod();
            if (method == null || Utility.isEmpty(string = Utility.getGetterVariable(method)) || Utility.isVariableTransient(clazz, string) || (attributeInfo = virtualJavaBeanObject.getAttributeInfo(string2)) == null) continue;
            Object object2 = null;
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            if (reflectiveOperationException != null) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11113", new Object[]{string2, object.getClass()});
            }
            GenericTypeBeanSerializationHelper.setAttributeImpl(genericVirtualType, virtualJavaBeanObject, attributeInfo, object2);
        }
        if (object instanceof Map) {
            GenericTypeBeanSerializationHelper.setAttributesForGenericType(genericVirtualType, virtualJavaBeanObject, (Map)object, arrayList);
        }
    }

    private static Object fromGenericTypeArray(GenericType genericType, String string, Class clazz) {
        Object object;
        int n = genericType.getAttributeCount(string);
        Class clazz2 = null;
        if (clazz == null) {
            if (GenericType.class.isAssignableFrom(clazz2 = (Class)genericType.getAttributeInfo((String)string).type)) {
                clazz2 = HashMap.class;
            }
        } else {
            clazz2 = clazz.getComponentType();
        }
        if ((object = Utility.createArray(clazz2, n)) == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.SharedErrorBundle", "ADF-MF-10020", new Object[]{clazz2, new Integer(n)});
        }
        for (int i = 0; i < n; ++i) {
            Object object2 = genericType.getAttribute(string, i);
            GenericType genericType2 = null;
            if (object2 instanceof GenericType) {
                genericType2 = (GenericType)object2;
                object2 = null;
            }
            if (genericType2 != null && Utility.isStandardType(clazz2)) {
                if (string == null) {
                    throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11118", new Object[]{genericType.getName()});
                }
                if (genericType2.getAttributeCount() == 1 && genericType2.getAttributeCount(string) == 1) {
                    Object object3 = genericType2.getAttribute(string);
                    if (object3 instanceof GenericType) {
                        genericType2 = (GenericType)object3;
                    } else {
                        genericType2 = null;
                        object2 = object3;
                    }
                }
            }
            if (genericType2 != null) {
                object2 = GenericTypeBeanSerializationHelper.fromGenericType(clazz2, genericType2);
            }
            object2 = Utility.coerceToType(object2, clazz2);
            Array.set(object, i, object2);
        }
        return object;
    }

    private static void setAttributesForBean(GenericType genericType, Map map, List list) {
        int n = genericType.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            AttributeInfo attributeInfo = genericType.getAttributeInfo(i);
            String string = attributeInfo.name;
            if (list.contains(string)) continue;
            list.add(string);
            int n2 = genericType.getAttributeCount(string);
            if (n2 > 1) {
                object = GenericTypeBeanSerializationHelper.fromGenericTypeArray(genericType, string, null);
            } else {
                object = genericType.getAttribute(string);
                if (object instanceof GenericType) {
                    object = GenericTypeBeanSerializationHelper.fromGenericType(class$java$util$HashMap == null ? GenericTypeBeanSerializationHelper.class$("java.util.HashMap") : class$java$util$HashMap, (GenericType)object);
                }
            }
            map.put(string, object);
        }
    }

    private static void setAttributesForBean(GenericType genericType, Object object, Class clazz) {
        PropertyDescriptor[] propertyDescriptorArray = GenericTypeBeanSerializationHelper.getPropertyDescriptors(clazz);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = propertyDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            AttributeInfo attributeInfo;
            String string;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string2 = propertyDescriptor.getName();
            arrayList.add(string2);
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null || Utility.isEmpty(string = Utility.getSetterVariable(method)) || Utility.isVariableTransient(clazz, string) || (attributeInfo = genericType.getAttributeInfo(string2)) == null) continue;
            Class clazz2 = propertyDescriptor.getPropertyType();
            if (GenericTypeBeanSerializationHelper.isArray(clazz2)) {
                object2 = GenericTypeBeanSerializationHelper.fromGenericTypeArray(genericType, string2, clazz2);
            } else {
                object2 = genericType.getAttribute(string2);
                if (object2 instanceof GenericType) {
                    object2 = GenericTypeBeanSerializationHelper.fromGenericType(clazz2, (GenericType)object2);
                }
            }
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                object2 = Utility.coerceToType(object2, propertyDescriptor.getPropertyType());
                method.invoke(object, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                reflectiveOperationException = invocationTargetException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            if (reflectiveOperationException == null) continue;
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11112", new Object[]{object2, string2, object.getClass()});
        }
        if (object instanceof Map) {
            GenericTypeBeanSerializationHelper.setAttributesForBean(genericType, (Map)object, arrayList);
        }
    }
}

