/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework.api;

import com.sun.util.logging.Level;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import oracle.adfmf.bindings.DataControl;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.bindings.dbf.ContainerContext;
import oracle.adfmf.dc.DataControlUtil;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObject;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.FeatureContext;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationException;
import oracle.adfmf.framework.exception.AdfInvocationRuntimeException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.util.CredentialStoreUtil;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class AdfmfJavaUtilities {
    public static final int TemporaryDirectory = 0;
    public static final int ApplicationDirectory = 1;
    public static final int DeviceOnlyDirectory = 2;
    public static final int DownloadDirectory = 3;
    public static final int DatabaseNoEncryption = 0;
    public static final int DatabaseAES128Encryption = 1;
    public static final int DatabaseAES256Encryption = 2;
    public static final int DatabaseRC4Encryption = 3;
    public static final int DatabaseDefaultEncryption = 1;
    public static final String AES128 = "aes128";
    public static final String AES256 = "aes256";
    public static final String RC4 = "rc4";

    public static String getDirectoryPathRoot(int n) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, AdfmfJavaUtilities.class, "getDirectoryPathRoot", (Object)Integer.toString(n));
        }
        String string = "oracle.adfmf.framework.api.AdfmfContainerUtilitiesHandler";
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "getTempRoot";
                break;
            }
            case 1: {
                string2 = "getDocumentRoot";
                break;
            }
            case 2: {
                string2 = "getCacheRoot";
                break;
            }
            case 3: {
                if (Utility.getOSFamily() == 1) {
                    string2 = "getDownloadRoot";
                    break;
                }
                string2 = "getDocumentRoot";
                break;
            }
            default: {
                throw new IllegalArgumentException(Utility.getResourceString("oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11091"));
            }
        }
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, AdfmfJavaUtilities.class, "getDirectoryPathRoot", (Object)string2);
        }
        return (String)AdfmfContainerUtilities.invokeContainerMethod(string, string2, new Object[0]);
    }

    public static FeatureContext getFeatureContext() {
        return EmbeddedFeatureContext.getInstance();
    }

    public static String getFeatureName() throws AdfException {
        return AdfmfJavaUtilities.getFeatureContext().getName();
    }

    public static AdfELContext getAdfELContext() {
        return EmbeddedFeatureContext.getInstance().getAdfELContext();
    }

    public static String getActiveContextId() {
        try {
            AdfELContext adfELContext = AdfmfJavaUtilities.getAdfELContext();
            ContainerContext containerContext = (ContainerContext)adfELContext.evaluateVariable("bindings_cctx");
            if (containerContext != null) {
                AmxBindingContainer amxBindingContainer = containerContext.getContainer();
                if (amxBindingContainer != null) {
                    return amxBindingContainer.getName();
                }
                return (String)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("bindings_contextKey");
            }
            return AdfmfJavaUtilities.getFeatureName();
        }
        catch (Exception exception) {
            throw new AdfException(exception, "ERROR");
        }
    }

    public static ValueExpression getValueExpression(String string, Class clazz) {
        AdfELContext adfELContext = AdfmfJavaUtilities.getAdfELContext();
        return adfELContext.getExpressionFactory().createValueExpression((ELContext)adfELContext, string, clazz);
    }

    public static MethodExpression getMethodExpression(String string, Class clazz, Class[] classArray) {
        AdfELContext adfELContext = AdfmfJavaUtilities.getAdfELContext();
        return adfELContext.getExpressionFactory().createMethodExpression((ELContext)adfELContext, string, clazz, classArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateELExpression(String string) throws AdfException {
        AdfELContext adfELContext;
        AdfELContext adfELContext2 = adfELContext = AdfmfJavaUtilities.getAdfELContext();
        synchronized (adfELContext2) {
            ValueExpression valueExpression = AdfmfJavaUtilities.getValueExpression(string, Object.class);
            return valueExpression.getValue((ELContext)adfELContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setELValue(String string, Object object) {
        AdfELContext adfELContext;
        AdfELContext adfELContext2 = adfELContext = AdfmfJavaUtilities.getAdfELContext();
        synchronized (adfELContext2) {
            ValueExpression valueExpression = AdfmfJavaUtilities.getValueExpression(string, Object.class);
            valueExpression.setValue((ELContext)adfELContext, object);
        }
    }

    public static boolean isEvaluationExpression(String string) {
        ValueExpression valueExpression = AdfmfJavaUtilities.getValueExpression(string, Object.class);
        return !valueExpression.isLiteralText();
    }

    public static void flushDataChangeEvent() {
        ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager().flushDataChangeEvents();
    }

    public static Object invokeDataControlMethod(String string, String string2, String string3, List list, List list2, List list3) throws AdfInvocationException {
        try {
            return DataControlUtil.invokeDataControlMethod(string, string2, string3, list, list2, list3);
        }
        catch (AdfInvocationRuntimeException adfInvocationRuntimeException) {
            throw new AdfInvocationException(adfInvocationRuntimeException);
        }
    }

    public static void clearPasswordCredential(String string, String string2) throws AdfException {
        String string3;
        Object object = CredentialStoreUtil.clearPasswordForAuthUrl(string, string2);
        if (object instanceof String && "true".equals(string3 = (String)object)) {
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, AdfmfJavaUtilities.class, "clearPasswordCredential", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40130", new Object[]{string2, string});
            }
            return;
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11143", new Object[]{string2, string});
    }

    public static void logout() throws AdfException {
        CredentialStoreUtil.logout();
    }

    public static boolean isPrimaryRequestThread() {
        return AdfmfJavaUtilities.getFeatureContext().isPrimaryRequestThread();
    }

    public static boolean isBackgroundThread() {
        return AdfmfJavaUtilities.getFeatureContext().isBackgroundThread();
    }

    public static int encryptDatabase(Connection connection, String string) {
        try {
            Statement statement = connection.createStatement();
            if (Utility.isEmpty(string)) {
                string = "";
            }
            statement.execute("PRAGMA rekey='" + string + "'");
            statement.close();
            if (Utility.isEmpty(string)) {
                return 0;
            }
            if (string.length() <= 3) {
                return 1;
            }
            String string2 = string.substring(0, 3);
            if (RC4.equalsIgnoreCase(string2)) {
                return 3;
            }
            if (AES256.equalsIgnoreCase(string2)) {
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11109", new Object[]{exception});
        }
    }

    public static void decryptDatabase(Connection connection) {
        try {
            AdfmfJavaUtilities.encryptDatabase(connection, "");
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11110", new Object[]{exception});
        }
    }

    public static void loadXliffResourceBundle(String string, String string2) throws AdfException {
        Model model = new Model();
        model.loadBundle(string, string2);
        model = null;
    }

    public static Object getDataControlProvider(String string) throws AdfException {
        AmxBindingContext amxBindingContext = (AmxBindingContext)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("data");
        DataControl dataControl = (DataControl)amxBindingContext.get(string);
        if (dataControl != null) {
            Object object = dataControl.getDataProvider();
            if (object instanceof ConcreteJavaBeanObject) {
                ConcreteJavaBeanObject concreteJavaBeanObject = (ConcreteJavaBeanObject)object;
                object = concreteJavaBeanObject.getInstance();
            }
            return object;
        }
        throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11155", new Object[]{string});
    }
}

