/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.framework;

import com.sun.util.logging.Level;
import java.util.HashMap;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.event.DataChangeManager;
import oracle.adfmf.framework.event.FrameworkPropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeEvent;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class Scope
extends HashMap {
    public static final String APPLICATION_SCOPE = "applicationScope";
    public static final String DEVICE_SCOPE = "deviceScope";
    public static final String PAGE_FLOW_SCOPE = "pageFlowScope";
    public static final String PREFERENCE_SCOPE = "preferenceScope";
    public static final String SHARED_SCOPE = "shareScope";
    public static final String SECURITY_SCOPE = "securityContext";
    public static final String VIEW_SCOPE = "viewScope";
    private static final long serialVersionUID = 1L;
    protected final String scopeName;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    static void warnCannotLocate(Object object, String string) {
        if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, Scope.class, "get", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40050", new Object[]{object.toString(), string});
        }
    }

    public Scope(String string) {
        this.scopeName = string;
        FrameworkPropertyChangeListener.addFrameworkPropertyChangeListener(this, string);
    }

    public String getScopeName() {
        return this.scopeName;
    }

    protected EmbeddedFeatureContext getFeatureContext() {
        return (EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext();
    }

    protected void warnCannotLocate(Object object) {
        Scope.warnCannotLocate(object, this.scopeName);
    }

    public Object get(Object object) {
        Object v = super.get(object);
        if (v == null && Utility.FrameworkLogger.isLoggable(Level.WARNING) && !this.containsKey(object)) {
            this.warnCannotLocate(object);
        }
        return v;
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, true);
    }

    protected Object put(Object object, Object object2, boolean bl) {
        Object object3 = super.put(object, object2);
        if (bl) {
            this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent((Object)this, object.toString(), null, object2));
        }
        return object3;
    }

    public void clear() {
        super.clear();
        DataChangeManager dataChangeManager = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getDataChangeManager();
        dataChangeManager.enqueue(AdfmfJavaUtilities.getActiveContextId(), new PropertyChangeEvent(this, this.scopeName, this, null, System.currentTimeMillis()));
    }

    public boolean isMissingKeyResolvable() {
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

