/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws.soap;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfinternal.model.adapter.webservice.provider.soap.SOAPProvider;
import oracle.adfinternal.model.adapter.webservice.provider.soap.SoapHeader;
import oracle.adfinternal.model.adapter.webservice.provider.soap.SoapHeaderConverter;
import oracle.adfmf.dc.VirtualJavaBeanObject;
import oracle.adfmf.dc.ws.soap.SoapBareUtil;
import oracle.adfmf.dc.ws.soap.SoapGenericType;
import oracle.adfmf.dc.ws.soap.SoapTransportLayer;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.metadata.bean.AccessorAttributeDefinition;
import oracle.adfmf.metadata.bean.AttributeDefinition;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.cache.NamespaceCache;
import oracle.adfmf.metadata.bean.cache.SchemaAny;
import oracle.adfmf.metadata.bean.cache.SchemaAnyCache;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.dcx.soap.SoapDefinitionDefinition;
import oracle.adfmf.metadata.dcx.soap.SoapPortDefinition;
import oracle.adfmf.metadata.dcx.soap.SoapServiceDefinition;
import oracle.adfmf.util.AttributeInfo;
import oracle.adfmf.util.EmbeddedUtility;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;
import oracle.adfmf.util.regex.Pattern;
import oracle.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapPrimitive;

public class SoapWebServiceOperation
extends SoapTransportLayer {
    public static final String WSDL_NS = "http://www.w3.org/ns/wsdl";
    public static final String WSDL11_NS = "http://schemas.xmlsoap.org/wsdl/";
    private static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP11_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String SOAP12_NS = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String SOAPENC_NS = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String MIME_NS = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String HTTP_NS = "http://schemas.xmlsoap.org/wsdl/http/";
    private static final int SOAP_11 = 110;
    private static final int SOAP_12 = 120;
    public static final List WSDL_NS_LIST;
    private static final List SOAP_NS_LIST;
    public static final List SCHEMA_NS_LIST;
    private static final String WEBSERVICE_CONNECTION = "WebServiceConnection";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String MODEL = "model";
    private static final String PASSWORD = "password";
    private static final String PORT = "port";
    private static final String SERVICE = "service";
    private static final String SOAP = "soap";
    private static final String SOAP_ACTION = "soapAction";
    private static final String USERNAME = "username";
    private static final String WSCONNECTION = "wsconnection";
    private static final String NAME = "name";
    private static final String URI = "uri";
    private static final String POLICY_REFERENCES = "policy-references";
    private static final String POLICY_REFERENCE = "policy-reference";
    private static final Pattern PARSE_PATTERN_1;
    protected static final String ITEM = "item";
    protected String m_inputNamespace = null;
    protected String m_outputNamespace = null;
    private String m_usernameToken = null;
    private String m_passwordToken = null;
    private final SoapDefinitionDefinition m_defDef;
    private SchemaAny m_wsdlAny;
    private SchemaAny m_inputParametersWsdlFragment;
    private SchemaAny[] m_inputHeaderWsdlFragments;
    private SchemaAny m_outputResponseWsdlFragment;
    private boolean m_isDocument;
    private boolean m_inputIsLiteral;
    private boolean m_outputIsLiteral;
    private ArrayList m_hoistedParams = new ArrayList();
    private ArrayList m_hoistedArrayParams = new ArrayList();
    static /* synthetic */ Class class$oracle$adfmf$util$GenericType;
    static /* synthetic */ Class class$java$lang$Object;

    public SoapWebServiceOperation(SoapDefinitionDefinition soapDefinitionDefinition, SoapServiceDefinition soapServiceDefinition, String string) {
        super(soapServiceDefinition.getNamespace(), soapServiceDefinition.getConnection(), string);
        Object object;
        this.m_defDef = soapDefinitionDefinition;
        String string2 = soapServiceDefinition.getNamespace();
        if (!Utility.isEmpty(string2)) {
            object = string2.endsWith("/") ? "" : "/";
            this.setSoapAction(string2 + (String)object + string);
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, SoapWebServiceOperation.class, "SoapWebServiceOperation", "Registering action: {0}", new Object[]{this.getSoapAction()});
            }
        }
        object = new SoapPortDefinition((XmlAnyDefinition)soapServiceDefinition.getPorts().get(0));
        this.loadConnectionInformation(soapServiceDefinition.getConnection(), soapServiceDefinition.getName(), ((SoapPortDefinition)object).getName(), string);
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, SoapWebServiceOperation.class, "SoapWebServiceOperation", "WebService: {0} Endpoint: {1} Port: {2} SOAP-Action: {3} SOAP-Version: {4}", new Object[]{soapServiceDefinition.getConnection(), this.getEndpoint(), ((SoapPortDefinition)object).getName(), this.getSoapAction(), new Integer(this.version)});
        }
    }

    private SoapGenericType makeSoapGenericType(GenericType genericType, String string, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        int n;
        String string2;
        AttributeInfo attributeInfo;
        int n2;
        int n3;
        Object object4;
        String string3;
        if (genericType instanceof SoapGenericType) {
            return (SoapGenericType)genericType;
        }
        if (Utility.isEmpty(string) && Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
            Trace.log(Utility.FrameworkLogger, Level.SEVERE, SoapWebServiceOperation.class, "makeSoapGenericType", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11107", new Object[]{string});
        }
        if (Utility.isEmpty(string3 = NamespaceCache.getInstance().getElementNamespaceForId(string))) {
            string3 = this.m_inputNamespace;
        }
        Object object5 = genericType.getName();
        if (!Utility.isEmpty(string)) {
            object4 = NamespaceCache.splitNamespaceCacheId(string);
            object5 = object4[((Object)object4).length - 1];
        }
        object4 = this.getHeaderAttrNames();
        int n4 = object4.size();
        SoapGenericType soapGenericType = new SoapGenericType(string3, (String)object5);
        if (bl && this.m_inputIsLiteral && this.m_isDocument) {
            n3 = genericType.getAttributeCount();
            for (n2 = 0; n2 < n3; ++n2) {
                attributeInfo = genericType.getAttributeInfo(n2);
                string2 = attributeInfo.name;
                if (n4 > 0 && object4.contains(string2)) continue;
                String string4 = NamespaceCache.createNamespaceCacheId(new String[]{string, string2});
                if (NamespaceCache.getInstance().namespaceEntryExistsForId(string4)) continue;
                n = n3 - n4 == 1 ? 1 : 0;
                boolean bl2 = n != 0 && this.m_isInputDocLitBare && genericType.isComplexType();
                boolean bl3 = false;
                if (!bl2 && genericType instanceof VirtualJavaBeanObject) {
                    object3 = ((VirtualJavaBeanObject)genericType).getDefinition();
                    object2 = ((JavaBeanDefinition)object3).getAccessorAttributeDefinition(string2);
                    if (object2 == null || !((AccessorAttributeDefinition)object2).isCollection()) continue;
                    object = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(((AccessorAttributeDefinition)object2).getBeanClass());
                    if (((JavaBeanDefinition)object).getAttributeDefinition(ITEM) != null) {
                        bl3 = true;
                    }
                }
                if (!bl2 && !bl3) continue;
                if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
                    object3 = "JavaBeanDefinition {0} does not correspond to anything in the WSDL; hoisting its children up one level";
                    Trace.log(Utility.FrameworkLogger, Level.FINE, class$oracle$adfmf$dc$ws$soap$SoapWebServiceOperation == null ? SoapWebServiceOperation.class$("oracle.adfmf.dc.ws.soap.SoapWebServiceOperation") : class$oracle$adfmf$dc$ws$soap$SoapWebServiceOperation, "makeSoapGenericType", (String)object3, new Object[]{string4});
                }
                this.m_hoistedParams.add(string2);
                if (!bl3) continue;
                this.m_hoistedArrayParams.add(string2);
            }
        }
        n3 = genericType.getAttributeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            AttributeInfo attributeInfo2;
            Object object6;
            attributeInfo = genericType.getAttributeInfo(n2);
            string2 = attributeInfo.name;
            if (n4 > 0 && object4.contains(string2)) continue;
            int n5 = n2;
            n = n5 + 1;
            GenericType genericType2 = genericType;
            String string5 = NamespaceCache.createNamespaceCacheId(new String[]{string, string2});
            object3 = NamespaceCache.getInstance().getCacheEntryForId(string5);
            if (object3 != null && ((NamespaceCache.CacheEntry)object3).schemaFragment != null && "unbounded".equals(object2 = ((NamespaceCache.CacheEntry)object3).schemaFragment.getAttributeValue("maxOccurs")) && NamespaceCache.isSimpleType(((NamespaceCache.CacheEntry)object3).typeName) && (class$oracle$adfmf$util$GenericType == null ? SoapWebServiceOperation.class$("oracle.adfmf.util.GenericType") : class$oracle$adfmf$util$GenericType).isAssignableFrom((Class<?>)(object = (Class)attributeInfo.type)) && (object6 = (GenericType)genericType.getAttribute(n2)) != null && (attributeInfo2 = object6.getAttributeInfo(ITEM)) != null) {
                Object object7 = object6.getAttribute(ITEM);
                string5 = NamespaceCache.createNamespaceCacheId(new String[]{string, string2});
                string3 = NamespaceCache.getInstance().getElementNamespaceForId(string5);
                Class clazz = (Class)attributeInfo2.type;
                soapGenericType.defineAttribute(string3, string2, clazz, object7);
                continue;
            }
            if (this.m_hoistedParams.contains(attributeInfo.name) && (object2 = genericType.getAttribute(n2)) instanceof GenericType) {
                genericType2 = (GenericType)object2;
                n5 = 0;
                n = genericType2.getAttributeCount();
            }
            while (n5 < n) {
                block17: {
                    block16: {
                        object2 = genericType2.getAttribute(n5);
                        if (!(object2 instanceof GenericType)) break block16;
                        object = (GenericType)object2;
                        if (object.isDeferred()) break block17;
                        string5 = NamespaceCache.createNamespaceCacheId(new String[]{string, object.getName()});
                        object2 = this.makeSoapGenericType((GenericType)object2, string5, false);
                    }
                    object = genericType2.getAttributeInfo(n5);
                    string2 = ((AttributeInfo)((Object)object)).name;
                    string5 = NamespaceCache.createNamespaceCacheId(new String[]{string, string2});
                    string3 = NamespaceCache.getInstance().getElementNamespaceForId(string5);
                    object6 = object2 == null ? (Class)((AttributeInfo)((Object)object)).type : object2.getClass();
                    soapGenericType.defineAttribute(string3, string2, (Class)object6, object2);
                }
                ++n5;
            }
        }
        return soapGenericType;
    }

    private SchemaAny[] getNonHeaderInputs() {
        if (this.m_inputParametersWsdlFragment == null) {
            return null;
        }
        List list = this.getHeaderAttrNames();
        ArrayList<SchemaAny> arrayList = new ArrayList<SchemaAny>();
        List list2 = SchemaAny.getSchemaChildren(this.m_inputParametersWsdlFragment, WSDL_NS_LIST, "part");
        int n = list2 == null ? 0 : list2.size();
        for (int i = 0; i < n; ++i) {
            SchemaAny schemaAny = (SchemaAny)list2.get(i);
            String[] stringArray = NamespaceCache.determineTypeQName(schemaAny);
            if (!NamespaceCache.isQNameEmpty(stringArray) && list.contains(stringArray[1])) continue;
            arrayList.add(schemaAny);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new SchemaAny[0]);
    }

    private String[] getQNameForInputRequest(SchemaAny[] schemaAnyArray) {
        String[] stringArray = new String[]{this.m_inputNamespace, this.getOperation()};
        if (SoapWebServiceOperation.getArrayLength(schemaAnyArray) == 0) {
            return stringArray;
        }
        String[] stringArray2 = NamespaceCache.determineTypeQName(schemaAnyArray[0]);
        if (NamespaceCache.isQNameEmpty(stringArray2)) {
            return stringArray;
        }
        return stringArray2;
    }

    private String[] getQNameForInputHeaderRequest(String string) {
        String[] stringArray = new String[]{this.m_inputNamespace, this.getOperation()};
        int n = SoapWebServiceOperation.getArrayLength(this.m_inputHeaderWsdlFragments);
        if (n == 0) {
            return stringArray;
        }
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = NamespaceCache.determineTypeQName(this.m_inputHeaderWsdlFragments[i]);
            if (NamespaceCache.isQNameEmpty(stringArray2) || !stringArray2[1].equals(string)) continue;
            return stringArray2;
        }
        return stringArray;
    }

    private List getHeaderAttrNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = SoapWebServiceOperation.getArrayLength(this.m_inputHeaderWsdlFragments);
        for (int i = 0; i < n; ++i) {
            String[] stringArray = NamespaceCache.determineTypeQName(this.m_inputHeaderWsdlFragments[i]);
            if (NamespaceCache.isQNameEmpty(stringArray)) continue;
            arrayList.add(stringArray[1]);
        }
        return arrayList;
    }

    public SoapGenericType getInputAsSoapGenericType() {
        SchemaAny[] schemaAnyArray = this.getNonHeaderInputs();
        String[] stringArray = this.getQNameForInputRequest(schemaAnyArray);
        if (this.m_inputParametersWsdlFragment != null && SoapWebServiceOperation.getArrayLength(schemaAnyArray) == 0) {
            return null;
        }
        if (this.input == null) {
            return new SoapGenericType(stringArray[0], stringArray[1]);
        }
        return this.makeSoapGenericType(this.input, NamespaceCache.createNamespaceCacheId(new String[]{stringArray[0], stringArray[1]}), true);
    }

    private SoapHeader createSoapHeader(String string, GenericType genericType) {
        SoapHeader soapHeader = new SoapHeader(string, genericType.getName());
        int n = genericType.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = genericType.getAttributeInfo(i);
            Object object = genericType.getAttribute(i);
            if (object == null || object instanceof String) {
                soapHeader.addChild(new SoapHeader(null, attributeInfo.name, (String)object));
                continue;
            }
            if (!(object instanceof GenericType)) continue;
            soapHeader.addChild(this.createSoapHeader(null, (GenericType)object));
        }
        return soapHeader;
    }

    private SoapHeader[] getInputHeaders(Map map) {
        List list = this.getHeaderAttrNames();
        ArrayList<SoapHeader> arrayList = new ArrayList<SoapHeader>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            Object v = map.get(string);
            if (!(v instanceof GenericType)) continue;
            String[] stringArray = this.getQNameForInputHeaderRequest(string);
            arrayList.add(this.createSoapHeader(stringArray[0], (GenericType)v));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new SoapHeader[0]);
    }

    private Map[] stripHeader(Map map) {
        List list = this.getHeaderAttrNames();
        if (map == null || list.isEmpty()) {
            return new Map[]{map, null};
        }
        Map[] mapArray = new Map[]{new HashMap(), new HashMap()};
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            int n = list.contains(string) ? 1 : 0;
            mapArray[n].put(string, v);
        }
        return mapArray;
    }

    public Object invoke(String string, Map map) throws Exception {
        SoapGenericType soapGenericType = this.getInputAsSoapGenericType();
        Map[] mapArray = this.stripHeader(map);
        Map map2 = mapArray[0];
        SoapHeader[] soapHeaderArray = this.getInputHeaders(mapArray[1]);
        map2 = SoapBareUtil.handleBareInput(this.m_hoistedParams, this.m_hoistedArrayParams, map2);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = NamespaceCache.createNamespaceCacheId(new String[]{soapGenericType.getNamespace(), soapGenericType.getName(), string2});
            Object object = map2.get(string2);
            if (object instanceof GenericType) {
                GenericType genericType = (GenericType)object;
                if (genericType.isDeferred()) continue;
                this.defineAttributeIfNeeded(soapGenericType, string2, object, genericType == null ? (class$oracle$adfmf$util$GenericType == null ? SoapWebServiceOperation.class$("oracle.adfmf.util.GenericType") : class$oracle$adfmf$util$GenericType) : genericType.getClass());
                object = this.makeSoapGenericType((GenericType)object, string3, false);
            } else {
                this.defineAttributeIfNeeded(soapGenericType, string2, object, object == null ? (class$java$lang$Object == null ? SoapWebServiceOperation.class$("java.lang.Object") : class$java$lang$Object) : object.getClass());
            }
            soapGenericType.setAttribute(string2, object);
        }
        if (soapGenericType != null) {
            this.recursivelyFixupParamValues(soapGenericType, NamespaceCache.createNamespaceCacheId(new String[]{soapGenericType.getNamespace(), soapGenericType.getName()}));
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, SoapWebServiceOperation.class, "invoke", "Invoking {0} with {1} parameters", new Object[]{string, new Integer(map2.size())});
        }
        return this.invoke(string, soapGenericType, soapHeaderArray);
    }

    private void recursivelyFixupParamValues(SoapGenericType soapGenericType, String string) {
        if (soapGenericType == null) {
            return;
        }
        if (Utility.isEmpty(string)) {
            string = NamespaceCache.createNamespaceCacheId(new String[]{soapGenericType.getNamespace(), soapGenericType.getName()});
        }
        int n = soapGenericType.getAttributeInfoCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            AttributeInfo attributeInfo = soapGenericType.getAttributeInfo(i);
            Object object = soapGenericType.getAttribute(i);
            String string2 = NamespaceCache.createNamespaceCacheId(new String[]{string, attributeInfo.name});
            attributeInfo.namespace = NamespaceCache.getInstance().getElementNamespaceForId(string2);
            if (object instanceof SoapGenericType) {
                SoapGenericType soapGenericType2 = (SoapGenericType)object;
                this.recursivelyFixupParamValues(soapGenericType2, string2);
            }
            if ((n2 = NamespaceCache.getInstance().getMinOccurs(string2)) == 0 && (object == null || object instanceof String && Utility.isEmpty((String)object) || object instanceof SoapGenericType && this.isSoapGenericTypeCompletelyNull((SoapGenericType)object))) {
                attributeInfo.flags |= 1;
                continue;
            }
            attributeInfo.flags &= 0xFFFFFFFE;
        }
    }

    private boolean isSoapGenericTypeCompletelyNull(SoapGenericType soapGenericType) {
        boolean bl = true;
        if (null != soapGenericType) {
            int n = soapGenericType.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                Object object = soapGenericType.getAttribute(i);
                if (object instanceof SoapGenericType) {
                    bl = this.isSoapGenericTypeCompletelyNull((SoapGenericType)object);
                } else if (object instanceof String) {
                    if (!Utility.isEmpty((String)object)) {
                        bl = false;
                    }
                } else if (null != object) {
                    bl = false;
                }
                if (!bl) break;
            }
        }
        return bl;
    }

    private void defineAttributeIfNeeded(SoapGenericType soapGenericType, String string, Object object, Class clazz) {
        AttributeInfo attributeInfo = soapGenericType.getAttributeInfo(string);
        if (attributeInfo == null) {
            String string2 = NamespaceCache.createNamespaceCacheId(new String[]{soapGenericType.getNamespace(), soapGenericType.getName(), string});
            String string3 = NamespaceCache.getInstance().getElementNamespaceForId(string2);
            soapGenericType.defineAttribute(string3, string, clazz);
        }
    }

    protected static AccessorAttributeDefinition getAccessorAttributeDefinition(JavaBeanDefinition javaBeanDefinition, String string) {
        AccessorAttributeDefinition accessorAttributeDefinition = javaBeanDefinition.getAccessorAttributeDefinition(string);
        if (accessorAttributeDefinition == null) {
            accessorAttributeDefinition = javaBeanDefinition.getAccessorAttributeDefinitionBySourceName(string);
        }
        return accessorAttributeDefinition;
    }

    protected static Class getItemArrayReturnType(String string) {
        JavaBeanDefinition javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(string);
        if (javaBeanDefinition == null) {
            return null;
        }
        return SoapWebServiceOperation.getItemArrayReturnType(string, null);
    }

    protected static Class getItemArrayReturnType(String string, String string2) {
        JavaBeanDefinition javaBeanDefinition;
        Object object;
        XmlAnyDefinition xmlAnyDefinition;
        JavaBeanDefinition javaBeanDefinition2 = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(string);
        if (javaBeanDefinition2 == null) {
            return null;
        }
        if (string2 != null && string2.equals(ITEM)) {
            string2 = null;
        }
        if (string2 != null) {
            xmlAnyDefinition = javaBeanDefinition2.getAccessorAttributeDefinition(string2);
            if (xmlAnyDefinition == null) {
                return null;
            }
            javaBeanDefinition2 = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(((AccessorAttributeDefinition)xmlAnyDefinition).getBeanClass());
            if (javaBeanDefinition2 == null) {
                return null;
            }
        }
        if ((xmlAnyDefinition = javaBeanDefinition2.getAttributeDefinition(ITEM)) == null && string2 == null) {
            object = SoapWebServiceOperation.getAccessorAttributeDefinition(javaBeanDefinition2, ITEM);
            if (object == null || !((AccessorAttributeDefinition)object).isCollection()) {
                return null;
            }
            javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(((AccessorAttributeDefinition)object).getBeanClass());
            if (javaBeanDefinition == null) {
                return null;
            }
            xmlAnyDefinition = javaBeanDefinition.getAttributeDefinition(ITEM);
        }
        if (xmlAnyDefinition == null) {
            return null;
        }
        object = javaBeanDefinition2.getId();
        javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(javaBeanDefinition2.getPackage());
        if (javaBeanDefinition == null) {
            return null;
        }
        AccessorAttributeDefinition accessorAttributeDefinition = SoapWebServiceOperation.getAccessorAttributeDefinition(javaBeanDefinition, (String)object);
        if (accessorAttributeDefinition == null) {
            return null;
        }
        if (!accessorAttributeDefinition.isCollection()) {
            return null;
        }
        try {
            return Class.forName(((AttributeDefinition)xmlAnyDefinition).getType());
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, SoapWebServiceOperation.class, "getItemArrayReturnType", (Throwable)exception);
            }
            return null;
        }
    }

    public Object invoke(String string, SoapGenericType soapGenericType) throws Exception {
        return this.invoke(string, soapGenericType, null);
    }

    private Object invoke(String string, SoapGenericType soapGenericType, SoapHeader[] soapHeaderArray) throws Exception {
        SoapHeader[] soapHeaderArray2;
        SoapSerializationEnvelope soapSerializationEnvelope = null;
        Object object = null;
        SOAPProvider sOAPProvider = this.m_defDef.getSoapProvider();
        if (Utility.FrameworkLogger.isLoggable(Level.FINE)) {
            Trace.log(Utility.FrameworkLogger, Level.FINE, SoapWebServiceOperation.class, "invoke", "Invoking {0} with a SOAP {1} generic type parameter.", new Object[]{string, new Integer(this.version)});
        }
        soapSerializationEnvelope = new SoapSerializationEnvelope(this.version, this.m_isInputDocLitBare && this.m_hoistedParams.isEmpty());
        SoapHeader[] soapHeaderArray3 = soapHeaderArray2 = sOAPProvider != null ? sOAPProvider.getAdditionalSoapHeaders() : null;
        if (SoapWebServiceOperation.getArrayLength(soapHeaderArray) > 0) {
            int n = SoapWebServiceOperation.getArrayLength(soapHeaderArray2);
            if (n == 0) {
                soapHeaderArray2 = soapHeaderArray;
            } else {
                ArrayList<SoapHeader> arrayList = new ArrayList<SoapHeader>();
                arrayList.addAll(Arrays.asList(soapHeaderArray));
                arrayList.addAll(Arrays.asList(soapHeaderArray2));
                soapHeaderArray2 = arrayList.toArray(new SoapHeader[0]);
            }
        }
        soapSerializationEnvelope.headerOut = SoapHeaderConverter.convert(soapHeaderArray2);
        soapSerializationEnvelope.dotNet = this.m_elementQualified;
        soapSerializationEnvelope.bodyOut = soapGenericType;
        if (soapGenericType != null) {
            soapGenericType.register(soapSerializationEnvelope);
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            Trace.log(Utility.FrameworkLogger, Level.FINER, SoapWebServiceOperation.class, "invoke", "Invoke SOAP request for operation: {0}", new Object[]{this.operation});
        }
        object = this.invokeSoapRequest((SoapEnvelope)soapSerializationEnvelope);
        this.handleResponse(object);
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            Trace.log(Utility.FrameworkLogger, Level.FINER, SoapWebServiceOperation.class, "invoke", "Operation: {0} is returning: {1}", new Object[]{string, this.result});
        }
        return this.result;
    }

    private void handleResponse(Object object) throws Exception {
        if (object == null && this.returnNodeName != null) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, SoapWebServiceOperation.class, "invoke", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11017", new Object[]{this.operation, this.returnNodeName});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11017", new Object[]{this.operation, this.returnNodeName});
        }
        if (this.isReturnPrmitive()) {
            if (object instanceof SoapPrimitive) {
                this.result = EmbeddedUtility.convert(object.toString(), Class.forName(this.getReturnType()));
            } else if (object instanceof SoapObject) {
                SoapObject soapObject = (SoapObject)object;
                int n = soapObject.getPropertyCount();
                if (n > 0) {
                    String string = soapObject.getProperty(0).toString();
                    this.result = EmbeddedUtility.convert(string, Class.forName(this.getReturnType()));
                } else {
                    this.result = null;
                }
            } else {
                this.result = null;
            }
        } else {
            SoapObject soapObject = (SoapObject)object;
            JavaBeanDefinition javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(this.returnType);
            soapObject = SoapBareUtil.handleBareOutput(javaBeanDefinition, soapObject);
            this.result = new GenericVirtualType(soapObject.getNamespace(), soapObject.getName());
            Class<Object> clazz = null;
            boolean bl = false;
            int n = soapObject.getPropertyCount();
            PropertyInfo propertyInfo = new PropertyInfo();
            for (int i = 0; i < n; ++i) {
                SoapObject soapObject2;
                SoapGenericType soapGenericType = null;
                Object object2 = soapObject.getProperty(i);
                if (object2 instanceof SoapObject) {
                    soapObject2 = (SoapObject)object2;
                    soapGenericType = new SoapGenericType(soapObject2.getNamespace(), soapObject.getName(), soapObject2, this.returnType);
                    ((GenericVirtualType)this.result).defineAttribute(soapGenericType.getNamespace(), this.returnNodeName, soapGenericType.getClass(), soapGenericType);
                    continue;
                }
                if (!bl) {
                    bl = true;
                    clazz = this.returnNodeName.equalsIgnoreCase(propertyInfo.name) ? SoapWebServiceOperation.getItemArrayReturnType(this.getReturnType()) : SoapWebServiceOperation.getItemArrayReturnType(this.getReturnType(), propertyInfo.name);
                }
                if (object2 instanceof SoapPrimitive) {
                    soapObject2 = (SoapPrimitive)object2;
                    if (clazz != null) {
                        soapGenericType = new SoapGenericType(soapObject2.getNamespace(), soapObject2.getName());
                        Object object3 = EmbeddedUtility.convert(soapObject2.toString(), clazz);
                        soapGenericType.defineAttribute(soapGenericType.getNamespace(), ITEM, object3 == null ? clazz : object3.getClass(), object3);
                    } else {
                        soapGenericType = new SoapGenericType(soapObject2.getNamespace(), soapObject2.getName());
                        soapGenericType.defineAttribute(soapGenericType.getNamespace(), ITEM, object2.getClass(), soapObject2);
                    }
                    ((GenericVirtualType)this.result).defineAttribute(soapObject2.getNamespace(), this.returnNodeName, soapGenericType.getClass(), soapGenericType);
                    continue;
                }
                if (clazz != null) {
                    soapGenericType = new SoapGenericType("", this.returnNodeName);
                    soapGenericType.defineAttribute("", ITEM, clazz, object2);
                    ((GenericVirtualType)this.result).defineAttribute(soapGenericType.getNamespace(), this.returnNodeName, soapGenericType.getClass(), soapGenericType);
                    continue;
                }
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11058", new Object[]{this.operation});
            }
        }
    }

    private static String parseWsdlUrl(XmlAnyDefinition xmlAnyDefinition, XmlAnyDefinition xmlAnyDefinition2) {
        String string = null;
        if (xmlAnyDefinition != null) {
            string = (String)xmlAnyDefinition.getAttributeValue("wsdl");
        }
        String string2 = null;
        if (xmlAnyDefinition2 != null) {
            string2 = (String)xmlAnyDefinition2.getAttributeValue("description");
        }
        if (Utility.isEmpty(string)) {
            return string2;
        }
        if (Utility.isUrlRemote(string)) {
            return Utility.isEmpty(string2) ? string : string2;
        }
        return string;
    }

    private void loadConnectionInformation(String string, String string2, String string3, String string4) {
        Object object;
        Object object2;
        XmlAnyDefinition xmlAnyDefinition = this.getConnectionRefAndSetSecurity(string);
        if (xmlAnyDefinition == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("RefAddresses");
        if (xmlAnyDefinition2 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition3 = xmlAnyDefinition2.getChildDefinition("XmlRefAddr", "addrType", WEBSERVICE_CONNECTION);
        if (xmlAnyDefinition3 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition4 = xmlAnyDefinition3.getChildDefinition("Contents");
        if (xmlAnyDefinition4 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition5 = xmlAnyDefinition4.getChildDefinition(WSCONNECTION);
        if (xmlAnyDefinition5 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition6 = xmlAnyDefinition5.getChildDefinition(MODEL);
        if (xmlAnyDefinition6 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition7 = xmlAnyDefinition6.getChildDefinition(SERVICE);
        if (xmlAnyDefinition7 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition8 = xmlAnyDefinition7.getChildDefinition(PORT, NAME, string3);
        if (xmlAnyDefinition8 == null) {
            return;
        }
        XmlAnyDefinition xmlAnyDefinition9 = xmlAnyDefinition8.getChildDefinition(SOAP);
        if (xmlAnyDefinition9 == null) {
            return;
        }
        String string5 = (String)xmlAnyDefinition9.getAttributeValue("addressUrl");
        if (Utility.isEmpty(string5)) {
            return;
        }
        this.setEndPoint(string5);
        String string6 = SoapWebServiceOperation.parseWsdlUrl(this.m_defDef, xmlAnyDefinition5);
        if (Utility.isEmpty(string6)) {
            return;
        }
        try {
            this.m_wsdlAny = SchemaAnyCache.getInstance().fetch(string6, "definitions");
        }
        catch (AdfException adfException) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11101", new Object[]{string6});
        }
        if (this.m_wsdlAny == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11101", new Object[]{string6});
        }
        String string7 = (String)xmlAnyDefinition8.getAttributeValue("portType");
        if (!Utility.isEmpty(string7) && (object2 = PARSE_PATTERN_1.matcher((CharSequence)string7)).matches()) {
            string7 = object2.group(2);
        }
        object2 = SoapWebServiceOperation.getServiceBinding(this.m_wsdlAny, string2);
        List list = SoapWebServiceOperation.getInputTypeNames(this.m_wsdlAny, (SchemaAny)object2, string4, "header", "part");
        this.m_inputParametersWsdlFragment = SoapWebServiceOperation.getParameterOrResponseWsdlFragment(this.m_wsdlAny, (SchemaAny)object2, string4, INPUT);
        this.m_inputHeaderWsdlFragments = SoapWebServiceOperation.getInputPartWsdlFragments(this.m_inputParametersWsdlFragment, list);
        NamespaceCache.getInstance().processWsdlFragment(this.m_inputParametersWsdlFragment);
        this.m_outputResponseWsdlFragment = SoapWebServiceOperation.getParameterOrResponseWsdlFragment(this.m_wsdlAny, (SchemaAny)object2, string4, OUTPUT);
        NamespaceCache.getInstance().processWsdlFragment(this.m_outputResponseWsdlFragment);
        SchemaAny schemaAny = SchemaAny.getSchemaChild(this.m_wsdlAny, WSDL_NS_LIST, SERVICE, NAME, string2);
        if (schemaAny == null) {
            return;
        }
        SchemaAny schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, PORT, NAME, string3);
        if (schemaAny2 == null) {
            return;
        }
        String string8 = (String)xmlAnyDefinition8.getAttributeValue("binding");
        if (Utility.isEmpty(string8)) {
            return;
        }
        SchemaAny schemaAny3 = SchemaAny.getSchemaQualifiedChild(this.m_wsdlAny, WSDL_NS_LIST, "binding", NAME, string8);
        if (schemaAny3 == null) {
            return;
        }
        SchemaAny schemaAny4 = SchemaAny.getSchemaChild(schemaAny3, SOAP_NS_LIST, "binding");
        if (schemaAny4 == null) {
            return;
        }
        String string9 = (String)schemaAny4.getAttributeValue("style");
        this.m_isDocument = this.stringIsEmptyOrEqualTo(string9, "document");
        SchemaAny schemaAny5 = SchemaAny.getSchemaChild(schemaAny3, WSDL_NS_LIST, "operation", NAME, string4);
        if (schemaAny5 == null) {
            return;
        }
        SchemaAny schemaAny6 = SchemaAny.getSchemaChild(schemaAny5, SOAP_NS_LIST, "operation");
        if (schemaAny6 != null) {
            string9 = (String)schemaAny4.getAttributeValue("style");
            if (string9 != null) {
                this.m_isDocument = this.stringIsEmptyOrEqualTo(string9, "document");
            }
            if (Utility.isNotEmpty((String)(object = (String)schemaAny6.getAttributeValue(SOAP_ACTION)))) {
                this.setSoapAction((String)object);
            }
        }
        object = SchemaAny.getSchemaChild(schemaAny5, WSDL_NS_LIST, INPUT);
        SchemaAny schemaAny7 = SchemaAny.getSchemaChild(schemaAny5, WSDL_NS_LIST, OUTPUT);
        String string10 = this.getParameterUse((SchemaAny)object);
        String string11 = this.getParameterUse(schemaAny7);
        this.m_inputIsLiteral = this.stringIsEmptyOrEqualTo(string10, "literal");
        this.m_outputIsLiteral = this.stringIsEmptyOrEqualTo(string11, "literal");
        this.m_isInputDocLitBare = this.isInputDocLitBare(string4);
        this.m_inputNamespace = this.m_inputIsLiteral ? SoapWebServiceOperation.getLiteralTargetNamespace(this.m_wsdlAny, string2, string4, true) : SoapWebServiceOperation.getNonLiteralTargetNamespace((SchemaAny)object);
        this.m_outputNamespace = this.m_outputIsLiteral ? SoapWebServiceOperation.getLiteralTargetNamespace(this.m_wsdlAny, string2, string4, false) : SoapWebServiceOperation.getNonLiteralTargetNamespace(schemaAny7);
        this.version = this.parseSoapVersion(schemaAny6);
        this.setElementQualified(this.parseElementQualified(this.m_wsdlAny));
        this.setService(string8);
        this.setPort(string3);
        try {
            this.loadSecurityInformation(xmlAnyDefinition8, xmlAnyDefinition9, string3, string4);
        }
        catch (NullPointerException nullPointerException) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, SoapWebServiceOperation.class, "loadConnectionInformation", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11102", new Object[]{string});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11069", null);
        }
    }

    private static SchemaAny getServiceBinding(SchemaAny schemaAny, String string) {
        SchemaAny schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, SERVICE, NAME, string);
        if (schemaAny2 == null) {
            return null;
        }
        if ((schemaAny2 = SchemaAny.getSchemaChild(schemaAny2, WSDL_NS_LIST, PORT)) == null) {
            return null;
        }
        String string2 = (String)schemaAny2.getAttributeValue("binding");
        if (Utility.isEmpty(string2)) {
            return null;
        }
        String[] stringArray = SchemaAny.breakupName(string2);
        schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "binding", NAME, string2 = stringArray[1]);
        if (schemaAny2 == null) {
            return null;
        }
        return schemaAny2;
    }

    private static List getInputTypeNames(SchemaAny schemaAny, SchemaAny schemaAny2, String string, String string2, String string3) {
        int n;
        if (schemaAny2 == null) {
            return null;
        }
        SchemaAny schemaAny3 = SchemaAny.getSchemaChild(schemaAny2, WSDL_NS_LIST, "operation", NAME, string);
        if (schemaAny3 == null) {
            return null;
        }
        if ((schemaAny3 = SchemaAny.getSchemaChild(schemaAny3, WSDL_NS_LIST, INPUT)) == null) {
            return null;
        }
        List list = SchemaAny.getSchemaChildren(schemaAny3, SOAP_NS_LIST, string2);
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            schemaAny3 = (SchemaAny)list.get(i);
            arrayList.add((String)schemaAny3.getAttributeValue(string3));
        }
        return arrayList;
    }

    private static SchemaAny[] getInputPartWsdlFragments(SchemaAny schemaAny, List list) {
        if (schemaAny == null || list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<SchemaAny> arrayList = new ArrayList<SchemaAny>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SchemaAny schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "part", NAME, string);
            if (schemaAny2 == null) continue;
            arrayList.add(schemaAny2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new SchemaAny[0]);
    }

    private static SchemaAny getParameterOrResponseWsdlFragment(SchemaAny schemaAny, SchemaAny schemaAny2, String string, String string2) {
        if (schemaAny2 == null) {
            return null;
        }
        String string3 = (String)schemaAny2.getAttributeValue("type");
        if (Utility.isEmpty(string3)) {
            return null;
        }
        String[] stringArray = SchemaAny.breakupName(string3);
        if (Utility.isEmpty(string3 = stringArray[1])) {
            return null;
        }
        SchemaAny schemaAny3 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "portType", NAME, string3);
        if (schemaAny3 == null) {
            return null;
        }
        if ((schemaAny3 = SchemaAny.getSchemaChild(schemaAny3, WSDL_NS_LIST, "operation", NAME, string)) == null) {
            return null;
        }
        if ((schemaAny3 = SchemaAny.getSchemaChild(schemaAny3, WSDL_NS_LIST, string2)) == null) {
            return null;
        }
        String string4 = (String)schemaAny3.getAttributeValue("message");
        if (string4 == null) {
            return null;
        }
        String[] stringArray2 = SchemaAny.breakupName(string4);
        String string5 = stringArray2[1];
        if (stringArray2[0] != null) {
            String string6 = schemaAny.getNamespace(stringArray2[0]);
            String string7 = schemaAny.getTargetNamespace();
            if (string7 != null && !string7.equals(string6)) {
                string5 = stringArray2[0] + ":" + stringArray2[1];
            }
        }
        schemaAny3 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "message", NAME, string5);
        return schemaAny3;
    }

    private static boolean isParameterDocLitBare(SchemaAny schemaAny, SchemaAny schemaAny2, String string, String string2) {
        if (schemaAny2 == null) {
            return false;
        }
        XmlAnyDefinition xmlAnyDefinition = schemaAny2.getChildDefinition("part");
        if (xmlAnyDefinition == null || schemaAny2.getChildren().size() != 1) {
            return true;
        }
        String string3 = (String)xmlAnyDefinition.getAttributeValue("element");
        String[] stringArray = SchemaAny.breakupName(string3);
        if (Utility.isEmpty(string3) || !stringArray[1].equals(string)) {
            return true;
        }
        String string4 = stringArray[0] == null ? string2 : schemaAny.getNamespace(stringArray[0]);
        String string5 = NamespaceCache.createNamespaceCacheId(new String[]{string4, stringArray[1]});
        return !NamespaceCache.getInstance().isComplexType(string5);
    }

    private boolean isInputDocLitBare(String string) {
        if (!this.m_isDocument || !this.m_inputIsLiteral) {
            return false;
        }
        return SoapWebServiceOperation.isParameterDocLitBare(this.m_wsdlAny, this.m_inputParametersWsdlFragment, string, this.m_inputNamespace);
    }

    private static String getLiteralTargetNamespace(SchemaAny schemaAny, String string, String string2, boolean bl) {
        String string3;
        SchemaAny schemaAny2;
        String string4 = schemaAny.getTargetNamespace();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('_').append(string2);
        if (!bl) {
            stringBuffer.append("Response");
        }
        if ((schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "message", NAME, string3 = stringBuffer.toString())) == null) {
            return string4;
        }
        SchemaAny schemaAny3 = SchemaAny.getSchemaChild(schemaAny2, WSDL_NS_LIST, "part", NAME, "parameters");
        if (schemaAny3 == null) {
            return string4;
        }
        String string5 = (String)schemaAny3.getAttributeValue("element");
        if (string5 == null) {
            return string4;
        }
        String[] stringArray = SchemaAny.breakupName(string5);
        String string6 = stringArray[0];
        String string7 = string6 == null ? string4 : schemaAny.getNamespace(string6);
        return string7;
    }

    private static String getNonLiteralTargetNamespace(SchemaAny schemaAny) {
        return (String)schemaAny.getAttributeValue("namespace");
    }

    private int parseSoapVersion(SchemaAny schemaAny) {
        int n = 110;
        String string = schemaAny.getCurrentNamespace();
        if (Utility.isNotEmpty(string) && string.equalsIgnoreCase(SOAP12_NS)) {
            n = 120;
        }
        return n;
    }

    private boolean parseElementQualified(SchemaAny schemaAny) {
        boolean bl = false;
        SchemaAny schemaAny2 = SchemaAny.getSchemaChild(schemaAny, WSDL_NS_LIST, "types");
        if (schemaAny2 == null) {
            return bl;
        }
        SchemaAny schemaAny3 = SchemaAny.getSchemaChild(schemaAny2, SCHEMA_NS_LIST, "schema");
        if (schemaAny3 == null) {
            return bl;
        }
        String string = (String)schemaAny3.getAttributeValue("elementFormDefault");
        if (Utility.isEmpty(string)) {
            return bl;
        }
        bl = "qualified".equalsIgnoreCase(string);
        return bl;
    }

    private boolean stringIsEmptyOrEqualTo(String string, String string2) {
        return Utility.isEmpty(string) || string.equalsIgnoreCase(string2);
    }

    private String getParameterUse(SchemaAny schemaAny) {
        if (schemaAny == null) {
            return null;
        }
        SchemaAny schemaAny2 = SchemaAny.getSchemaChild(schemaAny, SOAP_NS_LIST, "body");
        if (schemaAny2 == null) {
            return null;
        }
        return (String)schemaAny2.getAttributeValue("use");
    }

    private void loadSecurityInformation(XmlAnyDefinition xmlAnyDefinition, XmlAnyDefinition xmlAnyDefinition2, String string, String string2) {
        XmlAnyDefinition xmlAnyDefinition3;
        this.m_usernameToken = null;
        this.m_passwordToken = null;
        if (this.isSecureConnection()) {
            this.m_usernameToken = (String)xmlAnyDefinition2.getAttributeValue(USERNAME);
            this.m_passwordToken = (String)xmlAnyDefinition2.getAttributeValue(PASSWORD);
        }
        this.setPolicyUri(null);
        XmlAnyDefinition xmlAnyDefinition4 = xmlAnyDefinition.getChildDefinition(POLICY_REFERENCES);
        if (xmlAnyDefinition4 != null && (xmlAnyDefinition3 = xmlAnyDefinition4.getChildDefinition(POLICY_REFERENCE)) != null) {
            this.setPolicyUri((String)xmlAnyDefinition3.getAttributeValue(URI));
        }
    }

    private static int getArrayLength(SoapHeader[] soapHeaderArray) {
        if (soapHeaderArray == null) {
            return 0;
        }
        return soapHeaderArray.length;
    }

    private static int getArrayLength(SchemaAny[] schemaAnyArray) {
        if (schemaAnyArray == null) {
            return 0;
        }
        return schemaAnyArray.length;
    }

    static {
        PARSE_PATTERN_1 = Pattern.compile((String)"\\{(.*)\\}(.*)");
        WSDL_NS_LIST = new ArrayList();
        WSDL_NS_LIST.add(WSDL_NS.toLowerCase());
        WSDL_NS_LIST.add(WSDL11_NS.toLowerCase());
        SOAP_NS_LIST = new ArrayList();
        SOAP_NS_LIST.add("http://schemas.xmlsoap.org/wsdl/soap/".toLowerCase());
        SOAP_NS_LIST.add(SOAP12_NS.toLowerCase());
        SCHEMA_NS_LIST = new ArrayList();
        SCHEMA_NS_LIST.add(SCHEMA_NS.toLowerCase());
    }
}

