/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.ws.rest;

import com.sun.util.logging.Level;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adfmf.dc.VirtualJavaBeanObject;
import oracle.adfmf.dc.ws.rest.RestGenericType;
import oracle.adfmf.dc.ws.rest.RestTransportLayer;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationRuntimeException;
import oracle.adfmf.metadata.bean.JavaBeanDefinition;
import oracle.adfmf.metadata.bean.MethodAccessorDefinition;
import oracle.adfmf.metadata.bean.cache.SchemaAny;
import oracle.adfmf.metadata.cache.MetaDataFrameworkManager;
import oracle.adfmf.metadata.dcx.HttpHeadersDefinition;
import oracle.adfmf.metadata.dcx.rest.RestDefinitionDefinition;
import oracle.adfmf.metadata.dcx.rest.RestParametersDefinition;
import oracle.adfmf.util.GenericVirtualType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class RestWebServiceOperation
extends RestTransportLayer {
    private static final String ROOT_ELEMENT = "RootElement";
    private static final String URL_CONNECTION_TYPE = "URLConnection";
    private static final String URLCONNECTION = "urlconnection";
    private static final String URL = "url";
    private static final String PUT = "PUT";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String SLASH = "/";
    private static final char CH_SLASH = '/';
    private static final String AMPERSAND = "&";
    private static final String EQUAL = "=";
    private static final String DOUBLE_HASH = "##";
    private String m_source = "";
    private String m_httpMethod = "";
    private HttpHeadersDefinition m_httpHeaders = null;

    public RestWebServiceOperation(RestDefinitionDefinition restDefinitionDefinition, String string) {
        super("", restDefinitionDefinition.getName(), string);
        HttpHeadersDefinition httpHeadersDefinition;
        this.loadConnectionInformation();
        this.setSource(restDefinitionDefinition.getSource());
        this.setHttpMethod(restDefinitionDefinition.getHttpMethod());
        RestParametersDefinition restParametersDefinition = restDefinitionDefinition.getParametersDef();
        if (null != restParametersDefinition) {
            this.setParameters(restParametersDefinition.getParameters());
        }
        if ((httpHeadersDefinition = restDefinitionDefinition.getHttpHeadersDef()) != null) {
            this.setHttpHeadersDef(httpHeadersDefinition);
        }
    }

    private Object getHttpHeadersValue(Map map) {
        Object var2_2 = null;
        HttpHeadersDefinition httpHeadersDefinition = this.getHttpHeadersDef();
        if (httpHeadersDefinition == null) {
            return var2_2;
        }
        String string = httpHeadersDefinition.getParamName();
        if (Utility.isEmpty(string)) {
            return var2_2;
        }
        Object v = map.remove(string);
        return v;
    }

    protected void setHttpHeadersDef(HttpHeadersDefinition httpHeadersDefinition) {
        this.m_httpHeaders = httpHeadersDefinition;
    }

    protected HttpHeadersDefinition getHttpHeadersDef() {
        return this.m_httpHeaders;
    }

    protected void setSource(String string) {
        this.m_source = string;
    }

    protected String getSource() {
        return this.m_source;
    }

    protected void setHttpMethod(String string) {
        this.m_httpMethod = !Utility.isEmpty(string) ? string : GET;
    }

    protected String getHttpMethod() {
        return this.m_httpMethod;
    }

    protected boolean isHttpMethodSupported() {
        return this.m_httpMethod.equalsIgnoreCase(PUT) || this.m_httpMethod.equalsIgnoreCase(GET) || this.m_httpMethod.equalsIgnoreCase(POST) || this.m_httpMethod.equalsIgnoreCase(DELETE);
    }

    private static String substituteParamValue(String string, Map map) {
        String string2 = string;
        if (null != map && null != string) {
            int n = -1;
            int n2 = -1;
            while (-1 != (n = string2.indexOf(DOUBLE_HASH, 0)) && -1 != (n2 = string2.indexOf(DOUBLE_HASH, n + 1))) {
                String string3 = string2.substring(n + 2, n2);
                StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n));
                String string4 = (String)map.get(string3);
                if (null != string4) {
                    stringBuffer.append(string4);
                }
                stringBuffer.append(string2.substring(n2 + 2, string2.length()));
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    private void loadConnectionInformation() {
        String string = this.getName();
        XmlAnyDefinition xmlAnyDefinition = this.getConnectionRefAndSetSecurity(string);
        if (null != xmlAnyDefinition) {
            Object object;
            Iterator iterator = null;
            XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition("RefAddresses");
            if (xmlAnyDefinition2 != null) {
                object = xmlAnyDefinition2.getChildren();
                iterator = object.iterator();
            }
            while (iterator.hasNext()) {
                XmlAnyDefinition xmlAnyDefinition3;
                XmlAnyDefinition xmlAnyDefinition4;
                object = (XmlAnyDefinition)iterator.next();
                String string2 = (String)((XmlAnyDefinition)object).getAttributeValue("addrType");
                if (Utility.isEmpty(string2) || (xmlAnyDefinition4 = ((XmlAnyDefinition)object).getChildDefinition("Contents")) == null || (xmlAnyDefinition3 = xmlAnyDefinition4.getChildDefinition(URLCONNECTION)) == null) continue;
                this.setEndPoint((String)xmlAnyDefinition3.getAttributeValue(URL));
                return;
            }
        }
    }

    public Object invoke(String string, Map map) throws Exception {
        XmlAnyDefinition xmlAnyDefinition;
        boolean bl;
        Object object;
        Object object2;
        String string2 = null;
        if (!this.isHttpMethodSupported()) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, RestWebServiceOperation.class, "invoke", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11055", new Object[]{this.getHttpMethod()});
            }
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11055", new Object[]{this.getHttpMethod()});
        }
        Object object3 = this.getHttpHeadersValue(map);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = map.get(object2);
            this.setParameter((String)object2, object);
        }
        try {
            string2 = this.invokeHttpRequest(object3);
        }
        catch (Exception exception) {
            throw new AdfInvocationRuntimeException(exception, "ERROR", "WEBSERVICE", this.getStatus());
        }
        int n = this.getStatus();
        if (Utility.isEmpty(string2)) {
            if (n == 204 || n == 205 || n == 200) {
                return new GenericVirtualType();
            }
            object2 = new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11098", null);
            throw new AdfInvocationRuntimeException((Throwable)object2, "ERROR", "WEBSERVICE", n);
        }
        object2 = null;
        if (string2 != null) {
            object = new ByteArrayInputStream(Utility.stringToBytes(string2));
            object2 = XmlAnyDefinition.loadXmlFromStream("REST response", (InputStream)object, this.returnNodeName);
            object2 = new SchemaAny((XmlAnyDefinition)object2);
        }
        object = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(this.returnType);
        JavaBeanDefinition javaBeanDefinition = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(((JavaBeanDefinition)object).getPackage());
        MethodAccessorDefinition methodAccessorDefinition = javaBeanDefinition.getMethodAccessorDefinition(string);
        if (methodAccessorDefinition == null) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11056", new Object[]{string});
        }
        String string3 = methodAccessorDefinition.getBeanClass();
        JavaBeanDefinition javaBeanDefinition2 = MetaDataFrameworkManager.getInstance().getJavaBeanDefinitionByName(string3);
        List list = javaBeanDefinition2.getAttributeDefinitions();
        boolean bl2 = list != null && !list.isEmpty();
        List list2 = javaBeanDefinition2.getAccessorAttributeDefinitions();
        boolean bl3 = bl = list2 != null && !list2.isEmpty();
        if (bl) {
            xmlAnyDefinition = (XmlAnyDefinition)list2.get(0);
        } else if (bl2) {
            xmlAnyDefinition = (XmlAnyDefinition)list.get(0);
        } else {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11056", new Object[]{string3});
        }
        String string4 = RestGenericType.getTargetNamespace(xmlAnyDefinition);
        this.result = new GenericVirtualType(string4, this.returnNodeName);
        if (string2 != null) {
            RestGenericType restGenericType = new RestGenericType(string4, this.returnNodeName, (XmlAnyDefinition)object2, (JavaBeanDefinition)object);
            ((GenericVirtualType)this.result).defineAttribute(string4, this.returnNodeName, restGenericType.getClass(), restGenericType);
        }
        return this.result;
    }

    private String invokeHttpRequest(Object object) throws Exception {
        byte[] byArray = this.invokeHttpRequestRaw(object);
        return Utility.bytesToString(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] invokeHttpRequestRaw(Object object) throws Exception {
        String string = "";
        byte[] byArray = null;
        String string2 = "";
        String string3 = this.getHttpMethod();
        String string4 = this.getEndpoint();
        if (string4.endsWith(SLASH)) {
            string4 = string4.substring(0, string4.lastIndexOf(47));
        }
        String string5 = this.getSource();
        while (Utility.isNotEmpty(string5) && string5.charAt(0) == '/') {
            if (string5.length() > 1) {
                string5 = string5.substring(1);
                continue;
            }
            string5 = "";
        }
        string5 = RestWebServiceOperation.substituteParamValue(string5, this.getParameters());
        string = string4 + SLASH + string5;
        if (string3.equalsIgnoreCase(PUT) || string3.equalsIgnoreCase(POST)) {
            string2 = this.getXMLPayload(this.getParameters());
        }
        if (Utility.FrameworkLogger.isLoggable(Level.FINER)) {
            Trace.log(Utility.FrameworkLogger, Level.FINER, RestWebServiceOperation.class, "invokeHttpRequest", "Request: Mechanism: {0}; URL: {1}; Payload: {2}", new Object[]{string3, string, string2});
        }
        try {
            byArray = this.sendReceive(string3, string, string2, object, 0, null);
            Object var9_8 = null;
            string2 = null;
            string = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            string2 = null;
            string = null;
            throw throwable;
        }
        return byArray;
    }

    private String getXMLPayload(HashMap hashMap) {
        String string = "";
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object v;
            String string2 = (String)iterator.next();
            if (Utility.isEmpty(string2) || !((v = hashMap.get(string2)) instanceof VirtualJavaBeanObject)) continue;
            string = string + ((VirtualJavaBeanObject)v).toXML(string2);
        }
        return string;
    }
}

