/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.XmlAnyDefinition;

public class ValidatorFactory {
    private static HashMap m_registeredValidators = new HashMap();

    public static void registerValidator(String string, Class clazz) {
        m_registeredValidators.put(string, clazz);
    }

    public static Validator createValidator(XmlAnyDefinition xmlAnyDefinition) throws AdfException {
        String string = xmlAnyDefinition.getElementName();
        Class clazz = (Class)m_registeredValidators.get(string);
        try {
            Constructor constructor = clazz.getDeclaredConstructor(XmlAnyDefinition.class);
            Validator validator = (Validator)constructor.newInstance(xmlAnyDefinition);
            return validator;
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11041", new Object[]{string, exception.getLocalizedMessage()});
        }
    }
}

