/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.adfmf.dc.DefaultValues;
import oracle.adfmf.dc.rules.CompareValidator;
import oracle.adfmf.dc.rules.LengthValidator;
import oracle.adfmf.dc.rules.ListValidator;
import oracle.adfmf.dc.rules.RangeValidator;
import oracle.adfmf.dc.rules.ValidationContext;
import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.dc.rules.ValidatorFactory;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.BatchValidationException;
import oracle.adfmf.framework.exception.ValidationException;
import oracle.adfmf.util.XmlAnyDefinition;

public class ValidationManager {
    public static void validate(String string, String string2, Object object) throws BatchValidationException {
        ArrayList<ValidationException> arrayList = new ArrayList<ValidationException>();
        Map map = DefaultValues.getClassValidators(string);
        List list = DefaultValues.getAttributeValidators(map, string2);
        int n = list == null ? 0 : list.size();
        String string3 = AdfmfJavaUtilities.getAdfELContext().getCurrentELResolutionPath();
        String string4 = "WARNING";
        for (int i = 0; i < n; ++i) {
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)list.get(i);
            try {
                String string5;
                Validator validator = ValidatorFactory.createValidator(xmlAnyDefinition);
                boolean bl = validator.validateValue(object);
                if (bl != validator.getInverse()) continue;
                ValidationException validationException = validator.createException(object);
                if (string4 == "WARNING" && ((string5 = validationException.getSeverity()) == "ERROR" || string5 == "FATAL")) {
                    string4 = string5;
                }
                arrayList.add(validationException);
                continue;
            }
            catch (AdfException adfException) {
                throw adfException;
            }
            catch (Exception exception) {
                throw new AdfException(exception, "ERROR");
            }
        }
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1) {
                ValidationException validationException = (ValidationException)arrayList.get(0);
                throw validationException;
            }
            throw new BatchValidationException(string4, arrayList);
        }
        ValidationContext.getInstance().addToValidList("#{" + string3 + "}");
    }

    static {
        LengthValidator.registerValidator();
        RangeValidator.registerValidator();
        CompareValidator.registerValidator();
        ListValidator.registerValidator();
    }
}

