/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.rules;

import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import oracle.adfmf.dc.rules.Validator;
import oracle.adfmf.dc.rules.ValidatorFactory;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.util.EmbeddedUtility;
import oracle.adfmf.util.XmlAnyDefinition;

public class CompareValidator
extends Validator {
    public static final Class CLASS_INSTANCE = CompareValidator.class;
    protected static final String validatorID = "validation:CompareValidationBean";
    private static final String VALIDATION_PREFIX = "CompareValidator";
    public static final String PNAME_OperandType = "OperandType";
    public static final String PNAME_CompareType = "CompareType";
    public static final String PNAME_CompareValue = "CompareValue";
    public static final int EQUALTO = 0;
    public static final int LESSTHAN = 1;
    public static final int GREATERTHAN = 2;
    public static final int LESSTHANEQUALTO = 3;
    public static final int GREATERTHANEQUALTO = 4;
    public static final String[] operTypeVals = new String[]{"EQUALTO", "LESSTHAN", "GREATERTHAN", "LESSTHANEQUALTO", "GREATERTHANEQUALTO"};
    public static final int UNINIT = -1;
    private ValueExpression mExpr;
    protected int mOperationType = -1;
    protected Object mRValue;
    protected String mRhsAttrName;

    public static final void registerValidator() {
        ValidatorFactory.registerValidator(validatorID, CompareValidator.class);
    }

    public CompareValidator() {
        this.initUninitializedValidator();
    }

    protected CompareValidator(boolean bl, int n) {
        this.mbInverse = bl;
        this.setType(n);
    }

    public CompareValidator(boolean bl, int n, Object object) {
        this.setType(n);
        this.mRValue = object;
        this.mbInverse = bl;
    }

    public CompareValidator(XmlAnyDefinition xmlAnyDefinition) {
        this.initUninitializedValidator();
        this.initValidatorProperties(xmlAnyDefinition);
    }

    private void initUninitializedValidator() {
        this.mbInverse = false;
        this.setType(0);
    }

    public boolean validateValue(Object object) {
        return this.validateValue(object, this.getRhsValue());
    }

    public boolean validateValue(Object object, Object object2) {
        if (object == null || object.toString().length() == 0) {
            return !this.mbInverse;
        }
        if (object2 != null && object != null && object2.getClass() != object.getClass()) {
            try {
                object2 = EmbeddedUtility.coerce(object.getClass(), object2);
            }
            catch (Exception exception) {
                object = EmbeddedUtility.coerce(object2.getClass(), object);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("lValue", object);
        hashMap.put("rValue", object2);
        Object object3 = null;
        try {
            AdfELContext adfELContext = EmbeddedFeatureContext.getInstance().getAdfELContext();
            adfELContext.setVariable(VALIDATION_PREFIX, hashMap, HashMap.class);
            object3 = this.getExpr().getValue((ELContext)adfELContext);
            return (Boolean)EmbeddedUtility.coerce(Boolean.class, object3);
        }
        catch (ELException eLException) {
            return false;
        }
    }

    public void setType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mOperationType = n;
                break;
            }
        }
    }

    public int getType() {
        return this.mOperationType == -1 ? 0 : this.mOperationType;
    }

    private ValueExpression getExpr() {
        String string;
        if (this.mExpr != null) {
            return this.mExpr;
        }
        switch (this.getType()) {
            case 0: {
                string = "==";
                break;
            }
            case 1: {
                string = "<";
                break;
            }
            case 2: {
                string = ">";
                break;
            }
            case 3: {
                string = "<=";
                break;
            }
            case 4: {
                string = ">=";
                break;
            }
            default: {
                string = "=";
            }
        }
        String string2 = "#{CompareValidator.lValue " + string + " " + VALIDATION_PREFIX + ".rValue}";
        this.mExpr = this.getValueExpression(string2, Boolean.class);
        return this.mExpr;
    }

    public void setRhsValue(Object object) {
        this.mRValue = object;
    }

    public Object getRhsValue(Object object) {
        return this.mRValue;
    }

    public Object getRhsValue() {
        return this.getRhsValue(null);
    }

    public String toString() {
        return "Literal Compare( " + this.getOperatorTypeString() + this.mRValue.toString() + ")";
    }

    public static int convertOperType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < operTypeVals.length; ++i) {
            if (!operTypeVals[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getOperatorTypeString() {
        return operTypeVals[this.getType()];
    }

    public void initValidatorProperties(XmlAnyDefinition xmlAnyDefinition) {
        super.initValidatorProperties(xmlAnyDefinition);
        Object object = xmlAnyDefinition.getAttributeValue(PNAME_CompareValue);
        if (object != null) {
            this.setRhsValue(object);
        }
        if ((object = xmlAnyDefinition.getAttributeValue(PNAME_CompareType)) != null) {
            this.setType(CompareValidator.convertOperType((String)object));
        }
    }
}

