/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc.bean;

import com.sun.util.logging.Level;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import oracle.adfmf.dc.DefaultValues;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObjectBase;
import oracle.adfmf.dc.bean.ConcreteJavaCollectionObject;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationRuntimeException;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.misc.ISO8601DateTimeUtil;
import oracle.adfmf.util.AttributeInfo;
import oracle.adfmf.util.EmbeddedUtility;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class ConcreteJavaBeanObject
extends ConcreteJavaBeanObjectBase {
    private static final Set scalarDCTypes = new HashSet();
    private List accessorNames = null;

    private static boolean isScalarDCType(Class clazz) {
        return scalarDCTypes.contains(clazz);
    }

    protected void applyDefaultValues() {
        Map map = DefaultValues.getDefaults(this.beanClass.getName());
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = DefaultValues.getDefaultValue(map, string);
                this.setAttribute(string, object);
            }
        }
    }

    protected ConcreteJavaBeanObject(Class clazz, Object object) {
        super(clazz, object);
    }

    private Object getAccessorValue(String string) {
        try {
            Object object = null;
            if (this.beanInstance != null) {
                Method method = Utility.getReadAccessorFromPropertyName(this.beanInstance, string);
                object = method.invoke(this.beanInstance, new Object[0]);
            }
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logException("getAccessorValue (for accessor: " + this.beanClass.getName() + "." + string + ")", invocationTargetException);
            throw this.wrapThrowable(invocationTargetException.getTargetException() == null ? invocationTargetException : invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            this.logException("getAccessorValue (for accessor: " + this.beanClass.getName() + "." + string + ")", throwable);
            throw this.wrapThrowable(throwable);
        }
    }

    private List getAccessorNames() {
        if (this.accessorNames == null) {
            this.accessorNames = new ArrayList();
            Method[] methodArray = this.beanClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                String string;
                Method method = methodArray[i];
                if (!Modifier.isPublic(method.getModifiers()) || (string = Utility.getGetterVariable(method)) == null || string.length() <= 0) continue;
                this.accessorNames.add(string);
            }
        }
        return this.accessorNames;
    }

    private void logException(String string, Throwable throwable) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, ConcreteJavaBeanObject.class, string, "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11078", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
        }
    }

    private void logException(String string, InvocationTargetException invocationTargetException) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, ConcreteJavaBeanObject.class, string, "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11078", new Object[]{invocationTargetException.getTargetException().getClass().getName(), invocationTargetException.getTargetException().getMessage()});
        }
    }

    private AdfException wrapThrowable(Throwable throwable) {
        if (throwable instanceof AdfException) {
            return (AdfException)throwable;
        }
        return new AdfInvocationRuntimeException(throwable, "ERROR", "BEAN", -1);
    }

    protected Object wrapValue(String string, Object object) {
        if (object == null || Utility.isStandardType(object.getClass()) || ISO8601DateTimeUtil.isDateType(object.getClass())) {
            return object;
        }
        if (ConcreteJavaBeanObject.isScalarDCType(object.getClass())) {
            return object.toString();
        }
        ConcreteJavaBeanObjectBase concreteJavaBeanObjectBase = ConcreteJavaBeanObjectBase.newInstance(this, string, object.getClass(), object);
        return concreteJavaBeanObjectBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.beanInstance != null && this.parent != null) {
            Utility.invokeIfPossible(this.beanInstance, "removePropertyChangeListener", new Class[]{PropertyChangeListener.class}, new PropertyChangeListener[]{this});
            Utility.invokeIfPossible(this.beanInstance, "removeProviderChangeListener", new Class[]{ProviderChangeListener.class}, new ProviderChangeListener[]{this});
        }
        Map map = this.wrappedAccessors;
        synchronized (map) {
            Iterator iterator = this.wrappedAccessors.values().iterator();
            while (iterator.hasNext()) {
                ConcreteJavaBeanObjectBase concreteJavaBeanObjectBase = (ConcreteJavaBeanObjectBase)iterator.next();
                concreteJavaBeanObjectBase.dispose();
            }
            this.wrappedAccessors.clear();
        }
    }

    public Object invokeMethod(String string, Class[] classArray, Object[] objectArray) {
        try {
            Method method = this.beanClass.getMethod(string, classArray);
            Object[] objectArray2 = EmbeddedUtility.coerce(classArray, objectArray);
            Object object = method.invoke(this.beanInstance, objectArray2);
            Object object2 = this.wrapValue(string, object);
            if (object2 instanceof GenericType && !(((GenericType)object2).getParent() instanceof ConcreteJavaCollectionObject)) {
                Object[] objectArray3 = new Object[]{object};
                object2 = this.wrapValue(string, objectArray3);
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logException("invokeMethod (for method: " + this.beanClass.getName() + "." + string + ")", invocationTargetException);
            throw this.wrapThrowable(Utility.getCoreThrowableCause(invocationTargetException));
        }
        catch (Throwable throwable) {
            this.logException("invokeMethod (for method: " + this.beanClass.getName() + "." + string + ")", throwable);
            throw this.wrapThrowable(throwable);
        }
    }

    public Object getAttribute(int n) {
        List list = this.getAccessorNames();
        if (n < list.size()) {
            String string = (String)list.get(n);
            return this.getAttribute(string);
        }
        return null;
    }

    public int getAttributeCount() {
        return this.getAccessorNames().size();
    }

    public Object getAttribute(String string) {
        Object object = this.getAccessorValue(string);
        return this.wrapValue(string, object);
    }

    public Object getAttribute(String string, int n) {
        Object object = this.getAttribute(string);
        if (object instanceof ConcreteJavaBeanObjectBase && ((ConcreteJavaBeanObjectBase)object).getParent() instanceof ConcreteJavaCollectionObject) {
            return ((ConcreteJavaBeanObjectBase)object).getParent().getAttribute(n);
        }
        return this.getAttribute(string);
    }

    public Object getAttribute(String string, String string2) {
        return this.getAttribute(string2);
    }

    public void setAttribute(String string, Object object) {
        AdfException adfException = null;
        try {
            super.setAttribute(string, object);
        }
        catch (AdfException adfException2) {
            if (adfException2.getSeverity() == "ERROR" || adfException2.getSeverity() == "FATAL") {
                throw adfException2;
            }
            adfException = adfException2;
        }
        try {
            Class clazz = this.getAttributeType(string);
            Method method = Utility.getWriteAccessorFromPropertyName(this.beanInstance, string, clazz);
            Object object2 = EmbeddedUtility.coerce(clazz, object);
            method.invoke(this.beanInstance, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logException("setAttribute (for accessor: " + this.beanClass.getName() + "." + string + ")", invocationTargetException);
            throw this.wrapThrowable(invocationTargetException.getTargetException() == null ? invocationTargetException : invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            this.logException("setAttribute (for accessor: " + this.beanClass.getName() + "." + string + ")", throwable);
            throw this.wrapThrowable(throwable);
        }
        if (adfException != null) {
            throw adfException;
        }
    }

    public int getAttributeCount(String string) {
        Object object = this.getAttribute(string);
        if (object instanceof ConcreteJavaBeanObjectBase) {
            if (((ConcreteJavaBeanObjectBase)object).getParent() instanceof ConcreteJavaCollectionObject) {
                return ((ConcreteJavaBeanObjectBase)object).getParent().getAttributeCount();
            }
        } else if (object == null && this.isAttributeCollection(string)) {
            return 0;
        }
        return 1;
    }

    public AttributeInfo getAttributeInfo(int n) {
        List list = this.getAccessorNames();
        if (n < list.size()) {
            AttributeInfo attributeInfo = new AttributeInfo();
            attributeInfo.name = (String)list.get(n);
            attributeInfo.namespace = "";
            attributeInfo.type = this.getAttributeType(attributeInfo.name).getName();
            return attributeInfo;
        }
        return null;
    }

    public Class getAttributeType(String string) {
        try {
            if (this.beanInstance instanceof TypeInfoProvider) {
                return ((TypeInfoProvider)this.beanInstance).getAttributeType(string);
            }
            Method method = Utility.getReadAccessorFromPropertyName(this.beanInstance, string);
            return method.getReturnType();
        }
        catch (Throwable throwable) {
            this.logException("getAttributeType (for accessor: " + this.beanClass.getName() + "." + string + ")", throwable);
            throw new AdfException(throwable);
        }
    }

    public Object getInstance() {
        return this.beanInstance;
    }

    public boolean isUpdateable(String string) {
        try {
            Utility.getWriteAccessorFromPropertyName(this.beanInstance, string, this.getAttributeType(string));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        scalarDCTypes.add(BigDecimal.class);
        scalarDCTypes.add(BigInteger.class);
        scalarDCTypes.add(Currency.class);
        scalarDCTypes.add(Locale.class);
        scalarDCTypes.add(Random.class);
        scalarDCTypes.add(Timer.class);
    }

    static interface TypeInfoProvider {
        public Class getAttributeType(String var1);
    }
}

