/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.dc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;

public class DefaultValues {
    private static final String PERSDEF = "persdef";
    private static final String PDEF_VIEW_OBJECT = "PDefViewObject";
    private static final String PDEF_ATTRIBUTE = "PDefAttribute";
    private static final String NAME = "Name";
    private static final String DEFAULT_VALUE = "DefaultValue";
    private static final String TRANSIENT_EXPRESSION = "TransientExpression";
    private static final String PRIMARYKEY_ATTRIBUTE = "PrimaryKey";
    private static final String VALIDATION = "validation:";

    private DefaultValues() {
    }

    public static Map getDefaults(String string) {
        Map map = EmbeddedFeatureContext.getInstance().getDefaultValuesMap();
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap != null) {
            return hashMap;
        }
        hashMap = new HashMap();
        map.put(string, hashMap);
        DefaultValues.addDefaults(string, hashMap);
        return hashMap;
    }

    public static String getKeyAttribute(String string) {
        Map map = EmbeddedFeatureContext.getInstance().getKeyAttributesMap();
        return (String)map.get(string);
    }

    public static Map getClassValidators(String string) {
        Map map = EmbeddedFeatureContext.getInstance().getClassValidatorsMap();
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap != null) {
            return hashMap;
        }
        hashMap = new HashMap();
        map.put(string, hashMap);
        DefaultValues.addValidators(string, hashMap);
        return hashMap;
    }

    public static Object getDefaultValue(Map map, String string) {
        if (map == null) {
            return null;
        }
        Object v = map.get(string);
        if (v instanceof TransientExpression) {
            TransientExpression transientExpression = (TransientExpression)v;
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11103", new Object[]{transientExpression.value});
        }
        return v;
    }

    public static List getAttributeValidators(Map map, String string) {
        if (map == null) {
            return null;
        }
        List list = (List)map.get(string);
        return list;
    }

    private static void addDefaults(String string, Map map) {
        String string2 = "persdef/" + string.replace('.', '/') + ".xml";
        try {
            XmlAnyDefinition xmlAnyDefinition = null;
            try {
                xmlAnyDefinition = XmlAnyDefinition.loadXmlFromLocation(string2, PDEF_VIEW_OBJECT);
            }
            catch (AdfException adfException) {
                xmlAnyDefinition = null;
            }
            if (null == xmlAnyDefinition) {
                return;
            }
            List list = xmlAnyDefinition.getChildDefinitions(PDEF_ATTRIBUTE);
            if (list.isEmpty()) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3;
                Object object;
                XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
                String string4 = (String)xmlAnyDefinition2.getAttributeValue(NAME);
                if (Utility.isEmpty(string4)) continue;
                Object object2 = xmlAnyDefinition2.getAttributeValue(PRIMARYKEY_ATTRIBUTE);
                if (null != object2 && "true".equals(object2)) {
                    EmbeddedFeatureContext.getInstance().getKeyAttributesMap().put(string, string4);
                }
                if (null != (object = xmlAnyDefinition2.getAttributeValue(DEFAULT_VALUE))) {
                    map.put(string4, object);
                    continue;
                }
                XmlAnyDefinition xmlAnyDefinition3 = xmlAnyDefinition2.getChildDefinition(TRANSIENT_EXPRESSION);
                if (null == xmlAnyDefinition3 || Utility.isEmpty(string3 = xmlAnyDefinition3.getText())) continue;
                map.put(string4, new TransientExpression(string3));
            }
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11086", new Object[]{string2, exception.getMessage()});
        }
    }

    private static void addValidators(String string, Map map) {
        String string2 = "persdef/" + string.replace('.', '/') + ".xml";
        try {
            XmlAnyDefinition xmlAnyDefinition = null;
            try {
                xmlAnyDefinition = XmlAnyDefinition.loadXmlFromLocation(string2, PDEF_VIEW_OBJECT);
            }
            catch (AdfException adfException) {
                xmlAnyDefinition = null;
            }
            if (null == xmlAnyDefinition) {
                return;
            }
            List list = xmlAnyDefinition.getChildDefinitions(PDEF_ATTRIBUTE);
            if (list.isEmpty()) {
                return;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                List list2;
                XmlAnyDefinition xmlAnyDefinition2 = (XmlAnyDefinition)iterator.next();
                String string3 = (String)xmlAnyDefinition2.getAttributeValue(NAME);
                if (Utility.isEmpty(string3) || (list2 = xmlAnyDefinition2.getChildDefinitions(VALIDATION, 1)).size() <= 0) continue;
                map.put(string3, list2);
            }
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11104", new Object[]{string2, exception.getMessage()});
        }
    }

    static class TransientExpression {
        final String value;

        TransientExpression(String string) {
            this.value = string;
        }
    }
}

