/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.bindings.DataControl;
import oracle.adfmf.bindings.OperationBinding;
import oracle.adfmf.bindings.OperationInfo;
import oracle.adfmf.bindings.OperationParameter;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.bindings.dbf.AmxControlBinding;
import oracle.adfmf.bindings.dbf.AmxInvokeMethod;
import oracle.adfmf.bindings.dbf.AmxMethodIteratorBinding;
import oracle.adfmf.bindings.dbf.AmxOperationParameter;
import oracle.adfmf.bindings.dbf.AmxVariable;
import oracle.adfmf.bindings.dbf.AmxVariableIteratorBinding;
import oracle.adfmf.dc.GenericJavaBeanDataControlAdapter;
import oracle.adfmf.dc.bean.ConcreteJavaBeanObjectBase;
import oracle.adfmf.framework.EmbeddedFeatureContext;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.model.AdfELContext;
import oracle.adfmf.metadata.page.MethodActionDefinition;
import oracle.adfmf.metadata.page.NamedDataDefinition;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericTypeIteratorAdapter;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class AmxMethodActionBinding
extends AmxControlBinding
implements OperationBinding {
    private static final String RETURN_SUFFIX = "_Return";
    private final MethodActionDefinition metadata;
    private final AmxInvokeMethod opInfo;
    private List paramObjects = null;
    private List resultIteratorsList = new ArrayList();

    public AmxMethodActionBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
        super(amxBindingContainer);
        this.metadata = new MethodActionDefinition(xmlAnyDefinition);
        OperationParameter[] operationParameterArray = new OperationParameter[this.metadata.getNamedDataDefinitions().size()];
        Iterator iterator = this.metadata.getNamedDataDefinitions().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NamedDataDefinition namedDataDefinition = new NamedDataDefinition((XmlAnyDefinition)iterator.next());
            AmxOperationParameter amxOperationParameter = new AmxOperationParameter(namedDataDefinition.getNDName(), namedDataDefinition.getNDType(), namedDataDefinition.getNDValue());
            operationParameterArray[n] = amxOperationParameter;
            ++n;
        }
        this.opInfo = new AmxInvokeMethod(this.metadata.getDataControl() + "." + this.getInstanceName(), this.getMethodName(), this.getReturnName(), operationParameterArray);
    }

    public Object getId() {
        return this.metadata.getId();
    }

    public String getInstanceName() {
        return this.metadata.getInstanceName();
    }

    public String getMethodName() {
        return this.metadata.getMethodName();
    }

    public String getReturnName() {
        return this.metadata.getReturnName();
    }

    private DataControl getDataControl() {
        return this.getDataControl(this.metadata.getDataControl());
    }

    private Object getInstance() {
        Object object = null;
        if (!this.metadata.isLocalObjectReference()) {
            GenericJavaBeanDataControlAdapter genericJavaBeanDataControlAdapter = (GenericJavaBeanDataControlAdapter)this.getDataControl();
            object = genericJavaBeanDataControlAdapter.getWrappedDataProvider();
        } else if (this.metadata.getIterBinding() != null) {
            GenericTypeIteratorAdapter genericTypeIteratorAdapter = (GenericTypeIteratorAdapter)this.getExecutable(this.metadata.getIterBinding()).getIterator();
            object = genericTypeIteratorAdapter.getWrappedDataProvider();
        } else {
            String string = this.metadata.getInstanceName();
            if (!AdfmfJavaUtilities.isEvaluationExpression(string)) {
                string = "${" + string + "}";
            }
            if ((object = AdfmfJavaUtilities.evaluateELExpression(string)) != null && !(object instanceof GenericType)) {
                object = ConcreteJavaBeanObjectBase.newInstance(null, object.getClass(), object);
            }
        }
        return object;
    }

    public boolean getEnabled() {
        return true;
    }

    public Object getExecute() {
        return this.execute();
    }

    public XmlAnyDefinition getMetadataDefinition() {
        return this.metadata;
    }

    public boolean isOperationEnabled() {
        return true;
    }

    public void getExecute(ActionEvent actionEvent) {
        this.execute();
    }

    public Object execute() {
        AdfELContext adfELContext = ((EmbeddedFeatureContext)AdfmfJavaUtilities.getFeatureContext()).getAdfELContext();
        adfELContext.registerCurrentExpressionAsVolatile();
        try {
            AmxBindingContext amxBindingContext = this.getContainer().getBindingContext();
            Object object = this.getInstance();
            this.opInfo.setInvokeInstance(object);
            if (this.getDataControl().invokeOperation(amxBindingContext, this)) {
                Object object2 = this.opInfo.getResult();
                this.updateResult(object2);
                return object2;
            }
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, "invokeDataControlMethod", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40074", new Object[]{this.getDataControl().getName(), this.getMethodName()});
            }
        }
        catch (AdfException adfException) {
            throw adfException;
        }
        catch (Throwable throwable) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                this.log(Level.SEVERE, "execute", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11078", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
            }
            throw new AdfException(throwable instanceof Exception ? (Exception)throwable : throwable, "ERROR");
        }
        return null;
    }

    public OperationInfo getOperationInfo() {
        return this.opInfo;
    }

    public Map getParamsMap() throws ELException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        OperationParameter[] operationParameterArray = this.opInfo.getParameters();
        for (int i = 0; i < operationParameterArray.length; ++i) {
            OperationParameter operationParameter = operationParameterArray[i];
            AmxVariable amxVariable = new AmxVariable(operationParameter.getName(), operationParameter.getTypeName(), operationParameter.getValue());
            Object object = amxVariable.getValue();
            if (object instanceof ELException) {
                throw (ELException)object;
            }
            hashMap.put(amxVariable.getName(), object);
            Object object2 = object;
            this.log(Level.INFO, "getParamsMap", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11005", new Object[]{object2 != null ? object2 : "null"});
        }
        return hashMap;
    }

    void addBoundResultIterator(AmxMethodIteratorBinding amxMethodIteratorBinding) {
        this.resultIteratorsList.add(amxMethodIteratorBinding);
    }

    public Object getResult() {
        ValueExpression valueExpression = this.opInfo.getReturnExpression();
        if (valueExpression != null) {
            return valueExpression.getValue((ELContext)AdfmfJavaUtilities.getAdfELContext());
        }
        return this.execute();
    }

    private void updateResult(Object object) {
        if (object == null || object instanceof GenericType) {
            this.updateMethodIteratorBackedResult(object);
        }
        if (object == null || Utility.isStandardType(object.getClass())) {
            this.updateVariableIteratorBackedResult(object);
        }
    }

    private void updateMethodIteratorBackedResult(Object object) {
        Iterator iterator = this.resultIteratorsList.iterator();
        while (iterator.hasNext()) {
            AmxMethodIteratorBinding amxMethodIteratorBinding = (AmxMethodIteratorBinding)iterator.next();
            amxMethodIteratorBinding.updateProvider(object);
        }
    }

    private void updateVariableIteratorBackedResult(Object object) {
        AmxVariableIteratorBinding amxVariableIteratorBinding;
        block4: {
            amxVariableIteratorBinding = null;
            try {
                amxVariableIteratorBinding = (AmxVariableIteratorBinding)this.getContainer().get("variables");
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                if (!Utility.FrameworkLogger.isLoggable(Level.WARNING)) break block4;
                Trace.log(Utility.FrameworkLogger, Level.WARNING, AmxMethodActionBinding.class, "updateVariableIteratorBackedResult", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40118", new Object[]{this.getContainer().getName()});
            }
        }
        boolean bl = false;
        if (amxVariableIteratorBinding != null && amxVariableIteratorBinding.variableExists(this.getId() + RETURN_SUFFIX)) {
            amxVariableIteratorBinding.getIterator().setAttributeValue(this.getId() + RETURN_SUFFIX, object);
            bl = true;
        }
        if (!bl && Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
            Trace.log(Utility.FrameworkLogger, Level.WARNING, AmxMethodActionBinding.class, "updateVariableIteratorBackedResult", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40119", new Object[]{this.getId() + RETURN_SUFFIX, this.getContainer().getName()});
        }
    }
}

