/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import javax.el.ELContext;
import javax.el.ValueExpression;
import oracle.adfmf.bindings.OperationParameter;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.bindings.dbf.AmxOperationInfo;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class AmxInvokeMethod
extends AmxOperationInfo {
    private final OperationParameter[] parameters;
    private Object invokeInstance = null;
    private Object result = null;
    private String returnExpressionKey = null;

    public AmxInvokeMethod(String string, String string2, String string3, OperationParameter[] operationParameterArray) {
        super(string, string2, string3);
        this.parameters = operationParameterArray;
        if (Utility.isNotEmpty(string3)) {
            this.returnExpressionKey = string + "." + string2 + "." + string3;
        }
    }

    public OperationParameter[] getParameters() {
        return this.parameters;
    }

    public Object getInvokeInstance() {
        return this.invokeInstance;
    }

    public void setInvokeInstance(Object object) {
        this.invokeInstance = object;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object object) {
        this.result = object;
        try {
            if (this.returnExpressionKey != null) {
                AmxBindingContext amxBindingContext = (AmxBindingContext)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("data");
                ValueExpression valueExpression = (ValueExpression)amxBindingContext.get(this.returnExpressionKey);
                if (valueExpression == null) {
                    valueExpression = this.createReturnExpression(this.getReturnName());
                    amxBindingContext.put(this.returnExpressionKey, valueExpression);
                }
                valueExpression.setValue((ELContext)AdfmfJavaUtilities.getAdfELContext(), object);
            }
        }
        catch (Exception exception) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, this.getClass(), "setResult", "There was a problem mapping the method result to the return name for {0}", new Object[]{this.getReturnName()});
        }
    }

    private ValueExpression createReturnExpression(String string) {
        if (!AdfmfJavaUtilities.isEvaluationExpression(string)) {
            string = "${" + string + "}";
        }
        return AdfmfJavaUtilities.getValueExpression(string, Object.class);
    }

    public ValueExpression getReturnExpression() {
        AmxBindingContext amxBindingContext = (AmxBindingContext)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("data");
        return (ValueExpression)amxBindingContext.get(this.returnExpressionKey);
    }
}

