/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.adfmf.amx.event.SelectionEvent;
import oracle.adfmf.bindings.dbf.AmxTreeAttributeBinding;
import oracle.adfmf.bindings.dbf.AmxTreeBinding;
import oracle.adfmf.bindings.iterator.BasicIterator;
import oracle.adfmf.dc.JavaBeanObject;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.GenericTypeIteratorAdapter;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class AmxCollectionModel
implements JSONSerializable {
    public static final String COLLECTION_MODEL_NAME = "collectionModel";
    public static final String PROVIDER_MAP_KEY = "providers";
    public static final String KEYS_KEY = "keys";
    public static final String TREE_BINDING_KEY = "bindingsDefinition";
    public static final String RANGE_SIZE_KEY = "rangeSize";
    public static final String TOTAL_SIZE_KEY = "totalSize";
    public static final String TREE_BINDINGS_KEY = "treeNodeBindings";
    public static final String COLUMN_ATTRIBUTES_KEY = "columnAttributes";
    public static final String ID_KEY = "id";
    public static final String DOT_TYPE_KEY = ".type";
    public static final String TREE_BINDINGS_TYPE = "TreeBindings";
    public static final String TREE_NODE_BINDINGS_TYPE = "TreeNodeBindings";
    public static final String SELECTEDROW_KEY = "selectedRow";
    protected Map providerMap = new HashMap();
    protected Map treeBinding;
    protected AmxTreeBinding.AmxTreeNodeDefinitionAccessor columnAttributes;
    protected Object[] orderedKeys;
    protected int rangeSize;
    protected int totalSize;
    protected String id = "";
    static /* synthetic */ Class class$oracle$adfmf$bindings$dbf$AmxCollectionModel$ProviderExtendedAttrMap;

    private static GenericType getActualProviderFromKey(AmxTreeBinding amxTreeBinding, Object object) {
        BasicIterator basicIterator = amxTreeBinding.getIteratorBinding().getIterator();
        int n = 0;
        try {
            n = basicIterator.getIndexFromKey(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        if (basicIterator instanceof GenericTypeIteratorAdapter) {
            GenericType genericType = ((GenericTypeIteratorAdapter)basicIterator).getChildProvider(n);
            return genericType;
        }
        return null;
    }

    private static boolean isAttributeCollection(GenericType genericType, String string) {
        if (genericType instanceof JavaBeanObject) {
            return ((JavaBeanObject)genericType).isAttributeCollection(string);
        }
        Trace.log(Utility.FrameworkLogger, Level.FINE, AmxCollectionModel.class, "isAttributeCollection", (Object)"Cannot determine if provider is a collection or a singleton - serialization may not be reliable");
        return genericType.getAttributeCount(string) > 1;
    }

    private static void extractAttributeValuesForItem(Map map, GenericType genericType, String string) {
        if (AmxCollectionModel.isAttributeCollection(genericType, string)) {
            int n = genericType.getAttributeCount(string);
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = genericType.getAttribute(string, i);
            }
            if (n == 0 || n == 1 && objectArray[0] == null) {
                return;
            }
            map.put(string, objectArray);
        } else {
            map.put(string, genericType.getAttribute(string));
        }
    }

    private static void extractAttributeValuesForAccessor(Map map, GenericType genericType, String string, AmxTreeBinding.AmxTreeNodeDefinitionAccessor amxTreeNodeDefinitionAccessor) {
        if (AmxCollectionModel.isAttributeCollection(genericType, string)) {
            int n = genericType.getAttributeCount(string);
            HashMap[] hashMapArray = new HashMap[n];
            for (int i = 0; i < n; ++i) {
                hashMapArray[i] = new HashMap();
                Object object = genericType.getAttribute(string, i);
                if (object instanceof GenericType) {
                    AmxCollectionModel.extractAttributeValues(hashMapArray[i], amxTreeNodeDefinitionAccessor, (GenericType)object);
                    continue;
                }
                if (object != null) continue;
                hashMapArray[i] = null;
            }
            if (n == 0 || n == 1 && hashMapArray[0] == null) {
                return;
            }
            map.put(string, hashMapArray);
        } else {
            Object object = genericType.getAttribute(string);
            if (object instanceof GenericType) {
                HashMap hashMap = new HashMap();
                AmxCollectionModel.extractAttributeValues(hashMap, amxTreeNodeDefinitionAccessor, (GenericType)object);
                map.put(string, hashMap);
            } else if (object == null) {
                // empty if block
            }
        }
    }

    private static void extractAttributeValues(Map map, AmxTreeBinding.AmxTreeNodeDefinitionAccessor amxTreeNodeDefinitionAccessor, GenericType genericType) {
        Iterator iterator = amxTreeNodeDefinitionAccessor.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof AmxTreeAttributeBinding) {
                AmxCollectionModel.extractAttributeValuesForItem(map, genericType, string);
                continue;
            }
            if (v instanceof AmxTreeBinding.AmxTreeNodeDefinitionAccessor) {
                AmxCollectionModel.extractAttributeValuesForAccessor(map, genericType, string, (AmxTreeBinding.AmxTreeNodeDefinitionAccessor)v);
                continue;
            }
            if (!(v instanceof AmxTreeBinding.TreeLinkedAttributeBinding)) continue;
            map.put(((AmxTreeBinding.TreeLinkedAttributeBinding)v).getAttributeId(), ((AmxTreeBinding.TreeLinkedAttributeBinding)v).getValue(genericType));
        }
    }

    public static Map getFilteredKeyedProviders(BasicIterator basicIterator, AmxTreeBinding amxTreeBinding, Object[] objectArray, AmxTreeBinding.AmxTreeNodeDefinitionAccessor amxTreeNodeDefinitionAccessor, int n) {
        Object object = null;
        SparseProviderMap sparseProviderMap = new SparseProviderMap(amxTreeBinding.getName());
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                object = basicIterator.getProviderKey(objectArray[i], i + n);
                if (objectArray[i] instanceof GenericType) {
                    ProviderExtendedAttrMap providerExtendedAttrMap = new ProviderExtendedAttrMap(object);
                    AmxCollectionModel.extractAttributeValues(providerExtendedAttrMap, amxTreeNodeDefinitionAccessor, (GenericType)objectArray[i]);
                    providerExtendedAttrMap.setTreeBindingWeakReference(amxTreeBinding.getName());
                    objectArray[i] = providerExtendedAttrMap;
                }
                sparseProviderMap.put(object, objectArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                Utility.FrameworkLogger.warning("Problem filtering " + object + " -- error: " + throwable);
            }
        }
        return sparseProviderMap;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public Map getProviderMap() {
        return this.providerMap;
    }

    public void setProviderMap(Map map) {
        this.providerMap = map;
    }

    public Map getProviders() {
        return this.providerMap;
    }

    public Object[] getKeys() {
        return this.orderedKeys;
    }

    public void setKeys(Object[] objectArray) {
        this.orderedKeys = objectArray;
    }

    public Object[] getSelectedRow() {
        return null;
    }

    public void setSelectedRow(Object[] objectArray) {
    }

    public Map getTreeBinding() {
        return this.treeBinding;
    }

    public void setTreeBinding(Map map) {
        this.treeBinding = map;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public void setRangeSize(int n) {
        this.rangeSize = n;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public AmxTreeBinding.AmxTreeNodeDefinitionAccessor getColumnAttributes() {
        return this.columnAttributes;
    }

    public void setColumnAttributes(AmxTreeBinding.AmxTreeNodeDefinitionAccessor amxTreeNodeDefinitionAccessor) {
        this.columnAttributes = amxTreeNodeDefinitionAccessor;
    }

    public Object getTreeNodeBindings() {
        return this;
    }

    public void makeCurrent(SelectionEvent selectionEvent) {
        String[] stringArray = selectionEvent.getSelectedRowKeys();
        if (stringArray != null) {
            if (stringArray.length == 1) {
                AmxTreeBinding amxTreeBinding = (AmxTreeBinding)AdfmfJavaUtilities.evaluateELExpression("#{" + this.id + "}");
                amxTreeBinding.getIterator().setCurrentRowWithKey(stringArray[0]);
            } else if (stringArray.length == 0) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, AmxCollectionModel.class, "makeCurrent", (Object)"Trying to call collectionModel.makeCurrent with 0 keys.");
            } else if (stringArray.length > 1) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, AmxCollectionModel.class, "makeCurrent", (Object)"Trying to call collectionModel.makeCurrent with multiple keys.");
            }
        }
    }

    private final String[] toStringArray(Object[] objectArray) {
        String[] stringArray = null;
        try {
            stringArray = Utility.toStringArray(objectArray, false);
        }
        catch (Exception exception) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11089", new Object[]{this.id});
        }
        return stringArray;
    }

    public Object toJSON() {
        JSONObject jSONObject;
        block3: {
            jSONObject = new JSONObject();
            try {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(PROVIDER_MAP_KEY, JSONBeanSerializationHelper.toJSON(this.providerMap));
                jSONObject2.put(KEYS_KEY, JSONBeanSerializationHelper.toJSON(this.toStringArray(this.orderedKeys)));
                jSONObject2.put(DOT_TYPE_KEY, TREE_NODE_BINDINGS_TYPE);
                jSONObject.put(TREE_BINDINGS_KEY, jSONObject2);
                if (this.columnAttributes != null) {
                    jSONObject.put(COLUMN_ATTRIBUTES_KEY, this.columnAttributes.toJSON());
                }
                jSONObject.put(ID_KEY, this.id);
                jSONObject.put(DOT_TYPE_KEY, TREE_BINDINGS_TYPE);
                jSONObject.put(SELECTEDROW_KEY, JSONObject.NULL);
            }
            catch (Exception exception) {
                if (!Utility.FrameworkLogger.isLoggable(Level.SEVERE)) break block3;
                Trace.log(Utility.FrameworkLogger, this.getClass(), "toJSON", (Throwable)exception);
            }
        }
        return jSONObject;
    }

    private static class ProviderExtendedAttrMap
    extends HashMap {
        public static final String ROWKEY_PROPERTY = "rowKey";
        private final Object outerKey;
        private String treeBindingId = null;

        public ProviderExtendedAttrMap(Object object) {
            this.outerKey = object;
        }

        public Object get(Object object) {
            Object object2 = super.get(object);
            if (object2 == null && ROWKEY_PROPERTY.equals(object) && !this.containsKey(ROWKEY_PROPERTY)) {
                object2 = this.outerKey;
            }
            return object2;
        }

        public Object put(Object object, Object object2) {
            super.put(object, object2);
            try {
                Map map;
                AmxTreeBinding amxTreeBinding;
                GenericType genericType;
                if (this.treeBindingId != null && (genericType = AmxCollectionModel.getActualProviderFromKey(amxTreeBinding = (AmxTreeBinding)(map = (Map)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("bindings")).get(this.treeBindingId), this.outerKey)) != null) {
                    genericType.setAttribute((String)object, object2);
                }
            }
            catch (AdfException adfException) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, class$oracle$adfmf$bindings$dbf$AmxCollectionModel$ProviderExtendedAttrMap == null ? (class$oracle$adfmf$bindings$dbf$AmxCollectionModel$ProviderExtendedAttrMap = AmxCollectionModel.class$("oracle.adfmf.bindings.dbf.AmxCollectionModel$ProviderExtendedAttrMap")) : class$oracle$adfmf$bindings$dbf$AmxCollectionModel$ProviderExtendedAttrMap, "put", "Failed to set a provider attribute - {0}, on provider keyed with - {1}", new Object[]{object, this.outerKey});
                throw adfException;
            }
            return object2;
        }

        public void setTreeBindingWeakReference(String string) {
            this.treeBindingId = string;
        }
    }

    private static class SparseProviderMap
    extends HashMap {
        private String treeBindingId = null;

        public SparseProviderMap(String string) {
            this.treeBindingId = string;
        }

        public Object get(Object object) {
            Object v = super.get(object);
            if (v == null) {
                ProviderExtendedAttrMap providerExtendedAttrMap = new ProviderExtendedAttrMap(object);
                Map map = (Map)AdfmfJavaUtilities.getAdfELContext().evaluateVariable("bindings");
                AmxTreeBinding amxTreeBinding = (AmxTreeBinding)map.get(this.treeBindingId);
                GenericType genericType = AmxCollectionModel.getActualProviderFromKey(amxTreeBinding, object);
                AmxCollectionModel.extractAttributeValues(providerExtendedAttrMap, amxTreeBinding.m_rootAccessor, genericType);
                providerExtendedAttrMap.setTreeBindingWeakReference(this.treeBindingId);
                super.put(object, providerExtendedAttrMap);
                return providerExtendedAttrMap;
            }
            return v;
        }
    }
}

