/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.HashMap;
import java.util.Map;
import oracle.adfmf.bindings.dbf.AmxAccessorIteratorBinding;
import oracle.adfmf.bindings.dbf.AmxActionBinding;
import oracle.adfmf.bindings.dbf.AmxAttributeBinding;
import oracle.adfmf.bindings.dbf.AmxBindingContainer;
import oracle.adfmf.bindings.dbf.AmxControlBinding;
import oracle.adfmf.bindings.dbf.AmxInvokeAction;
import oracle.adfmf.bindings.dbf.AmxIteratorBinding;
import oracle.adfmf.bindings.dbf.AmxMethodActionBinding;
import oracle.adfmf.bindings.dbf.AmxMethodIteratorBinding;
import oracle.adfmf.bindings.dbf.AmxTreeBinding;
import oracle.adfmf.bindings.dbf.AmxVariableIteratorBinding;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class AmxBindingFactory {
    private static final Map bindingTypesMap = new HashMap();
    private static final Object[] bindingElementNames;

    static AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
        try {
            BindingFactory bindingFactory = (BindingFactory)bindingTypesMap.get(xmlAnyDefinition.getElementName());
            if (bindingFactory != null) {
                return bindingFactory.createBinding(xmlAnyDefinition, amxBindingContainer);
            }
            if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, AmxBindingFactory.class, "createBinding", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40046", new Object[]{xmlAnyDefinition.getElementName()});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    static Object[] getBindingElementNames() {
        return bindingElementNames;
    }

    static {
        bindingTypesMap.put("action", new ActionFactory());
        bindingTypesMap.put("attributeValues", new AttributeFactory());
        bindingTypesMap.put("button", new AttributeFactory());
        bindingTypesMap.put("list", new AttributeFactory());
        bindingTypesMap.put("invokeAction", new InvokeActionFactory());
        bindingTypesMap.put("iterator", new IteratorFactory());
        bindingTypesMap.put("accessorIterator", new AccessorIteratorFactory());
        bindingTypesMap.put("methodIterator", new MethodIteratorFactory());
        bindingTypesMap.put("methodAction", new ActionFactory());
        bindingTypesMap.put("tree", new TreeFactory());
        bindingTypesMap.put("variableIterator", new VariableIteratorFactory());
        bindingElementNames = bindingTypesMap.keySet().toArray();
    }

    private static class VariableIteratorFactory
    extends BindingFactory {
        private VariableIteratorFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxVariableIteratorBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class TreeFactory
    extends BindingFactory {
        private TreeFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxTreeBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class MethodIteratorFactory
    extends BindingFactory {
        private MethodIteratorFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxMethodIteratorBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class AccessorIteratorFactory
    extends BindingFactory {
        private AccessorIteratorFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxAccessorIteratorBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class IteratorFactory
    extends BindingFactory {
        private IteratorFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxIteratorBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class InvokeActionFactory
    extends BindingFactory {
        private InvokeActionFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxInvokeAction(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class AttributeFactory
    extends BindingFactory {
        private AttributeFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            return new AmxAttributeBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static class ActionFactory
    extends BindingFactory {
        private ActionFactory() {
        }

        AmxControlBinding createBinding(XmlAnyDefinition xmlAnyDefinition, AmxBindingContainer amxBindingContainer) {
            String string = (String)xmlAnyDefinition.getAttributeValue("Action");
            if ("invokeMethod".equals(string)) {
                return new AmxMethodActionBinding(xmlAnyDefinition, amxBindingContainer);
            }
            return new AmxActionBinding(xmlAnyDefinition, amxBindingContainer);
        }
    }

    private static abstract class BindingFactory {
        private BindingFactory() {
        }

        abstract AmxControlBinding createBinding(XmlAnyDefinition var1, AmxBindingContainer var2);
    }
}

