/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfmf.bindings.dbf;

import com.sun.util.logging.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.el.PropertyNotFoundException;
import oracle.adfmf.bindings.BindingContainer;
import oracle.adfmf.bindings.ControlBinding;
import oracle.adfmf.bindings.OperationBinding;
import oracle.adfmf.bindings.dbf.AmxBindingContext;
import oracle.adfmf.bindings.dbf.AmxBindingFactory;
import oracle.adfmf.bindings.dbf.AmxControlBinding;
import oracle.adfmf.bindings.dbf.AmxExecutableBinding;
import oracle.adfmf.bindings.dbf.AmxVariable;
import oracle.adfmf.bindings.dbf.AmxVariableIteratorBinding;
import oracle.adfmf.framework.Scope;
import oracle.adfmf.framework.api.JSONSerializable;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.metadata.TreeBindingDefinition;
import oracle.adfmf.metadata.page.BeanBindingIteratorBaseDefinition;
import oracle.adfmf.metadata.page.BindingsDefinition;
import oracle.adfmf.metadata.page.ExecutableDefinition;
import oracle.adfmf.metadata.page.ExecutablesDefinition;
import oracle.adfmf.metadata.page.PageDefDefinition;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.XmlAnyDefinition;
import oracle.adfmf.util.logging.Trace;

public class AmxBindingContainer
extends Scope
implements BindingContainer {
    private static final long serialVersionUID = 1L;
    public static final String BINDINGCONTAINER_SCOPE_NAME = "bindings";
    public static final String VARIABLE_ITERATOR_NAME = "variables";
    PageDefDefinition metaData;
    AmxBindingContext parentBindingContext;
    private boolean processingExecutables = false;

    public static AmxBindingContainer getBindingContainer(PageDefDefinition pageDefDefinition, AmxBindingContext amxBindingContext) {
        AmxBindingContainer amxBindingContainer = new AmxBindingContainer(pageDefDefinition, amxBindingContext);
        return amxBindingContainer;
    }

    public AmxBindingContainer(PageDefDefinition pageDefDefinition, AmxBindingContext amxBindingContext) {
        super(BINDINGCONTAINER_SCOPE_NAME);
        this.metaData = pageDefDefinition;
        this.parentBindingContext = amxBindingContext;
    }

    public void release() {
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof AmxControlBinding)) continue;
            ((AmxControlBinding)v).release();
        }
        this.clear();
    }

    public void refresh() {
        throw new UnsupportedOperationException();
    }

    public ControlBinding getControlBinding(String string) {
        throw new UnsupportedOperationException();
    }

    public OperationBinding getOperationBinding(String string) {
        throw new UnsupportedOperationException();
    }

    public Map getControlBindings() {
        throw new UnsupportedOperationException();
    }

    public void containerInitialized(BindingContainer bindingContainer) {
        throw new UnsupportedOperationException();
    }

    public List getErrors() {
        throw new UnsupportedOperationException();
    }

    public ResourceBundle getCurrentResourceBundle() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentResourceBundle(String string, Locale locale) {
        throw new UnsupportedOperationException();
    }

    private AmxVariableIteratorBinding getVariableIterator() {
        if (this.containsKey(VARIABLE_ITERATOR_NAME)) {
            return (AmxVariableIteratorBinding)super.get(VARIABLE_ITERATOR_NAME);
        }
        AmxVariableIteratorBinding amxVariableIteratorBinding = (AmxVariableIteratorBinding)this.getExecutableById(VARIABLE_ITERATOR_NAME);
        super.put(VARIABLE_ITERATOR_NAME, amxVariableIteratorBinding, false);
        return amxVariableIteratorBinding;
    }

    private Object getById(String string) {
        AmxVariableIteratorBinding amxVariableIteratorBinding;
        boolean bl = true;
        Object object = this.getControlBindingById(string);
        if (object == null && (object = this.getExecutableById(string)) == null && (amxVariableIteratorBinding = this.getVariableIterator()) != null && (object = this.getVariableById(amxVariableIteratorBinding, string)) == null && amxVariableIteratorBinding.variableExists(string)) {
            bl = false;
        }
        if (object == null && bl) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, AmxBindingContext.class, "loadDataControlById", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11081", new Object[]{this.getName(), string});
            }
            throw new PropertyNotFoundException(string);
        }
        return object;
    }

    private Object getBindingElementById(String string, XmlAnyDefinition xmlAnyDefinition) {
        Object[] objectArray = AmxBindingFactory.getBindingElementNames();
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            XmlAnyDefinition xmlAnyDefinition2 = xmlAnyDefinition.getChildDefinition(string2, "id", string);
            if (xmlAnyDefinition2 == null) continue;
            return AmxBindingFactory.createBinding(xmlAnyDefinition2, this);
        }
        return null;
    }

    private Object getControlBindingById(String string) {
        return this.getBindingElementById(string, this.metaData.getBindingsDefinition());
    }

    private Object getExecutableById(String string) {
        return this.getBindingElementById(string, this.metaData.getExecutablesDefinition());
    }

    private Object getVariableById(AmxVariableIteratorBinding amxVariableIteratorBinding, String string) {
        if (amxVariableIteratorBinding != null) {
            return amxVariableIteratorBinding.getIterator().getAttributeValue(string);
        }
        return null;
    }

    public String getName() {
        return this.metaData.getId();
    }

    public AmxBindingContext getBindingContext() {
        return this.parentBindingContext;
    }

    public Object get(Object object) {
        if (this.containsKey(object)) {
            return super.get(object);
        }
        Object object2 = this.getById(object.toString());
        super.put(object, object2, false);
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (object2 instanceof AmxControlBinding) {
            return super.put(object, object2, false);
        }
        if (object2 instanceof AmxVariable) {
            if (!super.containsKey(object)) {
                super.put(object, object2, false);
            }
            Object object3 = ((AmxVariable)object2).getValue();
            super.put(object, object3, true);
            return super.put(object, object2, false);
        }
        return super.put(object, object2, true);
    }

    public boolean isMissingKeyResolvable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExecutables(int n) {
        if (this.processingExecutables) {
            return;
        }
        try {
            this.processingExecutables = true;
            List list = this.metaData.getExecutablesDefinition().getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AmxExecutableBinding amxExecutableBinding;
                ExecutableDefinition executableDefinition = new ExecutableDefinition((XmlAnyDefinition)iterator.next());
                if (!executableDefinition.needsRefresh(n) || (amxExecutableBinding = (AmxExecutableBinding)this.getExecutableById(executableDefinition.getId())) == null) continue;
                amxExecutableBinding.refresh();
            }
            Object var7_6 = null;
            this.processingExecutables = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.processingExecutables = false;
            throw throwable;
        }
    }

    public List getAttrBindingIds() {
        XmlAnyDefinition xmlAnyDefinition;
        BindingsDefinition bindingsDefinition = this.metaData.getBindingsDefinition();
        List list = bindingsDefinition.getAttributeValuesDefinitions();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            arrayList.add(xmlAnyDefinition.getAttributeValue("id"));
        }
        list = bindingsDefinition.getListDefinitions();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            xmlAnyDefinition = (XmlAnyDefinition)iterator.next();
            arrayList.add(xmlAnyDefinition.getAttributeValue("id"));
        }
        return arrayList;
    }

    public Map getTreeDefinitions(String string) {
        BindingsDefinition bindingsDefinition = this.metaData.getBindingsDefinition();
        List list = bindingsDefinition.getTreeDefinitions();
        ExecutablesDefinition executablesDefinition = this.metaData.getExecutablesDefinition();
        HashMap<String, TreeBindingDefinitionJSONHelper> hashMap = new HashMap<String, TreeBindingDefinitionJSONHelper>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TreeBindingDefinition treeBindingDefinition = new TreeBindingDefinition((XmlAnyDefinition)iterator.next());
            TreeBindingDefinitionJSONHelper treeBindingDefinitionJSONHelper = new TreeBindingDefinitionJSONHelper();
            String string2 = treeBindingDefinition.getId();
            treeBindingDefinitionJSONHelper.setId(string2);
            BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition = executablesDefinition.getAccessorIteratorDefinition(treeBindingDefinition.getIterBinding());
            if (beanBindingIteratorBaseDefinition == null) {
                beanBindingIteratorBaseDefinition = executablesDefinition.getMethodIteratorDefinition(treeBindingDefinition.getIterBinding());
            }
            BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition2 = new BeanBindingIteratorBaseDefinition(beanBindingIteratorBaseDefinition);
            treeBindingDefinitionJSONHelper.setIterBinding(beanBindingIteratorBaseDefinition2);
            XmlAnyDefinition xmlAnyDefinition = (XmlAnyDefinition)treeBindingDefinition.getNodeDefinitionDefinitions().get(0);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("DefName", xmlAnyDefinition.getAttributeValue("DefName"));
            hashMap2.put("Name", xmlAnyDefinition.getAttributeValue("Name"));
            List list2 = treeBindingDefinition.getNodeDefinitionAttrNames((String)xmlAnyDefinition.getAttributeValue("Name"));
            hashMap2.put("AttrNames", list2);
            treeBindingDefinitionJSONHelper.setNodeDef(hashMap2);
            hashMap.put(string2, treeBindingDefinitionJSONHelper);
        }
        return hashMap;
    }

    public class TreeBindingDefinitionJSONHelper
    implements JSONSerializable {
        public static final String ID_KEY = "id";
        public static final String ITER_BINDING_KEY = "IterBinding";
        public static final String NODE_DEF_KEY = "nodeDef";
        protected String id;
        protected BeanBindingIteratorBaseDefinition iterBinding;
        protected Map nodeDef;

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public Map getNodeDef() {
            return this.nodeDef;
        }

        public void setNodeDef(Map map) {
            this.nodeDef = map;
        }

        public BeanBindingIteratorBaseDefinition getIterBinding() {
            return this.iterBinding;
        }

        public void setIterBinding(BeanBindingIteratorBaseDefinition beanBindingIteratorBaseDefinition) {
            this.iterBinding = beanBindingIteratorBaseDefinition;
        }

        public Object toJSON() throws Exception {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(ID_KEY, this.id);
            jSONObject.put(ITER_BINDING_KEY, this.iterBinding.toJSON());
            jSONObject.put(NODE_DEF_KEY, this.nodeDef);
            return jSONObject;
        }
    }
}

