/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.datacontrols.device;

import [Loracle.adfmf.framework.contract.adf.JSONContact;;
import com.sun.util.logging.Level;
import java.util.StringTokenizer;
import oracle.adf.model.datacontrols.device.BaseProxy;
import oracle.adf.model.datacontrols.device.Contact;
import oracle.adf.model.datacontrols.device.ContactField;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.framework.contract.adf.JSONContact;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.internal.AdfmfContainerUtilitiesInternal;
import oracle.adfmf.json.JSONArray;
import oracle.adfmf.json.JSONObject;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class ContactProxy
extends BaseProxy {
    private static final String FIND_CONTACTS_METHOD = "adf.mf.internal.api.findContacts";
    private static final String SAVE_CONTACT_METHOD = "adf.mf.internal.api.createContact";
    private static final String REMOVE_CONTACT_METHOD = "adf.mf.internal.api.removeContact";

    private Contact saveContact(Contact contact) {
        try {
            Contact contact2 = null;
            if (this.isValidContactObject(contact)) {
                if (Utility.FrameworkLogger.isLoggable(Level.WARNING)) {
                    this.logImsEntries(contact);
                }
                contact.setIms(null);
                Model.waitForDeviceReady();
                Object object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), SAVE_CONTACT_METHOD, new Object[]{contact.toJSON()}, JSONContact.class);
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, ContactProxy.class, "saveContact", "After invokeAsyncContainerJavaScriptFunction. JSON result = {0}", new Object[]{object});
                }
                contact2 = new Contact((JSONContact)object);
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, ContactProxy.class, "saveContact", "Returning Contact: {0}", new Object[]{contact2});
                }
            }
            return contact2;
        }
        catch (Exception exception) {
            throw new AdfException(exception);
        }
    }

    public Contact createContact(Contact contact) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, ContactProxy.class, "createContact", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40017", new Object[]{contact});
        }
        return this.saveContact(contact);
    }

    public Contact updateContact(Contact contact) {
        if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
            Trace.log(Utility.FrameworkLogger, Level.INFO, ContactProxy.class, "updateContact", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40015", new Object[]{contact});
        }
        return this.saveContact(contact);
    }

    public Contact[] findContacts(String string, String string2, boolean bl) {
        Contact[] contactArray = null;
        try {
            Object object;
            Object object2;
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, ContactProxy.class, "findContacts", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40016", new Object[]{string, string2, new Boolean(bl)});
            }
            if (null == string || null == string2) {
                throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11051", null);
            }
            boolean bl2 = false;
            JSONArray jSONArray = new JSONArray();
            if (string.length() == 0) {
                jSONArray.put("");
            } else {
                object2 = new StringTokenizer(string, ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken().trim();
                    if (((String)object).equals("displayName") || ((String)object).equals("*")) {
                        bl2 = true;
                    }
                    jSONArray.put(object);
                }
            }
            if (!bl2) {
                jSONArray.put("displayName");
            }
            object2 = new JSONObject();
            ((JSONObject)object2).put("filter", string2);
            ((JSONObject)object2).put("multiple", bl);
            Model.waitForDeviceReady();
            object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), FIND_CONTACTS_METHOD, new Object[]{jSONArray, object2}, JSONContact;.class);
            if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                Trace.log(Utility.FrameworkLogger, Level.FINEST, ContactProxy.class, "findContacts", "After invokeAsyncContainerJavaScriptFunction. JSON result = {0}", new Object[]{object});
            }
            JSONContact[] jSONContactArray = (JSONContact[])object;
            int n = jSONContactArray.length;
            contactArray = new Contact[n];
            for (int i = 0; i < n; ++i) {
                contactArray[i] = new Contact(jSONContactArray[i]);
            }
        }
        catch (Exception exception) {
            throw new AdfException(exception);
        }
        return contactArray;
    }

    public void removeContact(Contact contact) {
        try {
            if (Utility.FrameworkLogger.isLoggable(Level.INFO)) {
                Trace.log(Utility.FrameworkLogger, Level.INFO, ContactProxy.class, "removeContact", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40018", new Object[]{contact});
            }
            if (this.isValidContactObject(contact)) {
                Model.waitForDeviceReady();
                Object object = AdfmfContainerUtilitiesInternal.invokeAsyncContainerJavaScriptFunction("_Back_Communication_Channel_", AdfmfJavaUtilities.getFeatureName(), REMOVE_CONTACT_METHOD, new Object[]{contact.toJSON()}, JSONContact.class);
                if (Utility.FrameworkLogger.isLoggable(Level.FINEST)) {
                    Trace.log(Utility.FrameworkLogger, Level.FINEST, ContactProxy.class, "removeContact", "After invokeAsyncContainerJavaScriptFunction. JSON result = {0}", new Object[]{object});
                }
            }
        }
        catch (Exception exception) {
            if (Utility.FrameworkLogger.isLoggable(Level.SEVERE)) {
                Trace.log(Utility.FrameworkLogger, Level.SEVERE, ContactProxy.class, "removeContact", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11059", new Object[]{exception});
            }
            throw new AdfException(exception);
        }
    }

    private boolean isValidContactObject(Contact contact) throws AdfException {
        boolean bl = true;
        if (null == contact) {
            throw new AdfException("ERROR", "oracle.adfmf.resource.CDCErrorBundle", "ADF-MF-11050", null);
        }
        return bl;
    }

    private void logImsEntries(Contact contact) {
        ContactField[] contactFieldArray = contact.getIms();
        if (null != contactFieldArray) {
            ContactField contactField = null;
            String string = null;
            String string2 = null;
            String string3 = "";
            for (int i = 0; i < contactFieldArray.length; ++i) {
                if (i > 0) {
                    string3 = string3 + ", ";
                }
                if (null != (contactField = contactFieldArray[i])) {
                    string = contactField.getValue();
                    string2 = contactField.getType();
                    string3 = string3 + string + "(type - " + string2 + ")";
                    continue;
                }
                string3 = string3 + "null";
            }
            if (contactFieldArray.length > 0) {
                Trace.log(Utility.FrameworkLogger, Level.WARNING, ContactProxy.class, "saveContact", "oracle.adfmf.resource.CDCInfoBundle", "ADF-MF-40019", new Object[]{string3});
            }
        }
    }
}

