/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;
import sun.security.util.ResourcesMgr;
import sun.security.util.SecurityConstants;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private boolean readOnly = false;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;
    static /* synthetic */ Class class$javax$security$auth$Subject;
    static /* synthetic */ Class class$java$util$LinkedList;

    public Subject() {
        this.principals = new SecureSet(this, 1);
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    public Subject(boolean bl, Set set, Set set2, Set set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null input(s)"));
        }
        this.principals = new SecureSet(this, 1, set);
        this.pubCredentials = new SecureSet(this, 2, set2);
        this.privCredentials = new SecureSet(this, 3, set3);
        this.readOnly = bl;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null AccessControlContext provided"));
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PERMISSION);
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PERMISSION);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PRIVILEGED_PERMISSION);
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PRIVILEGED_PERMISSION);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (subject == null) {
                    return new AccessControlContext(accessControlContext, null);
                }
                return new AccessControlContext(accessControlContext, new SubjectDomainCombiner(subject));
            }
        });
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrincipals(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(1, clazz);
    }

    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set getPrivateCredentials() {
        return this.privCredentials;
    }

    public Set getPublicCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(2, clazz);
    }

    public Set getPrivateCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(3, clazz);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            Subject subject = (Subject)object;
            return ((Object)this.getPrincipals()).equals(subject.getPrincipals()) && ((Object)this.getPublicCredentials()).equals(subject.getPublicCredentials()) && ((Object)this.getPrivateCredentials()).equals(subject.getPrivateCredentials());
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean bl) {
        Principal principal;
        String string = new String(ResourcesMgr.getString("Subject:\n"));
        String string2 = new String();
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = null;
        if (bl) {
            try {
                iterator3 = this.getPrivateCredentials().iterator();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        while (iterator.hasNext()) {
            principal = (Principal)iterator.next();
            string2 = string2 + ResourcesMgr.getString("\tPrincipal: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
        }
        while (iterator2.hasNext()) {
            principal = iterator2.next();
            string2 = string2 + ResourcesMgr.getString("\tPublic Credential: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
        }
        if (iterator3 == null) {
            string2 = string2 + ResourcesMgr.getString("\tPrivate Credentials inaccessible\n");
        } else {
            while (iterator3.hasNext()) {
                try {
                    principal = iterator3.next();
                    string2 = string2 + ResourcesMgr.getString("\tPrivate Credential: ") + ((Object)principal).toString() + ResourcesMgr.getString("\n");
                }
                catch (SecurityException securityException) {
                    string2 = string2 + ResourcesMgr.getString("\tPrivate Credential inaccessible\n");
                    break;
                }
            }
        }
        return string + string2;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = this.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            n ^= ((Object)principal).hashCode();
        }
        while (iterator2.hasNext()) {
            n ^= this.getCredHashCode(iterator2.next());
        }
        return n;
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    private void sort(int[] nArray) {
        int n = 0;
        boolean bl = true;
        int n2 = nArray.length - 1;
        while (bl) {
            bl = false;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] >= nArray[n + 1]) continue;
                bl = true;
                int n3 = nArray[n];
                nArray[n] = nArray[n + 1];
                nArray[n + 1] = n3;
            }
            --n2;
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    private class ClassSet
    extends AbstractSet {
        private int which;
        private Set set;
        private Class c;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int n, Class clazz) {
            ClassSet classSet = this;
            synchronized (classSet) {
                this.which = n;
                this.c = clazz;
                Iterator iterator = null;
                switch (n) {
                    case 1: {
                        iterator = Subject.this.principals.iterator();
                        break;
                    }
                    case 2: {
                        iterator = Subject.this.pubCredentials.iterator();
                        break;
                    }
                    default: {
                        iterator = Subject.this.privCredentials.iterator();
                    }
                }
                final Iterator iterator2 = iterator;
                SecurityManager securityManager = System.getSecurityManager();
                this.set = new HashSet();
                while (iterator2.hasNext()) {
                    Object t = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return iterator2.next();
                        }
                    });
                    if (!clazz.isAssignableFrom(t.getClass())) continue;
                    if (n != 3) {
                        this.set.add(t);
                        continue;
                    }
                    if (securityManager != null) {
                        if (Subject.this.getPrincipals() == null || Subject.this.getPrincipals().size() == 0) {
                            securityManager.checkPermission(new PrivateCredentialPermission(t.getClass().getName(), new HashSet()));
                        } else {
                            securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(t.getClass().getName(), Subject.this.getPrincipals()), "read"));
                        }
                    }
                    this.set.add(t);
                }
            }
        }

        public synchronized int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return this.set.iterator();
        }

        public synchronized boolean add(Object object) {
            if (!object.getClass().isAssignableFrom(this.c)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("attempting to add an object which is not an instance of class"));
                Object[] objectArray = new Object[]{this.c.toString()};
                throw new SecurityException(messageFormat.format(objectArray));
            }
            return this.set.add(object);
        }
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject), new ObjectStreamField("elements", class$java$util$LinkedList == null ? (class$java$util$LinkedList = Subject.class$("java.util.LinkedList")) : class$java$util$LinkedList), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList elements;
        private int which;

        SecureSet(Subject subject, int n) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList();
        }

        SecureSet(Subject subject, int n, Set set) {
            this.subject = subject;
            this.which = n;
            this.elements = new LinkedList(set);
        }

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            final LinkedList linkedList = this.elements;
            return new Iterator(){
                ListIterator i;
                {
                    this.i = linkedList.listIterator(0);
                }

                public synchronized boolean hasNext() {
                    return this.i.hasNext();
                }

                public synchronized Object next() {
                    if (SecureSet.this.which != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            if (SecureSet.this.subject.getPrincipals() == null || SecureSet.this.subject.getPrincipals().size() == 0) {
                                securityManager.checkPermission(new PrivateCredentialPermission(linkedList.get(this.i.nextIndex()).getClass().getName(), new HashSet()));
                            } else {
                                securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(linkedList.get(this.i.nextIndex()).getClass().getName(), SecureSet.this.subject.getPrincipals()), "read"));
                            }
                        }
                        catch (SecurityException securityException) {
                            this.i.next();
                            throw securityException;
                        }
                    }
                    return this.i.next();
                }

                public synchronized void remove() {
                    if (SecureSet.this.subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (SecureSet.this.which) {
                            case 1: {
                                securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }
            };
        }

        public synchronized boolean add(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (object instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(object)) {
                return this.elements.add(object);
            }
            return false;
        }

        public synchronized boolean remove(Object object) {
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                if (object2 == null) {
                    if (object != null) continue;
                    iterator.remove();
                    return true;
                }
                if (!object2.equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public synchronized boolean contains(Object object) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && this.which == 3) {
                if (this.subject.getPrincipals() == null || this.subject.getPrincipals().size() == 0) {
                    securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), new HashSet()));
                } else {
                    securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(object.getClass().getName(), this.subject.getPrincipals()), "read"));
                }
            }
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                if (!(object2 == null ? object == null : object2.equals(object))) continue;
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean bl = false;
            final Iterator iterator = this.iterator();
            block0: while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (object == null) {
                        if (e != null) continue;
                        iterator.remove();
                        bl = true;
                        continue block0;
                    }
                    if (!object.equals(e)) continue;
                    iterator.remove();
                    bl = true;
                    continue block0;
                }
            }
            return bl;
        }

        public boolean retainAll(Collection collection) {
            boolean bl = false;
            boolean bl2 = false;
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                bl2 = false;
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (object == null) {
                        if (e != null) continue;
                        bl2 = true;
                        break;
                    }
                    if (!object.equals(e)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                iterator.remove();
                bl2 = false;
                bl = true;
            }
            return bl;
        }

        public void clear() {
            final Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iterator.next();
                    }
                });
                iterator.remove();
            }
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object;
            if (this.which == 3) {
                object = this.iterator();
                while (object.hasNext()) {
                    object.next();
                }
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("this$0", this.subject);
            ((ObjectOutputStream.PutField)object).put("elements", this.elements);
            ((ObjectOutputStream.PutField)object).put("which", this.which);
            objectOutputStream.writeFields();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.subject = (Subject)getField.get("this$0", null);
            this.elements = (LinkedList)getField.get("elements", null);
            this.which = getField.get("which", 0);
        }
    }
}

