/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import com.sun.security.auth.PolicyParser;
import com.sun.security.auth.PolicyPermissions;
import com.sun.security.auth.SubjectCodeSource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.Subject;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public class PolicyFile
extends Policy {
    static final ResourceBundle rb = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private static final Debug debug = Debug.getInstance("policy", "\t[Auth Policy]");
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private Vector policyEntries;
    private Hashtable aliasMapping;
    private boolean initialized = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private static final Class[] PARAMS = new Class[]{String.class, String.class};
    private static IdentityScope scope = null;

    public PolicyFile() {
        String string = System.getProperty(AUTH_POLICY);
        if (string == null) {
            string = System.getProperty(SECURITY_MANAGER);
        }
        if (string != null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.policyEntries = new Vector();
        this.aliasMapping = new Hashtable(11);
        this.initPolicyFile();
        this.initialized = true;
    }

    public synchronized void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshPolicy"));
        }
        this.initialized = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyFile.this.init();
                return null;
            }
        });
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private void initPolicyFile() {
        Object object;
        boolean bl;
        String string;
        String string2;
        String string3;
        String string4 = Security.getProperty("policy.expandProperties");
        if (string4 != null) {
            this.expandProperties = string4.equalsIgnoreCase("true");
        }
        if ((string3 = Security.getProperty("policy.ignoreIdentityScope")) != null) {
            this.ignoreIdentityScope = string3.equalsIgnoreCase("true");
        }
        if ((string2 = Security.getProperty("policy.allowSystemProperty")) != null && string2.equalsIgnoreCase("true") && (string = System.getProperty(AUTH_POLICY)) != null) {
            block14: {
                bl = false;
                if (string.startsWith("=")) {
                    bl = true;
                    string = string.substring(1);
                }
                try {
                    string = PropertyExpander.expand(string);
                    File file = new File(string);
                    object = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL(string);
                    if (debug != null) {
                        debug.println("reading " + object);
                    }
                    this.init((URL)object);
                }
                catch (Exception exception) {
                    if (debug == null) break block14;
                    debug.println("caught exception: " + exception);
                }
            }
            if (bl) {
                if (debug != null) {
                    debug.println("overriding other policies!");
                }
                return;
            }
        }
        int n = 1;
        bl = false;
        while ((object = Security.getProperty(AUTH_POLICY_URL + n)) != null) {
            block15: {
                try {
                    object = PropertyExpander.expand((String)object).replace(File.separatorChar, '/');
                    if (debug != null) {
                        debug.println("reading " + (String)object);
                    }
                    this.init(new URL((String)object));
                    bl = true;
                }
                catch (Exception exception) {
                    if (debug == null) break block15;
                    debug.println("error reading policy " + exception);
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        if (!bl) {
            // empty if block
        }
    }

    private boolean checkForTrustedIdentity(Certificate certificate) {
        return false;
    }

    private void init(URL uRL) {
        block5: {
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL));
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore);
                }
            }
            catch (PolicyParser.ParsingException parsingException) {
                System.err.println(AUTH_POLICY + rb.getString(": error parsing ") + uRL);
                System.err.println(AUTH_POLICY + rb.getString(": ") + parsingException.getMessage());
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy)) == null) {
            if (debug != null) {
                debug.println(" no certs for alias " + grantEntry.signedBy + ", ignoring.");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        if (grantEntry.principals == null || grantEntry.principals.size() == 0) {
            return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
        }
        return this.canonicalizeCodebase(new SubjectCodeSource(null, grantEntry.principals, uRL, certificateArray), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) {
        Object object;
        Object object2;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            if (grantEntry.principals != null && grantEntry.principals.size() > 0) {
                object2 = grantEntry.principals.listIterator();
                while (object2.hasNext()) {
                    object = (PolicyParser.PrincipalEntry)object2.next();
                    debug.println("  " + ((PolicyParser.PrincipalEntry)object).principalClass + " " + ((PolicyParser.PrincipalEntry)object).principalName);
                }
            }
            debug.println();
        }
        try {
            object2 = this.getCodeSource(grantEntry, keyStore);
            if (object2 == null) {
                return;
            }
            object = new PolicyEntry((CodeSource)object2);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    Permission permission = permissionEntry.permission.equals("javax.security.auth.PrivateCredentialPermission") && permissionEntry.name.endsWith(" self") ? PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name + " \"self\"", permissionEntry.action) : PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    ((PolicyEntry)object).add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Certificate[] certificateArray = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy) : null;
                    if (certificateArray == null && permissionEntry.signedBy != null) continue;
                    UnresolvedPermission unresolvedPermission = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, certificateArray);
                    ((PolicyEntry)object).add(unresolvedPermission);
                    if (debug == null) continue;
                    debug.println("  " + unresolvedPermission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println(AUTH_POLICY + rb.getString(": error adding Permission ") + permissionEntry.permission + rb.getString(" ") + invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    System.err.println(AUTH_POLICY + rb.getString(": error adding Permission ") + permissionEntry.permission + rb.getString(" ") + exception);
                }
            }
            this.policyEntries.addElement(object);
        }
        catch (Exception exception) {
            System.err.println(AUTH_POLICY + rb.getString(": error adding Entry ") + grantEntry + rb.getString(" ") + exception);
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(PARAMS);
        return (Permission)constructor.newInstance(string2, string3);
    }

    Certificate[] getCertificates(KeyStore keyStore, String string) {
        Object[] objectArray;
        Vector<Certificate> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n;
            Certificate certificate = null;
            certificate = (Certificate)this.aliasMapping.get(objectArray);
            if (certificate == null && keyStore != null) {
                try {
                    certificate = keyStore.getCertificate((String)objectArray);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (certificate != null) {
                    this.aliasMapping.put(objectArray, certificate);
                    this.aliasMapping.put(certificate, objectArray);
                }
            }
            if (certificate == null) continue;
            if (vector == null) {
                vector = new Vector<Certificate>();
            }
            vector.addElement(certificate);
        }
        if (vector != null && n == vector.size()) {
            objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private final synchronized Enumeration elements() {
        return this.policyEntries.elements();
    }

    public PermissionCollection getPermissions(final Subject subject, final CodeSource codeSource) {
        return (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SubjectCodeSource subjectCodeSource = new SubjectCodeSource(subject, null, codeSource == null ? null : codeSource.getLocation(), codeSource == null ? null : codeSource.getCertificates());
                if (PolicyFile.this.initialized) {
                    return PolicyFile.this.getPermissions(new Permissions(), (CodeSource)subjectCodeSource);
                }
                return new PolicyPermissions(PolicyFile.this, subjectCodeSource);
            }
        });
    }

    PermissionCollection getPermissions(CodeSource codeSource) {
        if (this.initialized) {
            return this.getPermissions(new Permissions(), codeSource);
        }
        return new PolicyPermissions(this, codeSource);
    }

    Permissions getPermissions(Permissions permissions, CodeSource codeSource) {
        Certificate[] certificateArray;
        if (!this.initialized) {
            this.init();
        }
        CodeSource[] codeSourceArray = new CodeSource[]{null};
        codeSourceArray[0] = this.canonicalizeCodebase(codeSource, true);
        if (debug != null) {
            debug.println("evaluate(" + codeSourceArray[0] + ")\n");
        }
        for (int i = 0; i < this.policyEntries.size(); ++i) {
            PolicyEntry policyEntry = (PolicyEntry)this.policyEntries.elementAt(i);
            if (debug != null) {
                debug.println("PolicyFile CodeSource implies: " + policyEntry.codesource.toString() + "\n\n" + "\t" + codeSourceArray[0].toString() + "\n\n");
            }
            if (!policyEntry.codesource.implies(codeSourceArray[0])) continue;
            for (int j = 0; j < policyEntry.permissions.size(); ++j) {
                Permission permission = (Permission)policyEntry.permissions.elementAt(j);
                if (debug != null) {
                    debug.println("  granting " + permission);
                }
                if (this.addSelfPermissions(permission, policyEntry.codesource, codeSourceArray[0], permissions)) continue;
                permissions.add(permission);
            }
        }
        if (!this.ignoreIdentityScope && (certificateArray = codeSourceArray[0].getCertificates()) != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                if (this.aliasMapping.get(certificateArray[i]) != null || !this.checkForTrustedIdentity(certificateArray[i])) continue;
                permissions.add(new AllPermission());
            }
        }
        return permissions;
    }

    private boolean addSelfPermissions(Permission permission, CodeSource codeSource, CodeSource codeSource2, Permissions permissions) {
        if (!(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        if (!(codeSource instanceof SubjectCodeSource)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        String[][] stringArray = privateCredentialPermission.getPrincipals();
        if (stringArray.length <= 0 || !stringArray[0][0].equalsIgnoreCase("self") || !stringArray[0][1].equalsIgnoreCase("self")) {
            return false;
        }
        if (subjectCodeSource.getPrincipals() == null) {
            return true;
        }
        ListIterator listIterator = subjectCodeSource.getPrincipals().listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            String[][] stringArray2 = this.getPrincipalInfo(principalEntry, codeSource2);
            for (int i = 0; i < stringArray2.length; ++i) {
                PrivateCredentialPermission privateCredentialPermission2 = new PrivateCredentialPermission(privateCredentialPermission.getCredentialClass() + " " + stringArray2[i][0] + " " + "\"" + stringArray2[i][1] + "\"", "read");
                if (debug != null) {
                    debug.println("adding SELF permission: " + privateCredentialPermission2.toString());
                }
                permissions.add(privateCredentialPermission2);
            }
        }
        return true;
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, CodeSource codeSource) {
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = principalEntry.principalClass;
            stringArray[0][1] = principalEntry.principalName;
            return stringArray;
        }
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray;
            Set set;
            block7: {
                SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                set = null;
                try {
                    stringArray = Class.forName(principalEntry.principalClass, false, ClassLoader.getSystemClassLoader());
                    set = subjectCodeSource.getSubject().getPrincipals((Class)stringArray);
                }
                catch (Exception exception) {
                    if (debug == null) break block7;
                    debug.println("problem finding Principal Class when expanding SELF permission: " + exception.toString());
                }
            }
            if (set == null) {
                return new String[0][0];
            }
            stringArray = new String[set.size()][2];
            Iterator iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                stringArray[n][0] = principal.getClass().getName();
                stringArray[n][1] = principal.getName();
                ++n;
            }
            return stringArray;
        }
        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
        Set set = subjectCodeSource.getSubject().getPrincipals();
        String[][] stringArray = new String[set.size()][2];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            stringArray[n][0] = principal.getClass().getName();
            stringArray[n][1] = principal.getName();
            ++n;
        }
        return stringArray;
    }

    Certificate[] getSignerCertificates(CodeSource codeSource) {
        int n;
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        for (n = 0; n < certificateArray.length; ++n) {
            if (certificateArray[n] instanceof X509Certificate) continue;
            return codeSource.getCertificates();
        }
        int n2 = 0;
        for (n = 0; n < certificateArray.length; ++n) {
            ++n2;
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        if (n2 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (n = 0; n < certificateArray.length; ++n) {
            arrayList.add(certificateArray[n]);
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        Certificate[] certificateArray2 = new Certificate[arrayList.size()];
        arrayList.toArray(certificateArray2);
        return certificateArray2;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block15: {
            codeSource2 = codeSource;
            if (codeSource.getLocation() != null && codeSource.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    String string = codeSource.getLocation().getFile().replace('/', File.separatorChar);
                    URL uRL = null;
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                        boolean bl2 = false;
                        if (string.endsWith(File.separator)) {
                            bl2 = true;
                        }
                        if (string.equals("")) {
                            string = System.getProperty("user.dir");
                        }
                        File file = new File(string);
                        string = file.getCanonicalPath();
                        StringBuffer stringBuffer = new StringBuffer(string);
                        if (!string.endsWith(File.separator) && (bl2 || file.isDirectory())) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append('*');
                        string = stringBuffer.toString();
                    } else {
                        string = new File(string).getCanonicalPath();
                    }
                    uRL = new File(string).toURL();
                    if (codeSource instanceof SubjectCodeSource) {
                        SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                        codeSource2 = bl ? new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), uRL, this.getSignerCertificates(subjectCodeSource)) : new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), uRL, subjectCodeSource.getCertificates());
                        break block15;
                    }
                    if (bl) {
                        codeSource2 = new CodeSource(uRL, this.getSignerCertificates(codeSource));
                        break block15;
                    }
                    codeSource2 = new CodeSource(uRL, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (!bl) break block15;
                    if (!(codeSource instanceof SubjectCodeSource)) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                        break block15;
                    }
                    SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                    codeSource2 = new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), subjectCodeSource.getLocation(), this.getSignerCertificates(subjectCodeSource));
                }
            } else if (bl) {
                if (!(codeSource instanceof SubjectCodeSource)) {
                    codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                } else {
                    SubjectCodeSource subjectCodeSource = (SubjectCodeSource)codeSource;
                    codeSource2 = new SubjectCodeSource(subjectCodeSource.getSubject(), subjectCodeSource.getPrincipals(), subjectCodeSource.getLocation(), this.getSignerCertificates(subjectCodeSource));
                }
            }
        }
        return codeSource2;
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector permissions;

        PolicyEntry(CodeSource codeSource) {
            this.codesource = codeSource;
            this.permissions = new Vector();
        }

        void add(Permission permission) {
            this.permissions.addElement(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(rb.getString("("));
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            for (int i = 0; i < this.permissions.size(); ++i) {
                Permission permission = (Permission)this.permissions.elementAt(i);
                stringBuffer.append(rb.getString(" "));
                stringBuffer.append(rb.getString(" "));
                stringBuffer.append(permission);
                stringBuffer.append(rb.getString("\n"));
            }
            stringBuffer.append(rb.getString(")"));
            stringBuffer.append(rb.getString("\n"));
            return stringBuffer.toString();
        }
    }
}

