/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.ssl;

import com.sun.cdc.io.j2me.UniversalFilterInputStream;
import com.sun.cdc.io.j2me.UniversalFilterOutputStream;
import com.sun.cdc.io.j2me.ssl.CertStore;
import com.sun.cdc.io.j2me.ssl.PkiCertificate;
import com.sun.cdc.io.j2me.ssl.SSLSecurityInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;
import javax.microedition.pki.CertificateException;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLStreamConnection
implements StreamConnection {
    private String protocol;
    private static CertStore trustedCertStore = null;
    private static boolean trustedCertStoreLocked = false;
    private static boolean trustedCertStoreInitialized = false;
    private String host = null;
    private int port = 0;
    private boolean copen = false;
    private Socket socket;
    private PkiCertificate serverCert;
    private String cipherSuite;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};

    public static synchronized void setTrustedCertStore(CertStore certStore) {
        if (trustedCertStoreLocked) {
            return;
        }
        trustedCertStore = certStore;
        trustedCertStoreInitialized = true;
    }

    public static synchronized CertStore getTrustedCertStore() {
        if (!trustedCertStoreInitialized) {
            try {
                trustedCertStore = (CertStore)Class.forName("com.sun.cdc.io.j2me.ssl").newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            trustedCertStoreInitialized = true;
        }
        return trustedCertStore;
    }

    public static synchronized void lockTrustedCertStore() {
        if (trustedCertStore == null) {
            return;
        }
        trustedCertStoreLocked = true;
    }

    public SSLStreamConnection(String string, int n) throws IOException {
        this(string, n, null, 0);
    }

    public SSLStreamConnection(String string, int n, String string2, int n2) throws IOException {
        this.host = string;
        this.port = n;
        Class<?> clazz = null;
        Object var6_6 = null;
        try {
            Object object;
            Class<?> clazz2 = Class.forName("javax.net.ssl.TrustManager");
            Object object2 = Array.newInstance(clazz2, 1);
            clazz = Class.forName("com.sun.cdc.io.j2me.ssl.J2meTrustManager");
            var6_6 = clazz.newInstance();
            Array.set(object2, 0, var6_6);
            Class<?> clazz3 = Class.forName("javax.net.ssl.KeyManager");
            Object object3 = Array.newInstance(clazz3, 0);
            Class<?> clazz4 = Class.forName("javax.net.ssl.SSLContext");
            Class<?> clazz5 = Class.forName("java.security.SecureRandom");
            Method method = clazz4.getMethod("getInstance", PARAMS1);
            Method method2 = clazz4.getMethod("init", object3.getClass(), object2.getClass(), clazz5);
            Object object4 = method.invoke(null, (Object[])new String[]{"TLS"});
            method2.invoke(object4, null, object2, null);
            Method method3 = clazz4.getMethod("getSocketFactory", PARAMS0);
            Object object5 = method3.invoke(object4, (Object[])PARAMS0);
            Method method4 = null;
            Object object6 = null;
            if (string2 == null) {
                method4 = object5.getClass().getMethod("createSocket", String.class, Integer.TYPE);
                object6 = method4.invoke(object5, string, new Integer(n));
            } else {
                object = new Socket(string2, n2);
                this.doTunnelHandshake((Socket)object, string, n, string2, n2);
                method4 = object5.getClass().getMethod("createSocket", Socket.class, String.class, Integer.TYPE, Boolean.TYPE);
                object6 = method4.invoke(object5, object, string, new Integer(n), Boolean.TRUE);
            }
            object = object6.getClass().getMethod("getSession", null);
            AccessController.doPrivileged(new PrivilegedAction((Method)object){
                private final /* synthetic */ Method val$getSessionMethod;
                {
                    this.val$getSessionMethod = method;
                }

                public Object run() {
                    this.val$getSessionMethod.setAccessible(true);
                    return null;
                }
            });
            this.socket = (Socket)object6;
            Object object7 = ((Method)object).invoke(object6, null);
            final Method method5 = object7.getClass().getMethod("getProtocol", null);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method5.setAccessible(true);
                    return null;
                }
            });
            this.protocol = (String)method5.invoke(object7, null);
            final Method method6 = object7.getClass().getMethod("getCipherSuite", null);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method6.setAccessible(true);
                    return null;
                }
            });
            this.cipherSuite = (String)method6.invoke(object7, null);
            final Method method7 = object7.getClass().getMethod("getPeerCertificates", null);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method7.setAccessible(true);
                    return null;
                }
            });
            Certificate[] certificateArray = (Certificate[])method7.invoke(object7, null);
            if (certificateArray == null) {
                throw new IOException("No peer cerificate chain");
            }
            this.serverCert = new PkiCertificate(certificateArray[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Class not found: " + classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("No such method: " + noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Illegal Access: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            throw new RuntimeException("Can't instantiate object: " + instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                Throwable throwable = invocationTargetException.getCause();
                Class<?> clazz6 = Class.forName("javax.net.ssl.SSLPeerUnverifiedException");
                Class<?> clazz7 = Class.forName("java.lang.SecurityException");
                if (clazz6.isInstance(throwable)) {
                    Method method = clazz.getMethod("getPeerChain", PARAMS0);
                    Method method8 = clazz.getMethod("getStatus", PARAMS0);
                    Object object = method.invoke(var6_6, (Object[])PARAMS0);
                    this.serverCert = new PkiCertificate((Certificate)Array.get(object, 0));
                    CertificateException certificateException = new CertificateException((javax.microedition.pki.Certificate)this.serverCert, ((Byte)method8.invoke(var6_6, (Object[])PARAMS0)).byteValue());
                    throw certificateException;
                }
                if (clazz7.isInstance(throwable)) {
                    throw new SecurityException("not allowed");
                }
            }
            catch (Exception exception) {
                if (exception instanceof CertificateException) {
                    throw (CertificateException)exception;
                }
                if (exception instanceof SecurityException) {
                    throw (SecurityException)exception;
                }
                throw new RuntimeException("Unexpected Exception: " + exception.getMessage());
            }
            throw new ConnectionNotFoundException("SSL handshake failure");
        }
        catch (Exception exception) {
            if (exception instanceof GeneralSecurityException) {
                throw new RuntimeException("Can't create trust manager: " + exception.getMessage());
            }
            exception.printStackTrace();
            throw new RuntimeException("Unexpected Exception: " + exception.getMessage());
        }
        this.copen = true;
    }

    public synchronized InputStream openInputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new UniversalFilterInputStream((Connection)this, this.socket.getInputStream());
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new UniversalFilterOutputStream((Connection)this, this.socket.getOutputStream());
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public synchronized void close() throws IOException {
        if (this.copen) {
            this.copen = false;
            this.socket.close();
        }
    }

    String getProtocol() {
        return this.protocol;
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        if (!this.copen) {
            throw new IOException("Connection closed");
        }
        return new SSLSecurityInfo(this);
    }

    public PkiCertificate getServerCertificate() {
        return this.serverCert;
    }

    String getCipherSuite() {
        return this.cipherSuite;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    private void doTunnelHandshake(Socket socket, String string, int n, String string2, int n2) throws IOException {
        String string3;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string4 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string4.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string4.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n4 < 2) {
            int n5 = inputStream.read();
            if (n5 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n5 == 10) {
                bl = true;
                ++n4;
                continue;
            }
            if (n5 == 13) continue;
            n4 = 0;
            if (bl || n3 >= byArray2.length) continue;
            byArray2[n3++] = (byte)n5;
        }
        try {
            string3 = new String(byArray2, 0, n3, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = new String(byArray2, 0, n3);
        }
        if (!string3.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + string2 + ":" + n2 + ".  Proxy returns \"" + string3 + "\"");
        }
    }
}

