/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.https;

import com.sun.cdc.io.j2me.http.StreamConnectionElement;
import com.sun.cdc.io.j2me.http.StreamConnectionPool;
import com.sun.cdc.io.j2me.https.SSLStreamConnectionElement;
import com.sun.cdc.io.j2me.https.SSLStreamConnectionPool;
import com.sun.cdc.io.j2me.ssl.PkiCertificate;
import com.sun.cdc.io.j2me.ssl.SSLStreamConnection;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.io.StreamConnection;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;
import sun.misc.NetworkMetrics;
import sun.misc.NetworkMetricsInf;

public class Protocol
extends com.sun.cdc.io.j2me.http.Protocol
implements HttpsConnection {
    private static final int ALTNAME_TYPEDNS = 2;
    private static final String COMMON_NAME_LABEL = "CN=";
    private static final int COMMON_NAME_LABEL_LENGTH = "CN=".length();
    private Hashtable proxyHeaders = new Hashtable();
    private String proxyHost = null;
    private int proxyPort = 0;
    private boolean proxySet = false;
    private String httpsTunnel = null;
    private static SSLStreamConnectionPool staticConnectionPool = new SSLStreamConnectionPool(maxNumberOfPersistentConnections, connectionLingerTime);
    static /* synthetic */ Class class$java$lang$String;

    public Protocol() {
        this.stringbuffer = new StringBuffer();
        this.protocol = "https";
        this.port = 443;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            this.httpsTunnel = System.getProperty("com.sun.cdc.io.http.proxy");
        }
    }

    protected StreamConnectionPool getConnectionPool() {
        return staticConnectionPool;
    }

    private static String getCommonName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(COMMON_NAME_LABEL);
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(59, n += COMMON_NAME_LABEL_LENGTH);
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }

    private static boolean checkSiteName(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string.length() == string2.length() && string.regionMatches(true, 0, string2, 0, string2.length())) {
            return true;
        }
        if (!string2.startsWith("*.")) {
            return false;
        }
        int n = string.indexOf(46);
        if (n == -1) {
            return false;
        }
        int n2 = string.length() - ++n;
        if (string2.length() - 2 != n2) {
            return false;
        }
        return string.regionMatches(true, n, string2, 2, n2);
    }

    public String getRequestProperty(String string) {
        if (string.startsWith("Proxy-")) {
            return (String)this.proxyHeaders.get(string);
        }
        return super.getRequestProperty(string);
    }

    protected void setRequestField(String string, String string2) throws IOException {
        if (string.startsWith("Proxy-")) {
            this.proxyHeaders.put(string, string2);
            return;
        }
        try {
            super.setRequestProperty(string, string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void sendRequest() throws IOException {
        Object object;
        this.streamOutput = this.streamConnection.openDataOutputStream();
        if (this.getRequestProperty("Content-Length") == null || this.getRequestProperty("Content-Length").equals("0")) {
            this.reqProperties.put("Content-Length", "" + (this.privateOut == null ? 0 : this.privateOut.size()));
        }
        String string = this.method + " https://" + this.host + ":" + this.port + (this.getFile() == null ? "/" : this.getFile()) + (this.getRef() == null ? "" : "#" + this.getRef()) + (this.getQuery() == null ? "" : "?" + this.getQuery()) + " " + "HTTP/1.1" + "\r\n";
        this.streamOutput.write(string.getBytes());
        this.totalBytesSent = string.length();
        this.reqProperties.put("Host", this.host + ":" + this.port);
        Enumeration enumeration = this.reqProperties.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string2 = (String)object + ": " + this.reqProperties.get(object) + "\r\n";
            this.streamOutput.write(string2.getBytes());
            this.totalBytesSent += string2.length();
        }
        this.streamOutput.write("\r\n".getBytes());
        this.totalBytesSent += 2;
        if (this.privateOut != null) {
            object = this.privateOut.toByteArray();
            this.streamOutput.write((byte[])object);
            this.totalBytesSent += ((Object)object).length;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (NetworkMetrics.metricsAvailable()) {
                    StreamConnection streamConnection = Protocol.this.streamConnection;
                    int n = Protocol.this.method.equals("POST") ? 1 : (Protocol.this.method.equals("HEAD") ? 2 : 0);
                    Class clazz = NetworkMetrics.getImpl();
                    if (clazz == null) {
                        return null;
                    }
                    try {
                        Protocol.this.nm = (NetworkMetricsInf)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    Protocol.this.nm.initReq(1, Protocol.this.getHost(), Protocol.this.getPort(), Protocol.this.getFile(), Protocol.this.getRef(), Protocol.this.getQuery());
                    if (streamConnection instanceof StreamConnectionElement) {
                        streamConnection = ((StreamConnectionElement)streamConnection).getBaseConnection();
                    }
                    Protocol.this.nm.sendMetricReq(streamConnection, n, Protocol.this.totalBytesSent);
                    Protocol.this.sentMetric = true;
                }
                return null;
            }
        });
        this.streamOutput.flush();
        this.totalBytesRead = 0;
        this.streamInput = this.streamConnection.openDataInputStream();
    }

    protected StreamConnection connectSocket() throws IOException {
        String string;
        PkiCertificate pkiCertificate;
        if (this.host.equals("")) {
            throw new IllegalArgumentException("Host not recognized." + this.host);
        }
        if (this.httpsTunnel != null && !this.proxySet) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    int n = Protocol.this.httpsTunnel.indexOf(58);
                    if (n < 0) {
                        Protocol.this.proxyHost = Protocol.this.httpsTunnel;
                        Protocol.this.proxyPort = 80;
                    } else {
                        Protocol.this.proxyHost = Protocol.this.httpsTunnel.substring(0, n);
                        Protocol.this.proxyPort = Integer.parseInt(Protocol.this.httpsTunnel.substring(++n));
                    }
                    return null;
                }
            });
            this.proxySet = true;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if ("native".equals(System.getProperty("com.oracle.net.httpProxySource"))) {
                    try {
                        URL uRL;
                        Class<?> clazz = Class.forName("com.oracle.net.HTTPProxyLookup");
                        Method method = clazz.getMethod("getProxyForURL", class$java$lang$String == null ? (class$java$lang$String = Protocol.class$("java.lang.String")) : class$java$lang$String);
                        if (Protocol.this.url.startsWith("//")) {
                            Protocol.this.url = "https:" + Protocol.this.url;
                        }
                        if ((uRL = (URL)method.invoke(null, Protocol.this.url)) != null) {
                            Protocol.this.proxyHost = uRL.getHost();
                            Protocol.this.proxyPort = uRL.getPort();
                            Protocol.this.proxySet = true;
                        } else {
                            Protocol.this.proxyHost = null;
                            Protocol.this.proxyPort = 0;
                            Protocol.this.proxySet = false;
                        }
                    }
                    catch (Exception exception) {
                        Protocol.this.proxySet = false;
                    }
                }
                return null;
            }
        });
        Object object = this.connectionPool.get(this.protocol, this.host, this.port);
        if (object == null) {
            object = new SSLStreamConnection(this.host, this.port, this.proxySet ? this.proxyHost : null, this.proxySet ? this.proxyPort : 0);
            pkiCertificate = ((SSLStreamConnection)object).getServerCertificate();
        } else {
            pkiCertificate = ((SSLStreamConnectionElement)((Object)object)).getServerCertificate();
        }
        Collection collection = pkiCertificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean bl = false;
            String string2 = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (Integer.parseInt(list.get(0).toString()) != 2) continue;
                string2 = (String)list.get(1);
                bl = true;
                if (!Protocol.checkSiteName(this.host, string2)) continue;
                return object;
            }
            if (bl) {
                this.disconnect();
                throw new CertificateException("Subject alt name did not match site name", (Certificate)pkiCertificate, 7);
            }
        }
        if ((string = Protocol.getCommonName(pkiCertificate.getSubject())) == null) {
            this.disconnect();
            throw new CertificateException("Common name missing from subject name", (Certificate)pkiCertificate, 7);
        }
        if (!Protocol.checkSiteName(this.host, string)) {
            this.disconnect();
            throw new CertificateException("Common name did not match hostname", (Certificate)pkiCertificate, 7);
        }
        return object;
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        this.ensureOpen();
        if (this.streamConnection == null) {
            StreamConnection streamConnection = this.connectSocket();
            return ((SSLStreamConnection)streamConnection).getSecurityInfo();
        }
        return ((SSLStreamConnection)this.streamConnection).getSecurityInfo();
    }

    protected void outputStreamPermissionCheck() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.host != null) {
                securityManager.checkConnect(this.host, this.port);
            } else {
                securityManager.checkConnect("localhost", this.port);
            }
        }
    }

    protected void inputStreamPermissionCheck() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.host != null) {
                securityManager.checkConnect(this.host, this.port);
            } else {
                securityManager.checkConnect("localhost", this.port);
            }
        }
    }
}

