/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.util.Date;
import java.util.GregorianCalendar;

public class Timestamp
extends Date {
    private int nanos;
    static final long serialVersionUID = 2745179027874758501L;

    public Timestamp(long l) {
        super(l / 1000L * 1000L);
        this.nanos = (int)(l % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((l / 1000L - 1L) * 1000L);
        }
    }

    public void setTime(long l) {
        super.setTime(l / 1000L * 1000L);
        this.nanos = (int)(l % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((l / 1000L - 1L) * 1000L);
        }
    }

    public long getTime() {
        long l = super.getTime();
        return l + (long)(this.nanos / 1000000);
    }

    public static Timestamp valueOf(String string) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        String string2 = "Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
        String string3 = "000000000";
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        int n8 = (string = string.trim()).indexOf(32);
        if (n8 <= 0) {
            throw new IllegalArgumentException(string2);
        }
        String string4 = string.substring(0, n8);
        String string5 = string.substring(n8 + 1);
        int n9 = string4.indexOf(45);
        int n10 = string4.indexOf(45, n9 + 1);
        if (string5 == null) {
            throw new IllegalArgumentException(string2);
        }
        n5 = string5.indexOf(58);
        n6 = string5.indexOf(58, n5 + 1);
        n7 = string5.indexOf(46, n6 + 1);
        if (!(n9 > 0 & n10 > 0 & n10 < string4.length() - 1)) {
            throw new IllegalArgumentException(string2);
        }
        int n11 = Integer.parseInt(string4.substring(0, n9));
        int n12 = Integer.parseInt(string4.substring(n9 + 1, n10)) - 1;
        int n13 = Integer.parseInt(string4.substring(n10 + 1));
        if (n5 > 0 & n6 > 0 & n6 < string5.length() - 1) {
            n3 = Integer.parseInt(string5.substring(0, n5));
            n2 = Integer.parseInt(string5.substring(n5 + 1, n6));
            if (n7 > 0 & n7 < string5.length() - 1) {
                n = Integer.parseInt(string5.substring(n6 + 1, n7));
                String string6 = string5.substring(n7 + 1);
                if (string6.length() > 9) {
                    throw new IllegalArgumentException(string2);
                }
                if (!Character.isDigit(string6.charAt(0))) {
                    throw new IllegalArgumentException(string2);
                }
                string6 = string6 + string3.substring(0, 9 - string6.length());
                n4 = Integer.parseInt(string6);
            } else {
                if (n7 > 0) {
                    throw new IllegalArgumentException(string2);
                }
                n = Integer.parseInt(string5.substring(n6 + 1));
            }
        } else {
            throw new IllegalArgumentException();
        }
        Timestamp timestamp = new Timestamp(new GregorianCalendar(n11, n12, n13, n3, n2, n).getTime().getTime());
        timestamp.setNanos(n4);
        return timestamp;
    }

    public String toString() {
        String string;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        String string3 = "000000000";
        String string4 = "0000";
        if (n < 1000) {
            string2 = "" + n;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n;
        }
        String string5 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string6 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string7 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string8 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string9 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        if (this.nanos == 0) {
            string = "0";
        } else {
            string = Integer.toString(this.nanos);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n7 = 8;
            while (cArray[n7] == '0') {
                --n7;
            }
            string = new String(cArray, 0, n7 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append(" ");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        if (n > 999999999 || n < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n;
    }

    public boolean equals(Timestamp timestamp) {
        if (super.equals(timestamp)) {
            return this.nanos == timestamp.nanos;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Timestamp) {
            return this.equals((Timestamp)object);
        }
        return false;
    }

    public boolean before(Timestamp timestamp) {
        if (super.before(timestamp)) {
            return true;
        }
        if (super.equals(timestamp)) {
            return this.nanos < timestamp.nanos;
        }
        return false;
    }

    public boolean after(Timestamp timestamp) {
        if (super.after(timestamp)) {
            return true;
        }
        if (super.equals(timestamp)) {
            return this.nanos > timestamp.nanos;
        }
        return false;
    }

    public int compareTo(Timestamp timestamp) {
        int n = super.compareTo(timestamp);
        if (n == 0) {
            if (this.nanos > timestamp.nanos) {
                return 1;
            }
            if (this.nanos < timestamp.nanos) {
                return -1;
            }
        }
        return n;
    }

    public int compareTo(Object object) {
        return this.compareTo((Timestamp)object);
    }
}

