/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cvm.channel.impl;

import com.oracle.cvm.channel.VMChannel;
import com.oracle.cvm.channel.VMChannelException;
import com.oracle.cvm.channel.VMChannelManager;
import com.oracle.cvm.channel.VMChannelState;
import com.oracle.cvm.channel.VMControlHandler;
import com.oracle.cvm.channel.VMMessageHandler;
import com.oracle.cvm.channel.impl.VMChannelImpl;
import com.sun.util.logging.Level;
import com.sun.util.logging.Logger;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class VMChannelManagerBase
implements VMChannelManager {
    static final Object GOVERNOR = new Object();
    private static final int CREATE_WAIT_TIMES = 4;
    private static final int DELETE_WAIT_TIMES = 4;
    static Logger logger = null;
    private final Hashtable channels = new Hashtable();
    private VMChannelImpl controlChannel = null;
    private final Object createLock = new Object();
    public boolean creationDone = false;
    private final Object deleteLock = new Object();
    public boolean deletionDone = false;
    private long maxTimeout;

    public synchronized VMChannel init(VMControlHandler vMControlHandler, VMMessageHandler vMMessageHandler) throws VMChannelException {
        return this.init(vMControlHandler, vMMessageHandler, 100L);
    }

    public synchronized VMChannel init(VMControlHandler vMControlHandler, VMMessageHandler vMMessageHandler, long l) throws VMChannelException {
        if (vMControlHandler == null) {
            throw new NullPointerException("VMChannelManager.init() - controlHandler is null");
        }
        if (vMMessageHandler == null) {
            throw new NullPointerException("VMChannelManager.init() - messageHandler is null");
        }
        this.maxTimeout = l;
        if (this.controlChannel == null) {
            this.controlChannel = (VMChannelImpl)this.createAndAddToTable(0);
            this.controlChannel.setControlHandler(vMControlHandler);
            this.controlChannel.startListening(vMMessageHandler);
        }
        return this.controlChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VMChannel getChannel(int n) throws VMChannelException {
        if (this.controlChannel == null) {
            throw new VMChannelException("VMChannelManager was not initialized.");
        }
        if (n == 0) {
            throw new VMChannelException("Channel-0 cannot be accessed using getChannel()");
        }
        VMChannelImpl vMChannelImpl = null;
        Object object = GOVERNOR;
        synchronized (object) {
            vMChannelImpl = (VMChannelImpl)this.lookupChannel(n);
            if (vMChannelImpl != null) {
                return vMChannelImpl;
            }
            vMChannelImpl = (VMChannelImpl)this.createAndAddToTable(n);
            vMChannelImpl.setState(VMChannelState.CREATING);
            this.controlChannel.issueControlMessage(34, n);
        }
        object = this.createLock;
        synchronized (object) {
            for (int i = 0; i < 4 && !this.creationDone; ++i) {
                try {
                    this.createLock.wait(System.currentTimeMillis() % 500L + this.maxTimeout);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        object = GOVERNOR;
        synchronized (object) {
            if (this.creationDone) {
                if (vMChannelImpl.getState() == VMChannelState.CREATING) {
                    vMChannelImpl.setState(VMChannelState.CREATED);
                }
            } else if (vMChannelImpl.getState() == VMChannelState.CREATING) {
                this.removeFromTable(vMChannelImpl);
                this.deleteChannelImpl(n);
                throw new VMChannelException("getChannel(" + n + ") did not receive confirmation within time out period.");
            }
        }
        this.creationDone = false;
        return vMChannelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConfirmReceived(int n) {
        Object object = this.createLock;
        synchronized (object) {
            this.creationDone = true;
            this.createLock.notifyAll();
        }
    }

    public synchronized void deleteChannel(VMChannel vMChannel) throws VMChannelException {
        this.deleteChannel(vMChannel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteChannel(VMChannel vMChannel, boolean bl) throws VMChannelException {
        int n = vMChannel.getID();
        if (this.controlChannel == null) {
            throw new VMChannelException("VMChannelManager was not initialized.");
        }
        Object object = GOVERNOR;
        synchronized (object) {
            if (n == 0) {
                if (bl) {
                    if (this.getChannelsCount() > 1) {
                        throw new VMChannelException("Unable to delete controlchannel, because other channels still exists.");
                    }
                } else {
                    throw new VMChannelException("Unable to delete control channel at this time");
                }
            }
            if (n != 0) {
                vMChannel.stopListening(false);
            }
            ((VMChannelImpl)vMChannel).setState(VMChannelState.DELETING);
            this.controlChannel.issueControlMessage(136, n);
        }
        object = this.deleteLock;
        synchronized (object) {
            for (int i = 0; i < 4 && !this.deletionDone; ++i) {
                try {
                    this.deleteLock.wait(System.currentTimeMillis() % 500L + this.maxTimeout);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        object = GOVERNOR;
        synchronized (object) {
            if (!this.deletionDone && n != 0) {
                throw new VMChannelException("deleteChannel(" + n + ") did not receive confirmation within time out period.");
            }
            this.removeFromTable(vMChannel);
            this.deleteChannelImpl(n);
        }
        this.deletionDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConfirmReceived(int n) {
        Object object = this.deleteLock;
        synchronized (object) {
            this.deletionDone = true;
            this.deleteLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        logger.info("Terminating VMChannels " + this.channels);
        Enumeration enumeration = null;
        Integer n = null;
        VMChannel vMChannel = null;
        Object object = GOVERNOR;
        synchronized (object) {
            enumeration = this.channels.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                if (n == 0) continue;
                vMChannel = (VMChannel)this.channels.get(n);
                logger.info("Terminate - deleting " + vMChannel);
                try {
                    this.deleteChannel(vMChannel, true);
                }
                catch (VMChannelException vMChannelException) {
                    logger.log(Level.SEVERE, "Error occured while deleting " + vMChannel + " for termination", (Throwable)vMChannelException);
                }
            }
            logger.info("About to delete control channel. Existing channels are " + this.channels);
            logger.info("Terminate - deleting " + this.controlChannel);
            try {
                this.deleteChannel(this.controlChannel, true);
                this.controlChannel = null;
            }
            catch (VMChannelException vMChannelException) {
                logger.log(Level.SEVERE, "Error occured while deleting Channel-0 for termination", (Throwable)vMChannelException);
            }
        }
    }

    public void issueControlMessage(int n, int n2) {
        this.controlChannel.issueControlMessage(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean channelExists(int n) {
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            return this.channels.get(new Integer(n)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMChannel createAndAddToTable(int n) throws VMChannelException {
        VMChannel vMChannel = null;
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            vMChannel = this.lookupChannel(n);
            if (vMChannel == null) {
                vMChannel = new VMChannelImpl(n);
                this.channels.put(new Integer(vMChannel.getID()), vMChannel);
            }
        }
        return vMChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTable(VMChannel vMChannel) {
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            this.channels.remove(new Integer(vMChannel.getID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelsCount() {
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            return this.channels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMChannel lookupChannel(int n) {
        Hashtable hashtable = this.channels;
        synchronized (hashtable) {
            return (VMChannel)this.channels.get(new Integer(n));
        }
    }

    public abstract void createChannelImpl(int var1);

    public abstract void deleteChannelImpl(int var1);
}

