/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cvm.channel.impl;

import com.oracle.cvm.channel.ChannelNotAvailableException;
import com.oracle.cvm.channel.NoListenerException;
import com.oracle.cvm.channel.VMChannel;
import com.oracle.cvm.channel.VMChannelException;
import com.oracle.cvm.channel.VMChannelManagerFactory;
import com.oracle.cvm.channel.VMChannelState;
import com.oracle.cvm.channel.VMControlHandler;
import com.oracle.cvm.channel.VMMessage;
import com.oracle.cvm.channel.VMMessageHandler;
import com.oracle.cvm.channel.impl.VMChannelManagerBase;
import com.oracle.cvm.channel.impl.VMMessageImpl;
import com.oracle.cvm.channel.impl.VMMessageQueue;
import com.oracle.cvm.channel.impl.VMMessageQueueFactory;
import com.oracle.cvm.channel.impl.YesNo;
import com.sun.util.logging.Logger;

public class VMChannelImpl
implements VMChannel,
Runnable {
    private static Logger logger;
    private static VMChannelManagerBase channelManager;
    private static String vmName;
    public static final int DEFAULT_PRIORITY = 0;
    protected final int channelID;
    protected int messageID = 1;
    protected VMMessageQueue queue = null;
    private VMChannelState state = null;
    protected volatile VMMessageHandler messageHandler = null;
    protected VMControlHandler controlHandler = null;
    private boolean waitingForMessage = false;
    private boolean listening = false;
    private boolean deferredMode = false;
    private Thread thisThread = null;
    private YesNo ableToSend = new YesNo(false);
    private final Object handlerLock = new Object();

    public VMChannelImpl(int n) throws VMChannelException {
        this.channelID = n;
        this.state = n == 0 ? VMChannelState.CREATED : VMChannelState.INITIALIZED;
        this.ableToSend.setTo(n == 0);
        this.queue = VMMessageQueueFactory.getQueue(n);
        channelManager.createChannelImpl(this.channelID);
    }

    public int getID() {
        return this.channelID;
    }

    public boolean isAbleToSendMessage() {
        return this.ableToSend.isYes();
    }

    public void sendMessage(byte[] byArray) throws NoListenerException {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("Message Data is null/empty");
        }
        this.sendMessage(this.newMessage(0, byArray));
    }

    public void sendMessage(VMMessage vMMessage) throws NoListenerException {
        if (this.ableToSend.isNo()) {
            throw new NoListenerException(this + " is not able-to-send");
        }
        this.queue.sendMessage(vMMessage);
    }

    public VMMessage newMessage(int n, byte[] byArray, int n2, int n3) {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("Message Data is null/empty");
        }
        if (n2 != 0 || n3 != byArray.length) {
            byte[] byArray2 = byArray;
            byArray = new byte[n3];
            System.arraycopy(byArray2, n2, byArray, 0, n3);
        }
        return new VMMessageImpl(n, this.channelID, this.getNextMessageID(), byArray);
    }

    public VMMessage newMessage(int n, byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("Message Data is null/empty");
        }
        return this.newMessage(n, byArray, 0, byArray.length);
    }

    public VMMessage readMessage() {
        return this.queue.readMessage(true);
    }

    public VMMessage peekMessage() {
        return this.queue.readMessage(false);
    }

    public int size() {
        return this.queue.size();
    }

    public VMChannelState getState() {
        return this.state;
    }

    public void setState(VMChannelState vMChannelState) {
        this.state = vMChannelState;
    }

    public void clear() {
        this.queue.clear();
    }

    public String toString() {
        return "[" + vmName + " Channel-" + this.channelID + ", State=" + this.state + ", ableToSend=" + this.ableToSend + "] - ";
    }

    protected final synchronized int getNextMessageID() {
        return this.messageID++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startListening(VMMessageHandler vMMessageHandler) throws ChannelNotAvailableException {
        if (this.listening) {
            return;
        }
        if (vMMessageHandler == null) {
            throw new NullPointerException("MessageHandler is null");
        }
        if (this.state != VMChannelState.CREATED) {
            throw new ChannelNotAvailableException(this + "is about to be closed (or) not ready to listen");
        }
        Object object = this.handlerLock;
        synchronized (object) {
            this.messageHandler = vMMessageHandler;
        }
        this.ableToSend.setTo(true);
        this.listening = true;
        this.deferredMode = false;
        this.thisThread = new Thread(this);
        this.thisThread.start();
        if (this.getID() != 0) {
            channelManager.issueControlMessage(68, this.channelID);
        }
    }

    public synchronized void stopListening(boolean bl) throws ChannelNotAvailableException {
        if (this.state == VMChannelState.DELETING || this.state == VMChannelState.CLOSED) {
            throw new ChannelNotAvailableException(this + "is being deleted or closed already.");
        }
        this.ableToSend.setTo(false);
        if (bl) {
            this.deferredMode = true;
        } else {
            this.listening = false;
            this.deferredMode = false;
        }
        if (this.channelID != 0) {
            channelManager.issueControlMessage(102, this.channelID);
        }
        if (this.waitingForMessage) {
            this.thisThread.interrupt();
            this.waitingForMessage = false;
        }
    }

    public void setControlHandler(VMControlHandler vMControlHandler) {
        this.controlHandler = vMControlHandler;
    }

    public VMMessage newControlMessage(int n, int n2) {
        return new VMMessageImpl(n, 1, n2, this.getNextMessageID(), null);
    }

    public void issueControlMessage(int n, int n2) {
        try {
            this.sendMessage(this.newControlMessage(n, n2));
        }
        catch (VMChannelException vMChannelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        VMMessage vMMessage = null;
        while (this.listening) {
            this.waitingForMessage = true;
            if (this.deferredMode && this.size() <= 0) {
                this.listening = false;
                break;
            }
            vMMessage = this.readMessage();
            this.waitingForMessage = false;
            if (vMMessage.isControlMessage()) {
                if (this.getID() != 0) continue;
                this.processControlMessage(vMMessage);
                continue;
            }
            if (!this.listening) break;
            Object object = this.handlerLock;
            synchronized (object) {
                if (this.messageHandler != null) {
                    this.messageHandler.handle(vMMessage);
                }
            }
        }
        this.clear();
        this.thisThread = null;
    }

    private void processControlMessage(VMMessage vMMessage) {
        switch (vMMessage.getHeader().getType()) {
            case 34: {
                this.processCreateChannelMessage(vMMessage);
                break;
            }
            case 51: {
                this.processCreateChannelConfMessage(vMMessage);
                break;
            }
            case 68: {
                this.processStartListeningMessage(vMMessage);
                break;
            }
            case 85: {
                this.processStartListeningConfMessage(vMMessage);
                break;
            }
            case 102: {
                this.processStopListeningMessage(vMMessage);
                break;
            }
            case 119: {
                this.processStopListeningConfMessage(vMMessage);
                break;
            }
            case 136: {
                this.processDeleteChannelMessage(vMMessage);
                break;
            }
            case 153: {
                this.processDeleteChannelConfMessage(vMMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreateChannelMessage(VMMessage vMMessage) {
        int n = vMMessage.getHeader().getChannelID();
        VMChannel vMChannel = null;
        boolean bl = false;
        Object object = VMChannelManagerBase.GOVERNOR;
        synchronized (object) {
            vMChannel = channelManager.lookupChannel(n);
            if (vMChannel == null) {
                try {
                    vMChannel = channelManager.createAndAddToTable(n);
                    bl = true;
                }
                catch (VMChannelException vMChannelException) {
                    // empty catch block
                }
            }
            if (vMChannel.getState() == VMChannelState.INITIALIZED || vMChannel.getState() == VMChannelState.CREATING) {
                ((VMChannelImpl)vMChannel).setState(VMChannelState.CREATED);
            }
            channelManager.createConfirmReceived(n);
        }
        channelManager.issueControlMessage(51, n);
        if (bl && this.controlHandler != null) {
            this.controlHandler.channelCreated(vMChannel);
        }
    }

    private void processCreateChannelConfMessage(VMMessage vMMessage) {
        try {
            channelManager.createConfirmReceived(vMMessage.getHeader().getChannelID());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processStartListeningMessage(VMMessage vMMessage) {
        try {
            VMChannel vMChannel = channelManager.lookupChannel(vMMessage.getHeader().getChannelID());
            if (vMChannel != null) {
                if (vMChannel.getState() == VMChannelState.DELETING || vMChannel.getState() == VMChannelState.CLOSED) {
                    throw new VMChannelException(this + "received CONTROL_MESSAGE_START_LISTENING for inconsistent state channel " + vMChannel);
                }
                ((VMChannelImpl)vMChannel).ableToSend.setTo(true);
                channelManager.issueControlMessage(85, vMChannel.getID());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processStartListeningConfMessage(VMMessage vMMessage) {
    }

    private void processStopListeningMessage(VMMessage vMMessage) {
        VMChannel vMChannel = channelManager.lookupChannel(vMMessage.getHeader().getChannelID());
        if (vMChannel != null) {
            ((VMChannelImpl)vMChannel).ableToSend.setTo(false);
            channelManager.issueControlMessage(119, vMChannel.getID());
        }
    }

    private void processStopListeningConfMessage(VMMessage vMMessage) {
        VMChannelImpl vMChannelImpl = (VMChannelImpl)channelManager.lookupChannel(vMMessage.getHeader().getChannelID());
        if (vMChannelImpl != null && !vMChannelImpl.deferredMode) {
            vMChannelImpl.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeleteChannelMessage(VMMessage vMMessage) {
        VMChannel vMChannel = null;
        boolean bl = false;
        int n = vMMessage.getHeader().getChannelID();
        Object object = VMChannelManagerBase.GOVERNOR;
        synchronized (object) {
            vMChannel = channelManager.lookupChannel(n);
            if (vMChannel != null) {
                try {
                    vMChannel.stopListening(false);
                    channelManager.removeFromTable(vMChannel);
                    ((VMChannelImpl)vMChannel).setState(VMChannelState.CLOSED);
                    bl = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            channelManager.deleteConfirmReceived(n);
        }
        if (n != 0) {
            channelManager.issueControlMessage(153, n);
        }
        if (bl && this.controlHandler != null) {
            this.controlHandler.channelDeleted(vMChannel);
        }
    }

    private void processDeleteChannelConfMessage(VMMessage vMMessage) {
        channelManager.deleteConfirmReceived(vMMessage.getHeader().getChannelID());
    }

    static {
        try {
            channelManager = (VMChannelManagerBase)VMChannelManagerFactory.getChannelManager();
        }
        catch (VMChannelException vMChannelException) {
            // empty catch block
        }
        vmName = System.getProperty("java.vm.name");
    }
}

