/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cvm.channel;

import com.oracle.cvm.channel.VMChannelException;
import com.oracle.cvm.channel.VMChannelManager;
import com.sun.util.logging.Logger;

public class VMChannelManagerFactory {
    private static Logger logger;
    static VMChannelManager channelManager;

    public static synchronized VMChannelManager getChannelManager() throws VMChannelException {
        if (channelManager != null) {
            return channelManager;
        }
        String string = System.getProperty("oracle.cvm.channel.manager.impl");
        Class<?> clazz = null;
        if (string == null) {
            String string2 = System.getProperty("os.name");
            String string3 = System.getProperty("java.vm.name");
            if (string2 == null) {
                throw new VMChannelException("os.name property is not available");
            }
            if (string3 == null) {
                throw new VMChannelException("java.vm.name property is not available");
            }
            string2 = string2.replace(' ', '_');
            string2 = string2.replace('.', '_');
            string3 = string3.replace(' ', '_');
            string3 = string3.replace('.', '_');
            string = "com.oracle.cvm.channel." + string2 + "_" + string3 + ".VMChannelManagerImpl";
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new VMChannelException(classNotFoundException.getMessage());
        }
        try {
            channelManager = (VMChannelManager)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new VMChannelException(exception);
        }
        return channelManager;
    }
}

