/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class SelfClosingOutputStream
extends FilterOutputStream {
    private Socket sock = null;
    private OutputStream ostream;

    public SelfClosingOutputStream(OutputStream outputStream, Socket socket) {
        super(outputStream);
        this.ostream = outputStream;
        this.sock = socket;
    }

    public void write(int n) throws IOException {
        if (this.sock == null) {
            throw new IOException("OutputStream or Socket do not exist");
        }
        if (!this.sock.isConnected()) {
            throw new IOException("Socket is not connected");
        }
        if (this.sock.isClosed()) {
            return;
        }
        try {
            this.ostream.write(n);
        }
        catch (IOException iOException) {
            this.closeSocket();
            return;
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.sock == null) {
            throw new IOException("OutputStream or Socket do not exist");
        }
        if (!this.sock.isConnected()) {
            throw new IOException("Socket is not connected");
        }
        if (this.sock.isClosed()) {
            return;
        }
        try {
            this.ostream.write(byArray);
        }
        catch (IOException iOException) {
            this.closeSocket();
            return;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.sock == null) {
            throw new IOException("OutputStream or Socket do not exist");
        }
        if (!this.sock.isConnected()) {
            throw new IOException("Socket is not connected");
        }
        if (this.sock.isClosed()) {
            return;
        }
        try {
            this.ostream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.closeSocket();
            return;
        }
    }

    public void flush() throws IOException {
        try {
            this.ostream.flush();
        }
        catch (IOException iOException) {
            this.closeSocket();
            return;
        }
    }

    public void close() throws IOException {
        try {
            this.ostream.close();
        }
        catch (IOException iOException) {
            this.closeSocket();
            return;
        }
    }

    private void closeSocket() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

