/*
 * Decompiled with CFR 0.152.
 */
package com.sun.util.logging;

import com.sun.util.logging.Formatter;
import com.sun.util.logging.LogRecord;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.util.HashMap;
import sun.security.action.GetPropertyAction;

public class ExtremelySimpleFormatter
extends Formatter {
    private static long timeOffset = 0L;
    private HashMap shortNameMap = new HashMap();
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public ExtremelySimpleFormatter() {
        if (!this.lineSeparator.startsWith("\r")) {
            this.lineSeparator = "\r" + this.lineSeparator;
        }
    }

    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        if (timeOffset == 0L) {
            timeOffset = logRecord.getMillis();
        }
        stringBuffer.append("[");
        stringBuffer.append(logRecord.getMillis() - timeOffset);
        if (stringBuffer.length() < 9) {
            switch (stringBuffer.length()) {
                case 2: {
                    stringBuffer.append("       ");
                    break;
                }
                case 3: {
                    stringBuffer.append("      ");
                    break;
                }
                case 4: {
                    stringBuffer.append("     ");
                    break;
                }
                case 5: {
                    stringBuffer.append("    ");
                    break;
                }
                case 6: {
                    stringBuffer.append("   ");
                    break;
                }
                case 7: {
                    stringBuffer.append("  ");
                    break;
                }
                case 8: {
                    stringBuffer.append(" ");
                    break;
                }
            }
        }
        stringBuffer.append("|");
        stringBuffer.append(logRecord.getLevel().getLocalizedName());
        stringBuffer.append("|");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("] ");
        stringBuffer.append(this.shorten(logRecord.getLoggerName()));
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(".");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        stringBuffer.append(": ");
        String string = this.formatMessage(logRecord);
        stringBuffer.append(string);
        stringBuffer.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private String shorten(String string) {
        if (string == null) {
            return null;
        }
        String string2 = (String)this.shortNameMap.get(string);
        if (string2 == null) {
            int n = string.lastIndexOf(".") + 1;
            if (n > 0 && n < string.length()) {
                this.shortNameMap.put(string, string.substring(n));
            } else {
                this.shortNameMap.put(string, string);
            }
            string2 = (String)this.shortNameMap.get(string);
        }
        return string2;
    }
}

