/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cdc.io.j2me.ssl;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.microedition.pki.Certificate;

public class PkiCertificate
implements Certificate {
    private X509Certificate x509ServerCert = null;
    private static final char SERIAL_NUM_DELIMITER_CHAR = ':';

    public PkiCertificate(java.security.cert.Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            this.x509ServerCert = (X509Certificate)certificate;
        } else {
            System.out.println("OOPS not an X509Certificate");
        }
    }

    public String getIssuer() {
        return this.dnToRFC1779(this.x509ServerCert.getIssuerDN().getName());
    }

    public long getNotAfter() {
        return this.x509ServerCert.getNotAfter().getTime();
    }

    public long getNotBefore() {
        return this.x509ServerCert.getNotBefore().getTime();
    }

    public String getSerialNumber() {
        BigInteger bigInteger = this.x509ServerCert.getSerialNumber();
        if (bigInteger == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(bigInteger.longValue()).toUpperCase());
        if (stringBuffer.length() % 2 != 0) {
            stringBuffer = stringBuffer.insert(0, '0');
        }
        for (int i = 2; i < stringBuffer.length(); i += 2) {
            stringBuffer = stringBuffer.insert(i++, ':');
        }
        return stringBuffer.toString();
    }

    public String getSigAlgName() {
        return this.x509ServerCert.getSigAlgName();
    }

    public String getSubject() {
        return this.dnToRFC1779(this.x509ServerCert.getSubjectDN().getName());
    }

    public Collection getSubjectAlternativeNames() {
        try {
            return this.x509ServerCert.getSubjectAlternativeNames();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getType() {
        return "X.509";
    }

    public String getVersion() {
        return String.valueOf(this.x509ServerCert.getVersion());
    }

    private String dnToRFC1779(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = stringBuffer.indexOf(",");
        int n5 = stringBuffer.indexOf(";");
        while (n4 >= 0 || n5 >= 0) {
            int n6 = n5 < 0 ? n4 : (n4 < 0 ? n5 : Math.min(n4, n5));
            if (n6 >= 0 && (n2 += this.countQuotes(string, n3, n6)) != 1 && !PkiCertificate.escaped(n6, n3, string)) {
                if (stringBuffer.charAt(n6) == ',') {
                    stringBuffer.setCharAt(n6, ';');
                }
                n = n6 + 1;
                n2 = 0;
            }
            n3 = n6 + 1;
            n4 = stringBuffer.indexOf(",", n3);
            n5 = stringBuffer.indexOf(";", n3);
        }
        return stringBuffer.toString();
    }

    private int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if ((string.charAt(i) != '\"' || i != n) && (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\')) continue;
            ++n3;
        }
        return n3;
    }

    private static boolean escaped(int n, int n2, String string) {
        if (n == 1 && string.charAt(n - 1) == '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) != '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) == '\\') {
            int n3 = 0;
            --n;
            while (n >= n2) {
                if (string.charAt(n) == '\\') {
                    ++n3;
                }
                --n;
            }
            return n3 % 2 != 0;
        }
        return false;
    }
}

